/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import com.l2jserver.Config;
import com.l2jserver.gameserver.scripting.CompiledScriptCache;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javolution.util.FastMap;

public final class L2ScriptEngineManager {
    private static final Logger _log = Logger.getLogger(L2ScriptEngineManager.class.getName());
    public static final File SCRIPT_FOLDER = new File(Config.DATAPACK_ROOT.getAbsolutePath(), "data/scripts");
    private final Map<String, ScriptEngine> _nameEngines = new FastMap();
    private final Map<String, ScriptEngine> _extEngines = new FastMap();
    private final List<ScriptManager<?>> _scriptManagers = new LinkedList();
    private final CompiledScriptCache _cache;
    private File _currentLoadingScript;
    private static final boolean VERBOSE_LOADING = false;
    private static final boolean ATTEMPT_COMPILATION = true;
    private static final boolean USE_COMPILED_CACHE = false;
    private static final boolean PURGE_ERROR_LOG = true;

    public static L2ScriptEngineManager getInstance() {
        return SingletonHolder._instance;
    }

    private L2ScriptEngineManager() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = scriptEngineManager.getEngineFactories();
        this._cache = null;
        _log.info("Initializing Script Engine Manager");
        for (ScriptEngineFactory factory : factories) {
            try {
                ScriptEngine engine = factory.getScriptEngine();
                boolean reg = false;
                for (String name : factory.getNames()) {
                    double existentEngVer;
                    double engineVer;
                    ScriptEngine existentEngine = this._nameEngines.get(name);
                    if (existentEngine != null && (engineVer = Double.parseDouble(factory.getEngineVersion())) <= (existentEngVer = Double.parseDouble(existentEngine.getFactory().getEngineVersion()))) continue;
                    reg = true;
                    this._nameEngines.put(name, engine);
                }
                if (reg) {
                    _log.info("Script Engine: " + factory.getEngineName() + " " + factory.getEngineVersion() + " - Language: " + factory.getLanguageName() + " - Language Version: " + factory.getLanguageVersion());
                }
                for (String ext : factory.getExtensions()) {
                    if (ext.equals("java") && !factory.getLanguageName().equals("java")) continue;
                    this._extEngines.put(ext, engine);
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed initializing factory: " + e.getMessage(), e);
            }
        }
        this.preConfigure();
    }

    private void preConfigure() {
        String dataPackDirForwardSlashes = SCRIPT_FOLDER.getPath().replaceAll("\\\\", "/");
        String configScript = "import sys;sys.path.insert(0,'" + dataPackDirForwardSlashes + "');";
        try {
            this.eval("jython", configScript);
        }
        catch (ScriptException e) {
            _log.severe("Failed preconfiguring jython: " + e.getMessage());
        }
    }

    private ScriptEngine getEngineByName(String name) {
        return this._nameEngines.get(name);
    }

    private ScriptEngine getEngineByExtension(String ext) {
        return this._extEngines.get(ext);
    }

    public void executeScriptList(File list) throws IOException {
        LineNumberReader lnr;
        File file;
        if (!Config.ALT_DEV_NO_HANDLERS && Config.ALT_DEV_NO_QUESTS) {
            file = new File(SCRIPT_FOLDER, "handlers/MasterHandler.java");
            try {
                this.executeScript(file);
                _log.info("Handlers loaded, all other scripts skipped");
                return;
            }
            catch (ScriptException se) {
                _log.log(Level.WARNING, "", se);
            }
        }
        if (Config.ALT_DEV_NO_QUESTS) {
            return;
        }
        if (list.isFile()) {
            String line;
            lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(list)));
            while ((line = lnr.readLine()) != null) {
                String[] parts;
                if (Config.ALT_DEV_NO_HANDLERS && line.contains("MasterHandler.java") || (parts = line.trim().split("#")).length <= 0 || parts[0].startsWith("#") || parts[0].length() <= 0) continue;
                line = parts[0];
                if (line.endsWith("/**")) {
                    line = line.substring(0, line.length() - 3);
                } else if (line.endsWith("/*")) {
                    line = line.substring(0, line.length() - 2);
                }
                file = new File(SCRIPT_FOLDER, line);
                if (file.isDirectory() && parts[0].endsWith("/**")) {
                    this.executeAllScriptsInDirectory(file, true, 32);
                    continue;
                }
                if (file.isDirectory() && parts[0].endsWith("/*")) {
                    this.executeAllScriptsInDirectory(file);
                    continue;
                }
                if (file.isFile()) {
                    try {
                        this.executeScript(file);
                    }
                    catch (ScriptException e) {
                        this.reportScriptFileError(file, e);
                    }
                    continue;
                }
                _log.warning("Failed loading: (" + file.getCanonicalPath() + ") @ " + list.getName() + ":" + lnr.getLineNumber() + " - Reason: doesnt exists or is not a file.");
            }
        } else {
            throw new IllegalArgumentException("Argument must be an file containing a list of scripts to be loaded");
        }
        lnr.close();
    }

    public void executeAllScriptsInDirectory(File dir) {
        this.executeAllScriptsInDirectory(dir, false, 0);
    }

    public void executeAllScriptsInDirectory(File dir, boolean recurseDown, int maxDepth) {
        this.executeAllScriptsInDirectory(dir, recurseDown, maxDepth, 0);
    }

    private void executeAllScriptsInDirectory(File dir, boolean recurseDown, int maxDepth, int currentDepth) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory() && recurseDown && maxDepth > currentDepth) {
                    this.executeAllScriptsInDirectory(file, recurseDown, maxDepth, currentDepth + 1);
                    continue;
                }
                if (!file.isFile()) continue;
                try {
                    String extension;
                    ScriptEngine engine;
                    String name = file.getName();
                    int lastIndex = name.lastIndexOf(46);
                    if (lastIndex == -1 || (engine = this.getEngineByExtension(extension = name.substring(lastIndex + 1))) == null) continue;
                    this.executeScript(engine, file);
                }
                catch (FileNotFoundException e) {
                    _log.log(Level.WARNING, "", e);
                }
                catch (ScriptException e) {
                    this.reportScriptFileError(file, e);
                }
            }
        } else {
            throw new IllegalArgumentException("The argument directory either doesnt exists or is not an directory.");
        }
    }

    public CompiledScriptCache getCompiledScriptCache() throws IOException {
        return this._cache;
    }

    public CompiledScriptCache loadCompiledScriptCache() {
        return null;
    }

    public void executeScript(File file) throws ScriptException, FileNotFoundException {
        String name = file.getName();
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex == -1) {
            throw new ScriptException("Script file (" + name + ") doesnt has an extension that identifies the ScriptEngine to be used.");
        }
        String extension = name.substring(lastIndex + 1);
        ScriptEngine engine = this.getEngineByExtension(extension);
        if (engine == null) {
            throw new ScriptException("No engine registered for extension (" + extension + ")");
        }
        this.executeScript(engine, file);
    }

    public void executeScript(String engineName, File file) throws FileNotFoundException, ScriptException {
        ScriptEngine engine = this.getEngineByName(engineName);
        if (engine == null) {
            throw new ScriptException("No engine registered with name (" + engineName + ")");
        }
        this.executeScript(engine, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(ScriptEngine engine, File file) throws FileNotFoundException, ScriptException {
        SimpleScriptContext context;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String name = file.getAbsolutePath() + ".error.log";
        File errorLog = new File(name);
        if (errorLog.isFile()) {
            errorLog.delete();
        }
        if (engine instanceof Compilable) {
            context = new SimpleScriptContext();
            context.setAttribute("mainClass", L2ScriptEngineManager.getClassForFile(file).replace('/', '.').replace('\\', '.'), 100);
            context.setAttribute("javax.script.filename", file.getName(), 100);
            context.setAttribute("classpath", SCRIPT_FOLDER.getAbsolutePath(), 100);
            context.setAttribute("sourcepath", SCRIPT_FOLDER.getAbsolutePath(), 100);
            this.setCurrentLoadingScript(file);
            ScriptContext ctx = engine.getContext();
            try {
                engine.setContext(context);
                System.out.println(" script compiling: " + context.getAttribute("mainClass", 100));
                Compilable eng = (Compilable)((Object)engine);
                CompiledScript cs = eng.compile(reader);
                cs.eval(context);
            }
            finally {
                engine.setContext(ctx);
                this.setCurrentLoadingScript(null);
                context.removeAttribute("javax.script.filename", 100);
                context.removeAttribute("mainClass", 100);
            }
        }
        context = new SimpleScriptContext();
        context.setAttribute("mainClass", L2ScriptEngineManager.getClassForFile(file).replace('/', '.').replace('\\', '.'), 100);
        context.setAttribute("javax.script.filename", file.getName(), 100);
        context.setAttribute("classpath", SCRIPT_FOLDER.getAbsolutePath(), 100);
        context.setAttribute("sourcepath", SCRIPT_FOLDER.getAbsolutePath(), 100);
        this.setCurrentLoadingScript(file);
        try {
            engine.eval((Reader)reader, (ScriptContext)context);
        }
        finally {
            this.setCurrentLoadingScript(null);
            engine.getContext().removeAttribute("javax.script.filename", 100);
            engine.getContext().removeAttribute("mainClass", 100);
        }
    }

    public static String getClassForFile(File script) {
        String scpPath;
        String path = script.getAbsolutePath();
        if (path.startsWith(scpPath = SCRIPT_FOLDER.getAbsolutePath())) {
            int idx = path.lastIndexOf(46);
            return path.substring(scpPath.length() + 1, idx);
        }
        return null;
    }

    public ScriptContext getScriptContext(ScriptEngine engine) {
        return engine.getContext();
    }

    public ScriptContext getScriptContext(String engineName) {
        ScriptEngine engine = this.getEngineByName(engineName);
        if (engine == null) {
            throw new IllegalStateException("No engine registered with name (" + engineName + ")");
        }
        return this.getScriptContext(engine);
    }

    public Object eval(ScriptEngine engine, String script, ScriptContext context) throws ScriptException {
        if (engine instanceof Compilable) {
            Compilable eng = (Compilable)((Object)engine);
            CompiledScript cs = eng.compile(script);
            return context != null ? cs.eval(context) : cs.eval();
        }
        return context != null ? engine.eval(script, context) : engine.eval(script);
    }

    public Object eval(String engineName, String script) throws ScriptException {
        return this.eval(engineName, script, null);
    }

    public Object eval(String engineName, String script, ScriptContext context) throws ScriptException {
        ScriptEngine engine = this.getEngineByName(engineName);
        if (engine == null) {
            throw new ScriptException("No engine registered with name (" + engineName + ")");
        }
        return this.eval(engine, script, context);
    }

    public Object eval(ScriptEngine engine, String script) throws ScriptException {
        return this.eval(engine, script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportScriptFileError(File script, ScriptException e) {
        String dir = script.getParent();
        String name = script.getName() + ".error.log";
        if (dir != null) {
            File file = new File(dir + "/" + name);
            FileOutputStream fos = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fos = new FileOutputStream(file);
                String errorHeader = "Error on: " + file.getCanonicalPath() + "\r\nLine: " + e.getLineNumber() + " - Column: " + e.getColumnNumber() + "\r\n\r\n";
                fos.write(errorHeader.getBytes());
                fos.write(e.getMessage().getBytes());
                _log.warning("Failed executing script: " + script.getAbsolutePath() + ". See " + file.getName() + " for details.");
            }
            catch (IOException ioe) {
                _log.log(Level.WARNING, "Failed executing script: " + script.getAbsolutePath() + "\r\n" + e.getMessage() + "Additionally failed when trying to write an error report on script directory. Reason: " + ioe.getMessage(), ioe);
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception e1) {}
            }
        } else {
            _log.log(Level.WARNING, "Failed executing script: " + script.getAbsolutePath() + "\r\n" + e.getMessage() + "Additionally failed when trying to write an error report on script directory.", e);
        }
    }

    public void registerScriptManager(ScriptManager<?> manager) {
        this._scriptManagers.add(manager);
    }

    public void removeScriptManager(ScriptManager<?> manager) {
        this._scriptManagers.remove(manager);
    }

    public List<ScriptManager<?>> getScriptManagers() {
        return this._scriptManagers;
    }

    protected void setCurrentLoadingScript(File currentLoadingScript) {
        this._currentLoadingScript = currentLoadingScript;
    }

    protected File getCurrentLoadingScript() {
        return this._currentLoadingScript;
    }

    private static class SingletonHolder {
        protected static final L2ScriptEngineManager _instance = new L2ScriptEngineManager();

        private SingletonHolder() {
        }
    }
}

