/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.actor.L2Character;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class hitConditionBonus {
    protected static final Logger _log = Logger.getLogger(hitConditionBonus.class.getName());
    private static int frontBonus = 0;
    private static int sideBonus = 0;
    private static int backBonus = 0;
    private static int highBonus = 0;
    private static int lowBonus = 0;
    private static int darkBonus = 0;

    protected static double getConditionBonus(L2Character attacker, L2Character target) {
        double mod = 100.0;
        if (attacker.getZ() - target.getZ() > 50) {
            mod += (double)highBonus;
        } else if (attacker.getZ() - target.getZ() < -50) {
            mod += (double)lowBonus;
        }
        if (GameTimeController.getInstance().isNowNight()) {
            mod += (double)darkBonus;
        }
        mod = attacker.isBehindTarget() ? (mod += (double)backBonus) : (attacker.isInFrontOfTarget() ? (mod += (double)frontBonus) : (mod += (double)sideBonus));
        return Math.max(mod / 100.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/stats/hitConditionBonus.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "[hitConditionBonus] Could not parse file: " + e.getMessage(), e);
            }
            for (Node list = doc.getFirstChild(); list != null; list = list.getNextSibling()) {
                if (!"hitConditionBonus".equalsIgnoreCase(list.getNodeName()) && !"list".equalsIgnoreCase(list.getNodeName())) continue;
                for (Node cond = list.getFirstChild(); cond != null; cond = cond.getNextSibling()) {
                    int bonus = 0;
                    String name = cond.getNodeName();
                    try {
                        if (!cond.hasAttributes()) continue;
                        bonus = Integer.parseInt(cond.getAttributes().getNamedItem("val").getNodeValue());
                        continue;
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "[hitConditionBonus] Could not parse condition: " + e.getMessage(), e);
                        continue;
                    }
                    finally {
                        if ("front".equals(name)) {
                            frontBonus = bonus;
                        } else if ("side".equals(name)) {
                            sideBonus = bonus;
                        } else if ("back".equals(name)) {
                            backBonus = bonus;
                        } else if ("high".equals(name)) {
                            highBonus = bonus;
                        } else if ("low".equals(name)) {
                            lowBonus = bonus;
                        } else if ("dark".equals(name)) {
                            darkBonus = bonus;
                        }
                    }
                }
            }
        } else {
            throw new Error("[hitConditionBonus] File not found: " + file.getName());
        }
    }
}

