/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import java.util.logging.Level;

public class L2SkillAppearance
extends L2Skill {
    private final int _faceId;
    private final int _hairColorId;
    private final int _hairStyleId;

    public L2SkillAppearance(StatsSet set) {
        super(set);
        this._faceId = set.getInteger("faceId", -1);
        this._hairColorId = set.getInteger("hairColorId", -1);
        this._hairStyleId = set.getInteger("hairStyleId", -1);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        try {
            for (L2Object target : targets) {
                if (!(target instanceof L2PcInstance)) continue;
                L2PcInstance targetPlayer = (L2PcInstance)target;
                if (this._faceId >= 0) {
                    targetPlayer.getAppearance().setFace(this._faceId);
                }
                if (this._hairColorId >= 0) {
                    targetPlayer.getAppearance().setHairColor(this._hairColorId);
                }
                if (this._hairStyleId >= 0) {
                    targetPlayer.getAppearance().setHairStyle(this._hairStyleId);
                }
                targetPlayer.broadcastUserInfo();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }
}

