/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2EffectPointInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Point3D;

public final class L2SkillSignet
extends L2Skill {
    private int _effectNpcId;
    public int effectId;

    public L2SkillSignet(StatsSet set) {
        super(set);
        this._effectNpcId = set.getInteger("effectNpcId", -1);
        this.effectId = set.getInteger("effectId", -1);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        Point3D wordPosition;
        if (caster.isAlikeDead()) {
            return;
        }
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(this._effectNpcId);
        L2EffectPointInstance effectPoint = new L2EffectPointInstance(IdFactory.getInstance().getNextId(), template, caster);
        effectPoint.setCurrentHp(effectPoint.getMaxHp());
        effectPoint.setCurrentMp(effectPoint.getMaxMp());
        int x = caster.getX();
        int y = caster.getY();
        int z = caster.getZ();
        if (caster instanceof L2PcInstance && this.getTargetType() == L2Skill.SkillTargetType.TARGET_GROUND && (wordPosition = ((L2PcInstance)caster).getCurrentSkillWorldPosition()) != null) {
            x = wordPosition.getX();
            y = wordPosition.getY();
            z = wordPosition.getZ();
        }
        this.getEffects(caster, effectPoint);
        effectPoint.setIsInvul(true);
        effectPoint.spawnMe(x, y, z);
    }
}

