/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import java.util.Collection;

import ai.group_template.L2AttackableAIScript;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.GrandBossState.StateEnum;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo.NpcInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.util.Rnd;

/**
 * Benom AI
 * @author theOne
 *      "benom.py" l2jfree-datapack rev6024, timestamp 2009/06/01 04:08:49
 * JOJO Translate
 *      "benom.py" to "Benom.java"
 */

public class Benom extends L2AttackableAIScript
		implements L2GrandBossInstance.IEvtArrived
{
	private static final boolean DEBUG = true;

	private static final boolean OPTION1 = true;
					//JOJO [ύX
					// Ȅ傪mob̂Ƃ́A
					//   xm(e|[^[)`߂̉ɏoA
					//   Nłxm({X)𓢔邱ƂłB
					// Eɏ傪Ƃ́A
					//   xm(e|[^[)ʍ̊ԂɏoA
					//   ݂̌̂邱ƂłB

	private static final int BENOM = 29054;
	private static final int BENOM_TELEPORT = 13101;

	private static final int BENOM_SPAWN_TIME = 86400000;	//getSiegeDate()-24H
	private static final int BENOM_DESPAWN_TIME = 5400000;	//getSiegeDate()+1.5H

	private static final String[] benomSpeak =
	{
		  "You should have finished me when you had the chance!!!"
		, "I will crush all of you!!!"
		, "I am not finished here, come face me!!!"
		, "You cowards!!! I will torture each and everyone of you!!!"
	};

	private int checkState()
	{
		return GrandBossManager.getInstance().getBossStatus(BENOM);
	}

	private void updateState(int status)
	{
		if (checkState() != status)
		{
			GrandBossManager.getInstance().setBossStatus(BENOM, status);
			GrandBossManager.getInstance().setStatsSet(BENOM, null);
		}
	}

	@Override
	public L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffSet, long despawnDelay)
	{
		L2Npc npc = super.addSpawn(npcId, x, y, z, heading, randomOffSet, despawnDelay, false);
		if (DEBUG) SpawnTable.getInstance().addNewSpawn(npc.getSpawn(), false);
		return npc;
	}

	private void unspawnNpc(L2Npc npc)
	{
		npc.deleteMe();
		if (DEBUG) {
			SpawnTable.getInstance().deleteSpawn(npc.getSpawn(), false);
			int npcId = npc.getNpcId();
			for (L2Spawn spawn : SpawnTable.getInstance().getSpawnTable())
			{
				if (spawn != null && spawn.getNpcid() == npcId)
				{
					throw new AssertionError(npc.getNpcId()+npc.getName());
				}
			}
		}
	}

	private static final int[][] benomWalkRoutes = {
	//		      x      y     z  [door]
	/*0*/	 { 12565,-49739, -547 }
	/*1*/	,{ 11242,-49689,  -33 }
	/*2*/	,{ 10751,-49702,   83 }
	/*3*/	,{ 10824,-50808,  316 }
	/*4*/	,{  9084,-50786,  972 }
	/*5*/	,{  9095,-49787, 1252 }
	/*6*/	,{  8371,-49711, 1252 }
	/*7*/	,{  8423,-48545, 1252 }
	/*8*/	,{  9105,-48474, 1252 }
	/*9*/	,{  9085,-47488,  972 }
	/*10*/	,{ 10858,-47527,  316 }
	/*11*/	,{ 10842,-48626,   75 }
	/*12*/	,{ 12171,-48464, -547 }
	/*13*/	,{ 13565,-49145, -535 }
	/*14*/	,{ 15290,-49160,-1066 }
	/*15*/	,{ 15653,-49159,-1059, 1 }
	/*16*/	,{ 15423,-48402, -839 }
	/*17*/	,{ 15066,-47438, -419 }
	/*18*/	,{ 13990,-46843, -292 }
	/*19*/	,{ 13685,-47371, -163 }
	/*20*/	,{ 13384,-47470, -163 }
	/*21*/	,{ 14609,-48608,  346 }
	/*22*/	,{ 14301,-47906,  498 }
	/*23*/	,{ 13667,-47488,  743 }
	/*24*/	,{ 12894,-49109,  980 }
	/*25*/	,{ 10135,-49150,  996 }
	/*26*/	,{ 12894,-49109,  980 }
	/*27*/	,{ 13738,-50894,  747 }
	/*28*/	,{ 14398,-50314,  462 }
	/*29*/	,{ 14579,-49698,  347 }
	/*30*/	,{ 12896,-51135, -166 }
	/*31*/	,{ 12852,-51922, -295 }
	/*32*/	,{ 14275,-51487, -295 }
	/*33*/	,{ 15328,-50406, -603 }
	/*34*/	,{ 15594,-49192,-1059 }
	/*35*/	,{ 15060,-49160,-1023, 1 }
	/*36*/	,{ 12956,-49153, -537 }
	};

	private L2Npc _benom = null;
	private L2Npc _benomTeleport = null;
	private int _benomBlock;
	private int _benomWalkRouteStep = -1;

	//[JOJO]-------------------------------------------------
	private class SpecialCamera extends com.l2jserver.gameserver.network.serverpackets.SpecialCamera
	{
		public SpecialCamera(int id, int dist, int yaw, int pitch, int time, int duration)
		{
			super(id, dist, yaw, pitch, time, duration, 0, 0, 1, 0);
		}
	}
	//-------------------------------------------------------

	public Benom(int id, String name, String descr)
	{
		super(id,name,descr);

		// Quest NPC starter initialization
		addStartNpc(BENOM_TELEPORT);
		addTalkId(BENOM_TELEPORT);
		addAggroRangeEnterId(BENOM);
		addKillId(BENOM);

		switch (checkState()) {
		case StateEnum.DEAD:
		case StateEnum.INTERVAL:
			interval();
			break;
	/*	case StateEnum.NOTSPAWN: */
	/*	case StateEnum.ALIVE: */
		default:
    		init();
		}
	}

	/**
	 * U鎞24ԑOɂȂxm(e|ƃCh)zu悤^C}[ݒ
	 */
	private void init()
	{
		long now = System.currentTimeMillis();
		long siegeDate = CastleManager.getInstance().getCastleById(8).getSiegeDate().getTimeInMillis();
		if (now < siegeDate - /*24H*/BENOM_SPAWN_TIME)
		{
			long t = siegeDate - BENOM_SPAWN_TIME - now;
			updateState(StateEnum.NOTSPAWN);
			startQuestTimer("BenomRaidRoomSpawn", t, null, null);
		}
		else if (now < siegeDate + /*1.5H*/BENOM_DESPAWN_TIME)
		{
			long t = 1000;
			updateState(StateEnum.NOTSPAWN);
			startQuestTimer("BenomRaidRoomSpawn", t, null, null);
		}
		else
		{
			updateState(StateEnum.INTERVAL);
			interval();
		}
	}

	/**
	 * U(2)IĎ̓m肷܂(24)ҋ@
	 */
	private void interval()
	{
		long now = System.currentTimeMillis();
		long timeRegistrationOverDate = CastleManager.getInstance().getCastleById(8).getSiege().getTimeRegistrationOverDate().getTimeInMillis();
		long siegeDate = CastleManager.getInstance().getCastleById(8).getSiegeDate().getTimeInMillis();

		if (timeRegistrationOverDate < now && now < siegeDate - /*24H*/BENOM_SPAWN_TIME)
		{
			//̍U̓m肵Ă
			updateState(StateEnum.NOTSPAWN);
			init();
			return;
		}

		//̍U̓m肷܂(JԂ)҂
		long intervalTime = Math.max(21600000, timeRegistrationOverDate - now);
		startQuestTimer("interval", intervalTime, null, null);
	}

	private L2PcInstance getRandomPlayer(L2Npc npc)
	{
		Collection<L2PcInstance> knowns = npc.getKnownList().getKnownPlayers().values();
		if (knowns.size() <= 0)
			return null;
		L2PcInstance[] knownPlayers = new L2PcInstance[knowns.size()];
		int count = 0;
		for (L2PcInstance player : knowns)
		{
			if (player == null || player.isDead())
				continue;
			knownPlayers[count++] = player;
		}
		if (count > 0)
			return knownPlayers[Rnd.get(count)];
		else
			return null;
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		int castleOwner = CastleManager.getInstance().getCastleById(8).getOwnerId();
		int clanId = player.getClanId();
		if (castleOwner == 0 && OPTION1
		 || castleOwner != 0 && castleOwner == clanId)
		{
			int x =  12558 + Rnd.get(-100, 100);
			int y = -49279 + Rnd.get(-100, 100);
			player.teleToLocation(x, y, -3007);
			return null;
		}
		else
			return "<html><body>Benom's Avatar:<br>Your clan does not own this castle. Only members of this Castle's owning clan can challenge Benom.</body></html>";
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "BenomRaidRoomSpawn")
		{
			if (checkState() == StateEnum.DEAD)
			{
				return null;
			}

			_benom = addSpawn(BENOM, 12047, -49211, -3009, 0, false, 0);	//underground jail dungeon

			if (CastleManager.getInstance().getCastleById(8).getOwnerId() > 0)
			{
				_benomTeleport = addSpawn(BENOM_TELEPORT, 11013, -49629, -547, 13400, false, 0);	//throne room
			}
			else
			{
				_benomTeleport = addSpawn(BENOM_TELEPORT, 26969, -49278, -1305, 0, false, 0);	//out of the castle
			}
			
			_benomWalkRouteStep = -1;	//disable walk
			updateState(StateEnum.ALIVE);

			/**
			 * U鎞ɂȂgI̒xmneʍ̊ԂɃe|[g悤^C}[ݒ
			 */
			long now = System.currentTimeMillis();
			long siegeDate = CastleManager.getInstance().getCastleById(8).getSiegeDate().getTimeInMillis();
			long t = Math.max(1000, siegeDate - now);
			startQuestTimer("BenomRaidSiegeSpawn", t, _benom, null);
		}
		else if (event == "BenomRaidSiegeSpawn")
		{
			if (_benomTeleport != null)
			{
				unspawnNpc(_benomTeleport);
				_benomTeleport = null;
			}

			if (npc == null || npc.isDead() || ! npc.isVisible() || checkState() != StateEnum.ALIVE)
				return null;

			npc.teleToLocation(11025, -49152, -537);	//throne room
			startQuestTimer("BenomSpawnEffect", 100, npc, null);
			startQuestTimer("BenomBossDespawn", BENOM_DESPAWN_TIME, npc, null);
		}
		else if (event == "BenomSpawnEffect")
		{
			npc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
			npc.broadcastPacket(new SpecialCamera(npc.getObjectId(), 200, 0, 150, 0, 5000));
			npc.broadcastPacket(new SocialAction(npc, 3));

			_benomBlock = 0;
			_benomWalkRouteStep = benomWalkRoutes.length - 1;	//enable walk. next route is #0.
			startQuestTimer("BenomWalk", 5000, npc, null);
			((L2GrandBossInstance)npc).registerEvtArrived(this);
		}
		else if (event == "Attacking")
		{
			if (npc.isDead() || ! npc.isVisible())
				return null;

			L2PcInstance target;
			if ((target = getRandomPlayer(npc)) != null)
			{
				((L2Attackable)npc).addDamageHate(target, 0, 999);
				npc.setRunning();
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
				startQuestTimer("Attacking", 2000, npc, null);
			}
			else if (_benomWalkRouteStep >= 0)
			{
				 startQuestTimer("BenomJump", 20000, npc, null);
			}
		}
		else if (event == "BenomJump")
		{
			if (npc.isDead() || ! npc.isVisible())
				return null;

			cancelQuestTimers("Attacking");
			int[] route = benomWalkRoutes[_benomWalkRouteStep];
			int x = route[0];
			int y = route[1];
			int z = route[2];
			npc.teleToLocation(x, y, z);
			startQuestTimer("BenomWalk", 2200, npc, null);
		}
		else if (event == "BenomRetry")
		{
			if (npc.isDead() || ! npc.isVisible())
				return null;

			int[] route = benomWalkRoutes[_benomWalkRouteStep];
			int x = route[0];
			int y = route[1];
			int z = route[2];
			npc.setWalking();
			npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, z, 0));
		}
		else if (event == "BenomWalk")
		{
			if (npc.isDead() || ! npc.isVisible())
				return null;

			int[] route = benomWalkRoutes[_benomWalkRouteStep];
			if (route.length > 3)
				DoorTable.getInstance().getDoor(20160005).closeMe();

			if (Rnd.get(100) < 40)
				startQuestTimer("Talk", 100, npc, null);

			_benomBlock = 0;
			_benomWalkRouteStep = (_benomWalkRouteStep + 1) % benomWalkRoutes.length;
			route = benomWalkRoutes[_benomWalkRouteStep];
			int x = route[0];
			int y = route[1];
			int z = route[2];
			if (route.length > 3)
				DoorTable.getInstance().getDoor(20160005).openMe();
			npc.setWalking();
			npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, z, 0));
		}
		else if (event == "Talk")
		{
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), benomSpeak[Rnd.get(benomSpeak.length)]));
		}
		else if (event == "BenomBossDespawn")
		{
			cancelBenomTimers(npc);
			unspawnNpc(npc);
			_benom = npc = null;
			updateState(StateEnum.INTERVAL);
			interval();
		}
		else if (event == "interval")
		{
			interval();
		}
		else
		{
			throw new AssertionError();
		}
		return super.onAdvEvent(event, npc, player);
	}

	/*
	 * @see com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance.IEvtArrived#onEvtArrived(...)
	 */
	@Override public void onEvtArrived(L2Npc benom)
	{
		if (_benomWalkRouteStep >= 0)
		{
			final int[] route = benomWalkRoutes[_benomWalkRouteStep];
			final int x = route[0];
			final int y = route[1];
		//	final int z = route[2];
			if (benom.getX() == x && benom.getY() == y/* && npc.getZ() == z*/)
			{
				startQuestTimer("BenomWalk", 333 , benom, null);
			}
			else if (benom.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK)
			{
				if (getQuestTimer("Attacking", benom, null) == null)
					startQuestTimer("Attacking", 2000, benom, null);
			}
			else
			{
				if (++_benomBlock >= 2)
					startQuestTimer("BenomJump", 1000, benom, null);
				else
					startQuestTimer("BenomRetry", 100, benom, null);
			}
		}
	}

	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		cancelQuestTimers("BenomWalk");
		cancelQuestTimers("BenomJump");
		startQuestTimer("Attacking", 100, npc, null);
		return super.onAggroRangeEnter(npc, player, isPet);
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet) 
	{
		cancelBenomTimers(npc);
		unspawnNpc(npc);
		_benom = npc = null;

		if (_benomTeleport != null)
		{
			unspawnNpc(_benomTeleport);
			_benomTeleport = null;
		}

		updateState(StateEnum.DEAD);
		interval();
		return super.onKill(npc,killer,isPet);
	}

	private void cancelBenomTimers(L2Npc npc)
	{
		cancelQuestTimers("BenomWalk");
		cancelQuestTimers("BenomJump");
		cancelQuestTimers("BenomBossDespawn");
		cancelQuestTimers("Talk");
		cancelQuestTimers("Attacking");
		((L2GrandBossInstance)npc).registerEvtArrived(null);
	}

	/**
	 * DEBUG
	 */
	@SuppressWarnings("unused")
	private void visualizeWalkRoutes(L2PcInstance player)
	{
		final int npcId = 32467;
		
		for (int e = 0; e < benomWalkRoutes.length; e++) {
			final int[] route = benomWalkRoutes[e];
			final int[] next  = benomWalkRoutes[(e + 1) % benomWalkRoutes.length];

			final int x1 = route[0], y1 = route[1], z1 = route[2];
			L2Npc n = super.addSpawn(npcId, x1, y1, z1, 0, false, BENOM_DESPAWN_TIME/*86400000*/);
			n.setTitle("#"+e);
			n.broadcastPacket(new NpcInfo(n, null));

			final double dx = next[0] - x1, dy = next[1] - y1, dz = next[2] - z1;
			final double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
			final double pitch = 50;
			for (double p = pitch; p < distance; p += pitch) {
				double a = p / distance;
				int x = x1 + (int)Math.round(dx * a);
				int y = y1 + (int)Math.round(dy * a);
				int z = z1 + (int)Math.round(dz * a) + 20;
				L2ItemInstance i = new L2ItemInstance(IdFactory.getInstance().getNextId(), 57);
				if (player != null) i.setOwnerId(player.getObjectId());
				i.new ItemDropTask(i, null, x, y, z).run();
				i.setProtected(false);
				L2World.getInstance().storeObject(i);
			}
		}
	}

	public static void main(String[] args)
	{
		// now call the constructor (starts up the ai)
		new Benom(-1,"benom","ai");
	}
}
