/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.communitybbs.Manager.favorite;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AskJoinParty;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.TextReplacer;

/**
 * @author  TEN / nanasisaso / TSL / JOJO
 */
public class PartyMatch extends BaseFavoriteManager
{
	private static Logger _log = Logger.getLogger(PartyMatch.class.getName());
	private static PartyMatch _instance = new PartyMatch();

	/**
	 * @return
	 */
	public static PartyMatch getInstance()
	{
		return _instance;
	}

	@Override
	public void parsecmd(String command, L2PcInstance activeChar)
	{
				if (activeChar == null) return;
	
				// _bbsgetfav;bbs_party_match;****
	
				String subcmd = getArgs(command);
				if (subcmd.startsWith("_menu"))
				{
					int roomId = getRoomIdByCharId(activeChar.getObjectId());
					if (roomId != -1)
					{
						//Qς݂ȂQĂ\B
						showPartyRoom(activeChar, roomId);
					}
					else
					{
						String[] values = subcmd.split(" ");
						//QȂ烊Xg\B
						if (values.length == 3)
							showPartyRoomList(activeChar, values[1], values[2]);
						else
							showPartyRoomList(activeChar, null, null);
					}
				}
				//p[eB[[J݉
				else if (subcmd.startsWith("_createRoomWindow"))
				{
					showConfigWindow(activeChar, "party_match/createPartyRoom.htm");
					return;
				}
				//_createRoom min max limit lootdist title
				else if (subcmd.startsWith("_createRoom"))
				{
					String[] values = subcmd.split(" *\\| *", 7);
					//ڂĂȂ΃G[
					if (values.length != 7)
					{
						activeChar.sendMessage("p[eB[ [̊J݂Ɏs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = getRoomIdByCharId(activeChar.getObjectId()); //values[1] is dummy.
							int min = Integer.parseInt(values[2]);
							int max = Integer.parseInt(values[3]);
							int limit = Integer.parseInt(values[4]);
							int lootdist = Integer.parseInt(values[5]);
							String title = values[6];
							if (roomId != -1)
								modifyPartyRoom(activeChar, roomId, min, max, limit, lootdist, title);
							else
								roomId = createPartyRoom(activeChar, min, max, limit, lootdist, title);
							if (roomId > -1)
								showPartyRoom(activeChar, roomId);
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eB[ [̊J݂Ɏs܂B");
							return;
						}
					}
				}
				//p[eB[[ݒύX
				else if (subcmd.startsWith("_modifyRoomWindow"))
				{
					showConfigWindow(activeChar, "party_match/modifyPartyRoom.htm");
					return;
				}
				//_modifyRoom roomid min max limit lootdist title
				else if (subcmd.startsWith("_modifyRoom"))
				{
					String[] values = subcmd.split(" *\\| *", 7);
					//ڂĂȂ΃G[
					if (values.length != 7)
					{
						activeChar.sendMessage("p[eB[ [ݒ̕ύXɎs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = Integer.parseInt(values[1]);
							PartyRoomInfo pi = getPartyRoomInfo(roomId);
							int min = values[2].matches("\\d+") ? Integer.parseInt(values[2]) : pi.min;
							int max = values[3].matches("\\d+") ? Integer.parseInt(values[3]) : pi.max;
							int limit = values[4].matches("\\d+") ? Integer.parseInt(values[4]) : pi.limit;
							int lootdist = values[5].matches("\\d+") ? Integer.parseInt(values[5]) : pi.type;
							String title = values[6].length() > 0 ? values[6] : pi.title;
							modifyPartyRoom(activeChar, roomId, min, max, limit, lootdist, title);
							showPartyRoom(activeChar, roomId);
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eB[ [ݒ̕ύXɎs܂B");
							return;
						}
					}
				}
				//_joinRoom roomid
				else if (subcmd.startsWith("_joinRoom"))
				{
					String[] values = subcmd.split(" ");
					//ڂĂȂ΃G[
					if (values.length < 2)
					{
						activeChar.sendMessage("p[eB[ [ւ̓Ɏs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = Integer.parseInt(values[1]);
							if (joinPartyRoom(activeChar, roomId))
								showPartyRoom(activeChar, roomId);
							else
							{
								activeChar.sendMessage("p[eB[ [ւ̓Ɏs܂B");
								return;
							}
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eB[ [ւ̓Ɏs܂B");
							return;
						}
					}
				}
				//_leaveRoom roomid
				else if (subcmd.startsWith("_leaveRoom"))
				{
					String[] values = subcmd.split(" ");
					//ڂĂȂ΃G[
					if (values.length < 2)
					{
						activeChar.sendMessage("p[eB[ [̑ގɎs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = Integer.parseInt(values[1]);
							leavePartyRoom(activeChar, roomId);
							showPartyRoomList(activeChar, null, null);
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eB[ [̑ގɎs܂B");
							return;
						}
					}
				}
				//_kickRoom roomid char_obj_id
				else if (subcmd.startsWith("_kickRoom"))
				{
					String[] values = subcmd.split(" ");
					//ڂĂȂ΃G[
					if (values.length < 3)
					{
						activeChar.sendMessage("p[eB[ [̋ގɎs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = Integer.parseInt(values[1]);
							int objectId = Integer.parseInt(values[2]);
							L2PcInstance character = (L2PcInstance)L2World.getInstance().findObject(objectId);
							if (character != null)
								leavePartyRoom(character, roomId);
							return;
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eB[ [̋ގɎs܂B");
							return;
						}
					}
				}
				//_joinParty roomid char_obj_id
				else if (subcmd.startsWith("_joinParty"))
				{
					String[] values = subcmd.split(" ");
					//ڂĂȂ΃G[
					if (values.length < 3)
					{
						activeChar.sendMessage("p[eBւ̊UɎs܂B");
						return;
					}
					else
					{
						try
						{
							int roomId = Integer.parseInt(values[1]);
							int objectId = Integer.parseInt(values[2]);
							L2PcInstance target = (L2PcInstance)L2World.getInstance().findObject(objectId);
							if (!requestJoinParty(activeChar, target, roomId))
								activeChar.sendMessage("p[eBւ̊UɎs܂B");
							return;
						}
						catch (Exception e)
						{
							e.printStackTrace();
							activeChar.sendMessage("p[eBւ̊UɎs܂B");
							return;
						}
					}
				}
				else
				{
					separateAndSend("<html><body><br><center> the command: " + command + " is not implemented yet</center><br></body></html>", activeChar);
					return;
				}
	}

	@Override
	public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar)
	{
	}

	//ԍ̐
	private synchronized int createPartyRoomId()
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT MAX(id) FROM party_match_list");
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				return result.getInt(1) + 1;
			}
			result.close();
			statement.close();
		}
		catch (Exception e)
		{
			return -1;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
		return 1;//1Ȃꍇ1Ԃ
	}

	//p[eB[[J݂B
	private int createPartyRoom(L2PcInstance activeChar, int min, int max, int limit, int lootdist, String title)
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("INSERT INTO party_match_list VALUES (?,?,?,?,?,?,?,?)");
			int nextId = createPartyRoomId();
			if (nextId == -1)
			{
				activeChar.sendMessage("p[eB[ [̊J݂Ɏs܂B");
				return -1;
			}
			statement.setInt(1, nextId);
			statement.setInt(2, activeChar.getObjectId());
			statement.setInt(3, min);
			statement.setInt(4, max);
			statement.setInt(5, limit);
			int castleIndex = CastleManager.getInstance().findNearestCastleIndex(activeChar);
			if (castleIndex < 0)
				statement.setString(6, "s");
			else
				statement.setString(6, CastleManager.getInstance().getCastles().get(castleIndex).getLocName());
			statement.setInt(7, lootdist);
//			title = quoteString(title);
			statement.setString(8, title);
			statement.execute();
			statement.close();

			statement = con.prepareStatement("INSERT INTO party_match_room VALUES(?,?,?)");
			statement.setInt(1, nextId);
			statement.setInt(2, activeChar.getObjectId());
			statement.setInt(3, 0);
			statement.execute();
			statement.close();
			activeChar.sendMessage("p[eB[ [J݂܂B");
			return nextId;
		}
		catch (Exception e)
		{
			_log.info("could not create Party Room: " + e);
			activeChar.sendMessage("p[eB[ [̊J݂Ɏs܂B");
			return -1;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
	}

	//p[eB[[̐ݒύXi[_[̂݁j
	private void modifyPartyRoom(L2PcInstance activeChar, int roomId, int min, int max, int limit, int lootdist, String title)
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("UPDATE party_match_list SET min = ?, max = ?, `limit` = ?, loc = ?, type = ?, title = ? WHERE id = ?");
			statement.setInt(1, min);
			statement.setInt(2, max);
			statement.setInt(3, limit);
			int castleIndex = CastleManager.getInstance().findNearestCastleIndex(activeChar);
			if (castleIndex < 0)
				statement.setString(4, "s");
			else
				statement.setString(4, CastleManager.getInstance().getCastles().get(castleIndex).getLocName());
			statement.setInt(5, lootdist);
//			title = quoteString(title);
			statement.setString(6, title);
			statement.setInt(7, roomId);
			statement.execute();
			statement.close();
			/*
			 * ̕ɁAύX̏𖞂ȂLN^[̑ގKv
			 *
			 */
		}
		catch (Exception e)
		{
			_log.info("could not modify Party Room: " + e);
			activeChar.sendMessage("p[eB[ [ݒ̕ύXɎs܂B");
			return;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
		brodeCastRoomInfo(activeChar, roomId);
		activeChar.sendMessage("p[eB[ [ݒύX܂B");
	}

	//p[eB[[ɓB
	private boolean joinPartyRoom(L2PcInstance activeChar, int roomId)
	{
		PartyRoomInfo pi = getPartyRoomInfo(roomId);
		if (pi.limit == -1 || pi.count == -1)
		{
			activeChar.sendMessage("[܂B");
			return false;
		}
		else if (pi.limit <= pi.count)
		{
			activeChar.sendMessage("l̏ɒBĂ邽߁Ał܂B");
			return false;
		}
		else if (activeChar.getLevel() < pi.min || pi.max < activeChar.getLevel())
		{
			activeChar.sendMessage("xɍĂȂ߁Ał܂B");
			return false;
		}
		else
		{
			java.sql.Connection con = null;
			try
			{
				con = L2DatabaseFactory.getInstance().getConnection();
				PreparedStatement statement = con.prepareStatement("INSERT INTO party_match_room VALUES(?,?,?)");
				statement.setInt(1, roomId);
				statement.setInt(2, activeChar.getObjectId());
				if (activeChar.getParty() != null && activeChar.getParty() == ((L2PcInstance)L2World.getInstance().findObject(pi.owner_id)).getParty())
					statement.setInt(3, 1);
				else
					statement.setInt(3, 2);
				statement.execute();
				statement.close();
			}
			catch (Exception e)
			{
				_log.info("could not join Party Room: " + e);
				activeChar.sendMessage("p[eB[ [ւ̓Ɏs܂B");
				return false;
			}
			finally
			{
				L2DatabaseFactory.close(con);
			}
			brodeCastRoomInfo(activeChar, roomId);
			activeChar.sendMessage("p[eB[ [֓܂B");
		}
		return true;
	}

	//p[eB[[ގ
	private void leavePartyRoom(L2PcInstance activeChar, int roomId)
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT owner_id FROM party_match_list WHERE id = ?");
			statement.setInt(1, roomId);
			ResultSet result = statement.executeQuery();
			int owner_id = 0;
			while (result.next())
			{
				owner_id = result.getInt(1);
			}
			result.close();
			statement.close();

			//ގ҂I[i[ꍇA
			if (owner_id == activeChar.getObjectId())
			{
				statement = con.prepareStatement("SELECT char_obj_id FROM party_match_room WHERE room_id = ?");
				statement.setInt(1, roomId);
				result = statement.executeQuery();
				while (result.next())
				{
					int object_id = result.getInt(1);
					L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
					if (member != null)
					{
						showPartyRoomList(member, null, null);
						member.sendMessage("p[eB[ [U܂B");
					}
				}
				result.close();
				statement.close();

				statement = con.prepareStatement("DELETE FROM party_match_list WHERE id = ?");
				statement.setInt(1, roomId);
				statement.execute();
				statement.close();
				statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id = ?");
				statement.setInt(1, roomId);
				statement.execute();
				statement.close();
			}
			else
			{
				statement = con.prepareStatement("SELECT char_obj_id FROM party_match_room WHERE room_id = ?");
				statement.setInt(1, roomId);
				result = statement.executeQuery();
				while (result.next())
				{
					int object_id = result.getInt(1);
					L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
					if (member != null)
					{
						if (object_id == activeChar.getObjectId())
						{
							showPartyRoomList(member, null, null);
							member.sendMessage("p[eB[[ގ܂B");
						}
						else
						{
							showPartyRoom(member, roomId);
							member.sendMessage(activeChar.getName() + "ގ܂B");
						}
					}
				}
				result.close();
				statement.close();

				statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id = ? AND char_obj_id = ?");
				statement.setInt(1, roomId);
				statement.setInt(2, activeChar.getObjectId());
				statement.execute();
				statement.close();
			}
		}
		catch (Exception e)
		{
			_log.info("could not delete Party Room: " + e);
			activeChar.sendMessage("p[eB[ [̏IɎs܂B");
			return;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
		brodeCastRoomInfo(activeChar, roomId);
		activeChar.sendMessage("p[eB[ [I܂B");
	}

	//p[eB[ɊU
	private boolean requestJoinParty(L2PcInstance requestor, L2PcInstance target, int roomId)
	{
		PartyRoomInfo pi = getPartyRoomInfo(roomId);

		//////////////////////////////////////////////////////////////////////
		// : RequestJoinParty.java#runImpl() قڊێʂ
		if (requestor == null)
			return false;

		if (target == null)
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
			return false;
		}

		if (target.getAppearance().getInvisible())
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
			return false;
		}

		if (target.isInParty())
		{
			SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_IN_PARTY);
			msg.addString(target.getName());
			requestor.sendPacket(msg);
			return false;
		}

		if (BlockList.isBlocked(target, requestor))
		{
			SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
			sm.addCharName(target);
			requestor.sendPacket(sm);
			return false;
		}

		if (target == requestor)
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
			return false;
		}

		if (target.isCursedWeaponEquipped() || requestor.isCursedWeaponEquipped())
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
			return false;
		}

		if (target.isInJail() || requestor.isInJail())
		{
			requestor.sendMessage("Player is in Jail");
			return false;
		}

		if (target.isInOlympiadMode() || requestor.isInOlympiadMode())
			return false;
		// ܂
		//////////////////////////////////////////////////////////////////////

		//////////////////////////////////////////////////////////////////////
		// : RequestJoinParty.java#addTargetToParty() قڊێʂ
		SystemMessage msg;

		// summary of ppl already in party and ppl that get invitation
		if (!requestor.getParty().isLeader(requestor))
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_LEADER_CAN_INVITE));
			return false;
		}
		if (requestor.getParty() != null && requestor.getParty().getMemberCount() >= 9)
//		if (requestor.getParty() != null && requestor.getParty().getMemberCount() + requestor.getParty().getPendingInvitationNumber() >= 9)
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_FULL));
			return false;
		}
		if (requestor.getParty().getPendingInvitation())
		{
			requestor.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.WAITING_FOR_ANOTHER_REPLY));
			return false;
		}

		if (!target.isProcessingRequest())
		{
			if (requestor.getParty() == null)
				requestor.setParty(new L2Party(requestor, pi.type));
			requestor.onTransactionRequest(target);
			target.sendPacket(new AskJoinParty(requestor.getName(), pi.type));
			requestor.getParty().setPendingInvitation(true);
//			requestor.getParty().increasePendingInvitationNumber();
			
			if (Config.DEBUG)
				_log.fine("sent out a party invitation to:"+target.getName());
		}
		else
		{
			msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
			msg.addString(target.getName());
			requestor.sendPacket(msg);
			
			if (Config.DEBUG)
				_log.warning(requestor.getName() + " already received a party invitation");
		}
		// ܂
		//////////////////////////////////////////////////////////////////////

		return true;
	}

	//p[eB[[Xg\B
	private void showPartyRoomList(L2PcInstance activeChar, String optionArea, String optionLevel)
	{
		String html = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/party_match/partyRoomList.htm");

		StringBuilder where_str = new StringBuilder();
		if (optionArea != null && !optionArea.equals("S"))
		{
			where_str.append(" loc = '" + optionArea + "'");
		}
		if (optionLevel != null && !optionLevel.equals("S"))
		{
			String[]v = optionLevel.split("-");
			int minlevel = Integer.parseInt(v[0]);
			int maxlevel = Integer.parseInt(v[1]);
			if (where_str.length() != 0)
				where_str.append(" AND");
			where_str.append(" min <= '" + minlevel + "' AND max >= '" + maxlevel + "'");
		}
		if (where_str.length() != 0)
			where_str.append(" WHERE" + where_str);
		where_str.append(" ORDER BY id");
		StringBuilder roomList = new StringBuilder();
		StringBuilder DelRoom = new StringBuilder();
		int roomCount = 0;
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT id FROM party_match_list" + where_str);
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				PartyRoomInfo pi = getPartyRoomInfo(result.getInt(1));
				L2PcInstance leader = (L2PcInstance)L2World.getInstance().findObject(pi.owner_id);
				if (leader == null)
				{
					if (DelRoom.length() != 0)
						DelRoom.append(",");
					DelRoom.append(pi.roomId);
				}
				else if (pi.roomId != -1 && pi.owner_id != -1)
				{
					roomList.append("<table width=610><tr>");
					roomList.append("<td width=30 align=center>" + pi.roomId + "</td>");
					roomList.append("<td width=160>" + pi.title + "</td>");
					roomList.append("<td width=120>" + leader.getName() + "</td>");
					roomList.append("<td width=120>" + pi.loc + "</td>");
					roomList.append("<td width=50 align=center>" + pi.min + " - " + pi.max + "</td>");
					roomList.append("<td width=50 align=center>" + pi.count + " / " + pi.limit + "</td>");
					roomList.append("<td width=80 align=center><button value=\"\" action=\"bypass _bbsgetfav;bbs_party_match;_joinRoom " + pi.roomId + "\" width=65 height=20 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\"></td>");
					roomList.append("</tr></table>");
					roomCount++;
				}
			}
			result.close();
			statement.close();

			if (DelRoom.length() != 0)
			{
				statement = con.prepareStatement("DELETE FROM party_match_list WHERE id in (?)");
				statement.setString(1, DelRoom.toString());
				statement.execute();
				statement.close();
				statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id in (?)");
				statement.setString(1, DelRoom.toString());
				statement.execute();
				statement.close();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			separateAndSend("<html><body><br><center>p[eB[[Xg쐬ɃG[܂B</center><br></body></html>", activeChar);
			return;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}

		html = html.replace("%roomList%", roomList);//[Xg
		separateAndSend(html.toString(), activeChar);
	}

	//p[eB[[\B
	private void showPartyRoom(L2PcInstance activeChar, int roomId)
	{
		PartyRoomInfo pi = getPartyRoomInfo(roomId);
		if (pi.roomId == -1 && pi.owner_id == -1)
			return;
		StringBuilder memberList = new StringBuilder();
		int memberCount = 0;
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT * FROM party_match_room WHERE room_id = ? ORDER BY memberType");
			statement.setInt(1, roomId);
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				L2Object obj = L2World.getInstance().findObject(result.getInt(2));
				if (obj != null && obj instanceof L2PcInstance)
				{
					L2PcInstance member = (L2PcInstance)obj;
					memberList.append("<table width=610><tr>");
					memberList.append("<td width=120>" + member.getName() + "</td>");
					memberList.append("<td width=130 align=center>" + member.getTemplate().className + "</td>");
					memberList.append("<td width=40 align=center>" + member.getLevel() + "</td>");
					memberList.append("<td width=130 align=center>" + MapRegionTable.getInstance().getClosestTownName(member) + "</td>");
					if (result.getInt(3) == 0)
					{
						memberList.append("<td width=120 align=center>[[_[</td>");
					}
					else if (result.getInt(3) == 1)
					{
						memberList.append("<td width=120 align=center>p[eB[o</td>");
					}
					else
					{
						memberList.append("<td width=120 align=center>p[eB[]</td>");
					}
					if (activeChar.getObjectId() == pi.owner_id && activeChar.getObjectId() != member.getObjectId())
					{
						memberList.append("<td width=70 align=center>");
						if (result.getInt(3) == 2)
							memberList.append("<button value=\"osU\" action=\"bypass _bbsgetfav;bbs_party_match;_joinParty " + roomId + " " + member.getObjectId() + "\" width=65 height=20 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\">");
						memberList.append("<button value=\"Ǖ\" action=\"bypass _bbsgetfav;bbs_party_match;_kickRoom " + roomId + " " + member.getObjectId() + "\" width=65 height=20 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\">");
						memberList.append("</td>");
					}
					else
						memberList.append("<td width=70 align=center></td>");
					memberList.append("</tr></table>");
					memberCount++;
				}
			}
			result.close();
			statement.close();
		}
		catch (Exception e)
		{
			separateAndSend("<html><body><br><center>p[eB[[쐬ɃG[܂B</center><br></body></html>", activeChar);
			return;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}

		TextReplacer html = new TextReplacer(HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/party_match/partyRoom.htm"));
		html.replace("%roomId%", pi.roomId);	//ԍ
		html.replace("%title%", htmlescape(pi.title));	//
		html.replace("%location%", pi.loc);	//ꏊ
		html.replace("%current%", pi.count);	//݂̐l
		html.replace("%max%", pi.limit);	//̐l
		String lootdistribution = "";
		switch (pi.type)
		{
			case L2Party.ITEM_LOOTER:
				lootdistribution = "ElL";
				break;
			case L2Party.ITEM_RANDOM:
				lootdistribution = "_ɕz";
				break;
			case L2Party.ITEM_RANDOM_SPOIL:
				lootdistribution = "X|C܂߃_";
				break;
			case L2Party.ITEM_ORDER:
				lootdistribution = "ԂɎ擾";
				break;
			case L2Party.ITEM_ORDER_SPOIL:
				lootdistribution = "X|C܂ߏԂ";
				break;
		}
		html.replace("%rootType%", lootdistribution);	//^Cv
		html.replace("%minlevel%", pi.min);	//Œ჌x
		html.replace("%maxlevel%", pi.max);	//ōx
		html.replace("%memberList%", memberList);	//o[Xg
		String modifyButton = "";
		if (activeChar.getObjectId() == pi.owner_id)
			modifyButton = "<button value=\"[ݒ\" action=\"bypass _bbsgetfav;bbs_party_match;_modifyRoomWindow\" width=80 height=22 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\">";
		html.replace("%modifyPartyRoom%", modifyButton);//ݒύX{^

		separateAndSend(html.toString(), activeChar);
	}

	//ݒEBhE̕\
	private void showConfigWindow(L2PcInstance activeChar, String filename)
	{
		NpcHtmlMessage html = new NpcHtmlMessage(5);
		html.setFile(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/" + filename);
		html.replace("%roomId%", getRoomIdByCharId(activeChar.getObjectId()));//ԍ
		activeChar.sendPacket(html);
	}

	//LN^[QĂ镔IDԂi-1j
	public int getRoomIdByCharId(int char_obj_id)
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT room_id FROM party_match_room WHERE char_obj_id = ?");
			statement.setInt(1, char_obj_id);
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				return result.getInt(1);
			}
			result.close();
			statement.close();
		}
		catch (Exception e)
		{
			return -1;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
		return -1;
	}

	class PartyRoomInfo {
		int roomId;			//ԍ
		int owner_id = 0;	//ÎID
		int min = 1;		//Œ჌x
		int max = 100;		//ōx
		int limit = -1;		//
		String loc = "";	//p[eB̈ʒu
		int type = 0;		//ElA_
		String title = "";	//
		int count = -1;		//݂̐l
		
		PartyRoomInfo(int _roomId) { this.roomId = _roomId; }
	}

	//p[eB[[̐ݒEԂ
	public PartyRoomInfo getPartyRoomInfo(int roomId)
	{
		PartyRoomInfo pi = new PartyRoomInfo(roomId);

		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();
			PreparedStatement statement = con.prepareStatement("SELECT owner_id, min, max, `limit`, loc, type, title FROM party_match_list WHERE id = ?");
			statement.setInt(1, roomId);
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				pi.owner_id = result.getInt(1);	//ÎID
				pi.min = result.getInt(2);		//Œ჌x
				pi.max = result.getInt(3);		//ōx
				pi.limit = result.getInt(4);	//
				pi.loc = result.getString(5);	//p[eB̈ʒu
				pi.type = result.getInt(6);		//ElA_
				pi.title = result.getString(7);	//
			}
			result.close();
			statement.close();

			statement = con.prepareStatement("SELECT COUNT(*) FROM party_match_room WHERE room_id = ?");
			statement.setInt(1, roomId);
			result = statement.executeQuery();
			while (result.next())
			{
				pi.count = result.getInt(1);	//݂̐l
			}
			result.close();
			statement.close();
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return pi;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
		return pi;
	}

	//p[eB[[̏󋵂ωAo[SɑMB
	public void brodeCastRoomInfo(L2PcInstance activeChar, int roomId)
	{
		java.sql.Connection con = null;
		try
		{
			con = L2DatabaseFactory.getInstance().getConnection();

			PreparedStatement statement = con.prepareStatement("SELECT char_obj_id, memberType FROM party_match_room WHERE room_id = ?");
			statement.setInt(1, roomId);
			ResultSet result = statement.executeQuery();
			while (result.next())
			{
				int object_id = result.getInt(1);
				int member_type = result.getInt(2);
				L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
				if (member != null)
				{
					if (member_type != 0)
					{
						PreparedStatement statement2 = con.prepareStatement("UPDATE party_match_room SET memberType = ? WHERE room_id = ? AND char_obj_id = ?");
						statement2.setInt(1, member.isInParty() ? 1 : 2);
						statement2.setInt(2, roomId);
						statement2.setInt(3, member.getObjectId());
						statement2.executeUpdate();
						statement2.close();
					}

					showPartyRoom(member, roomId);
				}
			}
			result.close();
			statement.close();
		}
		catch (Exception e)
		{
			_log.info("could not update Party Room Info: " + e);
			activeChar.sendMessage("p[eB[ [̍XVɎs܂B");
			return;
		}
		finally
		{
			L2DatabaseFactory.close(con);
		}
	}
}