/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import javolution.context.ObjectFactory;
import javolution.lang.Reusable;
import javolution.util.FastCollection;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.FastMap;

public class FastMRUCache<K, V>
extends FastCollection
implements Reusable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 50;
    private static final int DEFAULT_FORGET_TIME = 300000;
    private FastMap<K, CacheNode> _cache = new FastMap().setKeyComparator(FastComparator.DIRECT);
    private FastMap<K, V> _map;
    private FastList<K> _mruList = new FastList();
    private int _cacheSize;
    private int _forgetTime;
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        public Object create() {
            return new FastMRUCache();
        }

        public void cleanup(Object obj) {
            ((FastMRUCache)((Object)obj)).reset();
        }
    };

    public static FastMRUCache newInstance() {
        return (FastMRUCache)((Object)FACTORY.object());
    }

    public FastMRUCache() {
        this(new FastMap(), 50, 300000);
    }

    public FastMRUCache(FastMap<K, V> map) {
        this(map, 50, 300000);
    }

    public FastMRUCache(FastMap<K, V> map, int max) {
        this(map, max, 300000);
    }

    public FastMRUCache(FastMap<K, V> map, int max, int forgetTime) {
        this._map = map;
        this._cacheSize = max;
        this._forgetTime = forgetTime;
        this._map.setKeyComparator(FastComparator.DIRECT);
    }

    public synchronized void reset() {
        this._map.reset();
        this._cache.reset();
        this._mruList.reset();
        this._map.setKeyComparator(FastComparator.DIRECT);
        this._cache.setKeyComparator(FastComparator.DIRECT);
    }

    public synchronized V get(K key) {
        Object result;
        if (!this._cache.containsKey(key)) {
            if (this._mruList.size() >= this._cacheSize) {
                this._cache.remove(this._mruList.getLast());
                this._mruList.removeLast();
            }
            result = this._map.get(key);
            this._cache.put(key, (Object)new CacheNode(result));
            this._mruList.addFirst(key);
        } else {
            CacheNode current = (CacheNode)this._cache.get(key);
            if (current._lastModified + (long)this._forgetTime <= System.currentTimeMillis()) {
                current._lastModified = System.currentTimeMillis();
                current._node = this._map.get(key);
                this._cache.put(key, (Object)current);
            }
            this._mruList.remove(key);
            this._mruList.addFirst(key);
            result = current._node;
        }
        return (V)result;
    }

    public synchronized boolean remove(Object key) {
        this._cache.remove(key);
        this._mruList.remove(key);
        return this._map.remove(key) == key;
    }

    public FastMap<K, V> getContentMap() {
        return this._map;
    }

    public int size() {
        return this._mruList.size();
    }

    public int capacity() {
        return this._cacheSize;
    }

    public int getForgetTime() {
        return this._forgetTime;
    }

    public synchronized void clear() {
        this._cache.clear();
        this._mruList.clear();
        this._map.clear();
    }

    public final FastCollection.Record head() {
        return this._mruList.head();
    }

    public final FastCollection.Record tail() {
        return this._mruList.tail();
    }

    public final Object valueOf(FastCollection.Record record) {
        return ((FastMap.Entry)record).getKey();
    }

    public final void delete(FastCollection.Record record) {
        this.remove(((FastMap.Entry)record).getKey());
    }

    class CacheNode {
        long _lastModified = System.currentTimeMillis();
        V _node;

        public CacheNode(V object) {
            this._node = object;
        }

        public boolean equals(Object object) {
            return this._node == object;
        }
    }
}

