/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.DropProtection;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NullKnownList;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DropItem;
import com.l2jserver.gameserver.network.serverpackets.GetItem;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SpawnItem;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2ItemType;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.GMAudit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class L2ItemInstance
extends L2Object {
    protected static final Logger _log = Logger.getLogger(L2ItemInstance.class.getName());
    private static final Logger _logItems = Logger.getLogger("item");
    private int _ownerId;
    private int _dropperObjectId = 0;
    private long _count;
    private long _initCount;
    private long _time;
    private boolean _decrease = false;
    private final int _itemId;
    private final L2Item _item;
    private ItemLocation _loc;
    private int _locData;
    private int _enchantLevel;
    private boolean _wear;
    private L2Augmentation _augmentation = null;
    private int _mana = -1;
    private boolean _consumingMana = false;
    private static final int MANA_CONSUMPTION_RATE = 60000;
    private int _type1;
    private int _type2;
    private long _dropTime;
    private boolean _published = false;
    public static final int CHARGED_NONE = 0;
    public static final int CHARGED_SOULSHOT = 1;
    public static final int CHARGED_SPIRITSHOT = 1;
    public static final int CHARGED_BLESSED_SPIRITSHOT = 2;
    private int _chargedSoulshot = 0;
    private int _chargedSpiritshot = 0;
    private boolean _chargedFishtshot = false;
    private boolean _protected;
    public static final int UNCHANGED = 0;
    public static final int ADDED = 1;
    public static final int REMOVED = 3;
    public static final int MODIFIED = 2;
    private int _lastChange = 2;
    private boolean _existsInDb;
    private boolean _storedInDb;
    private final ReentrantLock _dbLock = new ReentrantLock();
    private Elementals[] _elementals = null;
    private ScheduledFuture<?> itemLootShedule = null;
    public ScheduledFuture<?> _lifeTimeTask;
    private final DropProtection _dropProtection = new DropProtection();

    public L2ItemInstance(int objectId, int itemId) {
        super(objectId);
        this.setInstanceType(L2Object.InstanceType.L2ItemInstance);
        this._itemId = itemId;
        this._item = ItemTable.getInstance().getTemplate(itemId);
        if (this._itemId == 0 || this._item == null) {
            throw new IllegalArgumentException();
        }
        super.setName(this._item.getName());
        this.setCount(1L);
        this._loc = ItemLocation.VOID;
        this._type1 = 0;
        this._type2 = 0;
        this._dropTime = 0L;
        this._mana = this._item.getDuration();
        this._time = this._item.getTime() == -1 ? -1L : System.currentTimeMillis() + (long)this._item.getTime() * 60L * 1000L;
        this.scheduleLifeTimeTask();
    }

    public L2ItemInstance(int objectId, L2Item item) {
        super(objectId);
        this.setInstanceType(L2Object.InstanceType.L2ItemInstance);
        this._itemId = item.getItemId();
        this._item = item;
        if (this._itemId == 0) {
            throw new IllegalArgumentException();
        }
        super.setName(this._item.getName());
        this.setCount(1L);
        this._loc = ItemLocation.VOID;
        this._mana = this._item.getDuration();
        this._time = this._item.getTime() == -1 ? -1L : System.currentTimeMillis() + (long)this._item.getTime() * 60L * 1000L;
        this.scheduleLifeTimeTask();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new NullKnownList(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pickupMe(L2Character player) {
        QuestState qs;
        L2PcInstance actor;
        assert (this.getPosition().getWorldRegion() != null);
        L2WorldRegion oldregion = this.getPosition().getWorldRegion();
        GetItem gi = new GetItem(this, player.getObjectId());
        player.broadcastPacket(gi);
        L2ItemInstance l2ItemInstance = this;
        synchronized (l2ItemInstance) {
            this.setIsVisible(false);
            this.getPosition().setWorldRegion(null);
        }
        int itemId = this.getItemId();
        if (MercTicketManager.getInstance().getTicketCastleId(itemId) > 0) {
            MercTicketManager.getInstance().removeTicket(this);
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
        if (!(Config.DISABLE_TUTORIAL || itemId != 57 && itemId != 6353 || (actor = player.getActingPlayer()) == null || (qs = actor.getQuestState("255_Tutorial")) == null)) {
            qs.getQuest().notifyEvent("CE" + itemId + "", null, actor);
        }
        L2World.getInstance().removeVisibleObject(this, oldregion);
    }

    public void setOwnerId(String process, int owner_id, L2PcInstance creator, Object reference) {
        this.setOwnerId(owner_id);
        if (Config.LOG_ITEMS && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (this.getItem().isEquipable() || this.getItem().getItemId() == 57))) {
            LogRecord record = new LogRecord(Level.INFO, "SETOWNER:" + process);
            record.setLoggerName("item");
            record.setParameters(new Object[]{this, creator, reference});
            _logItems.log(record);
        }
        if (creator != null && creator.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = creator.getTarget() != null ? creator.getTarget().getName() : "no-target";
            if (Config.GMAUDIT) {
                GMAudit.auditGMAction(creator.getName() + " [" + creator.getObjectId() + "]", process + "(id: " + this.getItemId() + " name: " + this.getName() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
    }

    public void setOwnerId(int owner_id) {
        if (owner_id == this._ownerId) {
            return;
        }
        this._ownerId = owner_id;
        this._storedInDb = false;
    }

    public int getOwnerId() {
        return this._ownerId;
    }

    public void setLocation(ItemLocation loc) {
        this.setLocation(loc, 0);
    }

    public void setLocation(ItemLocation loc, int loc_data) {
        if (loc == this._loc && loc_data == this._locData) {
            return;
        }
        this._loc = loc;
        this._locData = loc_data;
        this._storedInDb = false;
    }

    public ItemLocation getLocation() {
        return this._loc;
    }

    public void setCount(long count) {
        if (this.getCount() == count) {
            return;
        }
        this._count = count >= -1L ? count : 0L;
        this._storedInDb = false;
    }

    public long getCount() {
        return this._count;
    }

    public void changeCount(String process, long count, L2PcInstance creator, Object reference) {
        long max;
        if (count == 0L) {
            return;
        }
        long old = this.getCount();
        long l = max = this.getItemId() == 57 ? 99900000000L : Integer.MAX_VALUE;
        if (count > 0L && this.getCount() > max - count) {
            this.setCount(max);
        } else {
            this.setCount(this.getCount() + count);
        }
        if (this.getCount() < 0L) {
            this.setCount(0L);
        }
        this._storedInDb = false;
        if (Config.LOG_ITEMS && process != null && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (this._item.isEquipable() || this._item.getItemId() == 57))) {
            LogRecord record = new LogRecord(Level.INFO, "CHANGE:" + process);
            record.setLoggerName("item");
            record.setParameters(new Object[]{this, "PrevCount(" + old + ")", creator, reference});
            _logItems.log(record);
        }
        if (creator != null && creator.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = creator.getTarget() != null ? creator.getTarget().getName() : "no-target";
            if (Config.GMAUDIT) {
                GMAudit.auditGMAction(creator.getName() + " [" + creator.getObjectId() + "]", process + "(id: " + this.getItemId() + " objId: " + this.getObjectId() + " name: " + this.getName() + " count: " + count + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
    }

    public void changeCountWithoutTrace(int count, L2PcInstance creator, Object reference) {
        this.changeCount(null, count, creator, reference);
    }

    public boolean isEquipable() {
        return this._item.getBodyPart() != 0 && this._item.getItemType() != L2EtcItemType.ARROW && this._item.getItemType() != L2EtcItemType.BOLT && this._item.getItemType() != L2EtcItemType.LURE;
    }

    public boolean isEquipped() {
        return this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP;
    }

    public int getLocationSlot() {
        assert (this._loc == ItemLocation.PAPERDOLL || this._loc == ItemLocation.PET_EQUIP || this._loc == ItemLocation.INVENTORY || this._loc == ItemLocation.MAIL);
        return this._locData;
    }

    public L2Item getItem() {
        return this._item;
    }

    public int getCustomType1() {
        return this._type1;
    }

    public int getCustomType2() {
        return this._type2;
    }

    public void setCustomType1(int newtype) {
        this._type1 = newtype;
    }

    public void setCustomType2(int newtype) {
        this._type2 = newtype;
    }

    public void setDropTime(long time) {
        this._dropTime = time;
    }

    public long getDropTime() {
        return this._dropTime;
    }

    public L2ItemType getItemType() {
        return this._item.getItemType();
    }

    public int getItemId() {
        return this._itemId;
    }

    public boolean isEtcItem() {
        return this._item instanceof L2EtcItem;
    }

    public boolean isWeapon() {
        return this._item instanceof L2Weapon;
    }

    public boolean isArmor() {
        return this._item instanceof L2Armor;
    }

    public L2EtcItem getEtcItem() {
        if (this._item instanceof L2EtcItem) {
            return (L2EtcItem)this._item;
        }
        return null;
    }

    public L2Weapon getWeaponItem() {
        if (this._item instanceof L2Weapon) {
            return (L2Weapon)this._item;
        }
        return null;
    }

    public L2Armor getArmorItem() {
        if (this._item instanceof L2Armor) {
            return (L2Armor)this._item;
        }
        return null;
    }

    public final int getCrystalCount() {
        return this._item.getCrystalCount(this._enchantLevel);
    }

    public int getReferencePrice() {
        return this._item.getReferencePrice();
    }

    public String getItemName() {
        return this._item.getName();
    }

    public int getLastChange() {
        return this._lastChange;
    }

    public void setLastChange(int lastChange) {
        this._lastChange = lastChange;
    }

    public boolean isStackable() {
        return this._item.isStackable();
    }

    public boolean isDropable() {
        return this.isAugmented() ? false : this._item.isDropable();
    }

    public boolean isDestroyable() {
        return this._item.isDestroyable();
    }

    public boolean isTradeable() {
        return this.isAugmented() ? false : this._item.isTradeable();
    }

    public boolean isSellable() {
        return this.isAugmented() ? false : this._item.isSellable();
    }

    public boolean isDepositable(boolean isPrivateWareHouse) {
        if (this.isEquipped() || !this._item.isDepositable()) {
            return false;
        }
        return isPrivateWareHouse || this.isTradeable() && !this.isShadowItem();
    }

    public boolean isConsumable() {
        return this._item.isConsumable();
    }

    public boolean isPotion() {
        return this._item.isPotion();
    }

    public boolean isElixir() {
        return this._item.isElixir();
    }

    public boolean isHeroItem() {
        return this._item.isHeroItem();
    }

    public boolean isCommonItem() {
        return this._item.isCommon();
    }

    public boolean isPvp() {
        return this._item.isPvpItem();
    }

    public boolean isOlyRestrictedItem() {
        return Config.LIST_OLY_RESTRICTED_ITEMS.contains(this._itemId);
    }

    public boolean isAvailable(L2PcInstance player, boolean allowAdena, boolean allowNonTradeable) {
        return !(this.isEquipped() || this.getItem().getType2() == 3 || this.getItem().getType2() == 4 && this.getItem().getType1() == 1 || player.getPet() != null && this.getObjectId() == player.getPet().getControlObjectId() || player.getActiveEnchantItem() == this || !allowAdena && this.getItemId() == 57 || player.getCurrentSkill() != null && player.getCurrentSkill().getSkill().getItemConsumeId() == this.getItemId() || player.isCastingSimultaneouslyNow() && player.getLastSimultaneousSkillCast() != null && player.getLastSimultaneousSkillCast().getItemConsumeId() == this.getItemId() || !allowNonTradeable && (!this.isTradeable() || this.getItem().getItemType() == L2EtcItemType.PET_COLLAR && player.havePetInvItems()));
    }

    public int getEnchantLevel() {
        return this._enchantLevel;
    }

    public void setEnchantLevel(int enchantLevel) {
        if (this._enchantLevel == enchantLevel) {
            return;
        }
        this._enchantLevel = enchantLevel;
        this._storedInDb = false;
    }

    public boolean isAugmented() {
        return this._augmentation != null;
    }

    public L2Augmentation getAugmentation() {
        return this._augmentation;
    }

    public boolean setAugmentation(L2Augmentation augmentation) {
        if (this._augmentation != null) {
            return false;
        }
        this._augmentation = augmentation;
        this.updateItemAttributes(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAugmentation() {
        if (this._augmentation == null) {
            return;
        }
        this._augmentation = null;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            statement = con.prepareStatement("DELETE FROM item_attributes WHERE itemId = ?");
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not remove augmentation for item: " + this + " from DB:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreAttributes() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT augAttributes,augSkillId,augSkillLevel FROM item_attributes WHERE itemId=?");
            statement.setInt(1, this.getObjectId());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int aug_attributes = rs.getInt(1);
                int aug_skillId = rs.getInt(2);
                int aug_skillLevel = rs.getInt(3);
                if (aug_attributes != -1 && aug_skillId != -1 && aug_skillLevel != -1) {
                    this._augmentation = new L2Augmentation(rs.getInt("augAttributes"), rs.getInt("augSkillId"), rs.getInt("augSkillLevel"));
                }
            }
            rs.close();
            statement.close();
            statement = con.prepareStatement("SELECT elemType,elemValue FROM item_elementals WHERE itemId=?");
            statement.setInt(1, this.getObjectId());
            rs = statement.executeQuery();
            while (rs.next()) {
                byte elem_type = rs.getByte(1);
                int elem_value = rs.getInt(2);
                if (elem_type == -1 || elem_value == -1) continue;
                this.applyAttribute(elem_type, elem_value);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore augmentation and elemental data for item " + this + " from DB: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemAttributes(Connection pooledCon) {
        Connection con = null;
        try {
            con = pooledCon == null ? L2DatabaseFactory.getInstance().getConnection() : pooledCon;
            PreparedStatement statement = con.prepareStatement("REPLACE INTO item_attributes VALUES(?,?,?,?)");
            statement.setInt(1, this.getObjectId());
            if (this._augmentation == null) {
                statement.setInt(2, -1);
                statement.setInt(3, -1);
                statement.setInt(4, -1);
            } else {
                statement.setInt(2, this._augmentation.getAttributes());
                if (this._augmentation.getSkill() == null) {
                    statement.setInt(3, 0);
                    statement.setInt(4, 0);
                } else {
                    statement.setInt(3, this._augmentation.getSkill().getId());
                    statement.setInt(4, this._augmentation.getSkill().getLevel());
                }
            }
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Could not update atributes for item: " + this + " from DB:", e);
        }
        finally {
            if (pooledCon == null) {
                L2DatabaseFactory.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemElements(Connection pooledCon) {
        Connection con = null;
        try {
            con = pooledCon == null ? L2DatabaseFactory.getInstance().getConnection() : pooledCon;
            PreparedStatement statement = con.prepareStatement("DELETE FROM item_elementals WHERE itemId = ?");
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            statement.close();
            if (this._elementals == null) {
                return;
            }
            statement = con.prepareStatement("INSERT INTO item_elementals VALUES(?,?,?)");
            for (Elementals elm : this._elementals) {
                statement.setInt(1, this.getObjectId());
                statement.setByte(2, elm.getElement());
                statement.setInt(3, elm.getValue());
                statement.executeUpdate();
                statement.clearParameters();
            }
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Could not update elementals for item: " + this + " from DB:", e);
        }
        finally {
            if (pooledCon == null) {
                L2DatabaseFactory.close(con);
            }
        }
    }

    public Elementals[] getElementals() {
        return this._elementals;
    }

    public Elementals getElemental(byte attribute) {
        if (this._elementals == null) {
            return null;
        }
        for (Elementals elm : this._elementals) {
            if (elm.getElement() != attribute) continue;
            return elm;
        }
        return null;
    }

    public byte getAttackElementType() {
        if (!this.isWeapon()) {
            return -2;
        }
        if (this.getItem().getElementals() != null) {
            return this.getItem().getElementals()[0].getElement();
        }
        if (this._elementals != null) {
            return this._elementals[0].getElement();
        }
        return -2;
    }

    public int getAttackElementPower() {
        if (!this.isWeapon()) {
            return 0;
        }
        if (this.getItem().getElementals() != null) {
            return this.getItem().getElementals()[0].getValue();
        }
        if (this._elementals != null) {
            return this._elementals[0].getValue();
        }
        return 0;
    }

    public int getElementDefAttr(byte element) {
        Elementals elm;
        if (!this.isArmor()) {
            return 0;
        }
        if (this.getItem().getElementals() != null) {
            Elementals elm2 = this.getItem().getElemental(element);
            if (elm2 != null) {
                return elm2.getValue();
            }
        } else if (this._elementals != null && (elm = this.getElemental(element)) != null) {
            return elm.getValue();
        }
        return 0;
    }

    private void applyAttribute(byte element, int value) {
        if (this._elementals == null) {
            this._elementals = new Elementals[1];
            this._elementals[0] = new Elementals(element, value);
        } else {
            Elementals elm = this.getElemental(element);
            if (elm != null) {
                elm.setValue(value);
            } else {
                elm = new Elementals(element, value);
                Elementals[] array = new Elementals[this._elementals.length + 1];
                System.arraycopy(this._elementals, 0, array, 0, this._elementals.length);
                array[this._elementals.length] = elm;
                this._elementals = array;
            }
        }
    }

    public void setElementAttr(byte element, int value) {
        this.applyAttribute(element, value);
        this.updateItemElements(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearElementAttr(byte element) {
        if (this.getElemental(element) == null && element != -1) {
            return;
        }
        Elementals[] array = null;
        if (element != -1 && this._elementals != null && this._elementals.length > 1) {
            array = new Elementals[this._elementals.length - 1];
            int i = 0;
            for (Elementals elm : this._elementals) {
                if (elm.getElement() == element) continue;
                array[i++] = elm;
            }
        }
        this._elementals = array;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = null;
            if (element != -1) {
                statement = con.prepareStatement("DELETE FROM item_elementals WHERE itemId = ? AND elemType = ?");
                statement.setInt(2, element);
            } else {
                statement = con.prepareStatement("DELETE FROM item_elementals WHERE itemId = ?");
            }
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not remove elemental enchant for item: " + this + " from DB:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean isShadowItem() {
        return this._mana >= 0;
    }

    public int getMana() {
        return this._mana;
    }

    public void decreaseMana(boolean resetConsumingMana) {
        this.decreaseMana(resetConsumingMana, 1);
    }

    public void decreaseMana(boolean resetConsumingMana, int count) {
        L2PcInstance player;
        if (!this.isShadowItem()) {
            return;
        }
        this._mana = this._mana - count >= 0 ? (this._mana -= count) : 0;
        if (this._storedInDb) {
            this._storedInDb = false;
        }
        if (resetConsumingMana) {
            this._consumingMana = false;
        }
        if ((player = L2World.getInstance().getPlayer(this.getOwnerId())) != null) {
            SystemMessage sm;
            switch (this._mana) {
                case 10: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_10);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                    break;
                }
                case 5: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_5);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                    break;
                }
                case 1: {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_1);
                    sm.addItemName(this._item);
                    player.sendPacket(sm);
                }
            }
            if (this._mana == 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1S_REMAINING_MANA_IS_NOW_0);
                sm.addItemName(this._item);
                player.sendPacket(sm);
                if (this.isEquipped()) {
                    L2ItemInstance[] unequiped = player.getInventory().unEquipItemInSlotAndRecord(this.getLocationSlot());
                    InventoryUpdate iu = new InventoryUpdate();
                    for (L2ItemInstance item : unequiped) {
                        player.checkSShotsMatch(null, item);
                        iu.addModifiedItem(item);
                    }
                    player.sendPacket(iu);
                    player.broadcastUserInfo();
                }
                if (this.getLocation() != ItemLocation.WAREHOUSE) {
                    player.getInventory().destroyItem("L2ItemInstance", this, player, null);
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addRemovedItem(this);
                    player.sendPacket(iu);
                    StatusUpdate su = new StatusUpdate(player);
                    su.addAttribute(14, player.getCurrentLoad());
                    player.sendPacket(su);
                } else {
                    player.getWarehouse().destroyItem("L2ItemInstance", this, player, null);
                }
                L2World.getInstance().removeObject(this);
            } else {
                if (!this._consumingMana && this.isEquipped()) {
                    this.scheduleConsumeManaTask();
                }
                if (this.getLocation() != ItemLocation.WAREHOUSE) {
                    InventoryUpdate iu = new InventoryUpdate();
                    iu.addModifiedItem(this);
                    player.sendPacket(iu);
                }
            }
        }
    }

    public void scheduleConsumeManaTask() {
        if (this._consumingMana) {
            return;
        }
        this._consumingMana = true;
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleConsumeManaTask(this), 60000L);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public int getChargedSoulshot() {
        return this._chargedSoulshot;
    }

    public int getChargedSpiritshot() {
        return this._chargedSpiritshot;
    }

    public boolean getChargedFishshot() {
        return this._chargedFishtshot;
    }

    public void setChargedSoulshot(int type) {
        this._chargedSoulshot = type;
    }

    public void setChargedSpiritshot(int type) {
        this._chargedSpiritshot = type;
    }

    public void setChargedFishshot(boolean type) {
        this._chargedFishtshot = type;
    }

    public Func[] getStatFuncs(L2Character player) {
        return this.getItem().getStatFuncs(this, player);
    }

    public void updateDatabase() {
        this.updateDatabase(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatabase(boolean force) {
        this._dbLock.lock();
        try {
            if (this._existsInDb) {
                if (this._ownerId == 0 || this._loc == ItemLocation.VOID || this._loc == ItemLocation.REFUND || this.getCount() == 0L && this._loc != ItemLocation.LEASE) {
                    this.removeFromDb();
                } else if (!Config.LAZY_ITEMS_UPDATE || force) {
                    this.updateInDb();
                }
            } else {
                if (this._ownerId == 0 || this._loc == ItemLocation.VOID || this._loc == ItemLocation.REFUND || this.getCount() == 0L && this._loc != ItemLocation.LEASE) {
                    return;
                }
                this.insertIntoDb();
            }
        }
        finally {
            this._dbLock.unlock();
        }
    }

    public static L2ItemInstance restoreFromDb(int ownerId, ResultSet rs) {
        long time;
        int manaLeft;
        int custom_type2;
        int custom_type1;
        int enchant_level;
        int loc_data;
        ItemLocation loc;
        long count;
        int item_id;
        int objectId;
        L2ItemInstance inst = null;
        try {
            objectId = rs.getInt(1);
            item_id = rs.getInt("item_id");
            count = rs.getLong("count");
            loc = ItemLocation.valueOf(rs.getString("loc"));
            loc_data = rs.getInt("loc_data");
            enchant_level = rs.getInt("enchant_level");
            custom_type1 = rs.getInt("custom_type1");
            custom_type2 = rs.getInt("custom_type2");
            manaLeft = rs.getInt("mana_left");
            time = rs.getLong("time");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore an item owned by " + ownerId + " from DB:", e);
            return null;
        }
        L2Item item = ItemTable.getInstance().getTemplate(item_id);
        if (item == null) {
            _log.severe("Item item_id=" + item_id + " not known, object_id=" + objectId);
            return null;
        }
        inst = new L2ItemInstance(objectId, item);
        inst._ownerId = ownerId;
        inst.setCount(count);
        inst._enchantLevel = enchant_level;
        inst._type1 = custom_type1;
        inst._type2 = custom_type2;
        inst._loc = loc;
        inst._locData = loc_data;
        inst._existsInDb = true;
        inst._storedInDb = true;
        inst._mana = manaLeft;
        inst._time = time;
        if (inst.isEquipable()) {
            inst.restoreAttributes();
        }
        return inst;
    }

    public final void dropMe(L2Character dropper, int x, int y, int z) {
        ThreadPoolManager.getInstance().executeTask(new ItemDropTask(this, dropper, x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInDb() {
        assert (this._existsInDb);
        if (this._wear) {
            return;
        }
        if (this._storedInDb) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE items SET owner_id=?,count=?,loc=?,loc_data=?,enchant_level=?,custom_type1=?,custom_type2=?,mana_left=?,time=? WHERE object_id = ?");
            statement.setInt(1, this._ownerId);
            statement.setLong(2, this.getCount());
            statement.setString(3, this._loc.name());
            statement.setInt(4, this._locData);
            statement.setInt(5, this.getEnchantLevel());
            statement.setInt(6, this.getCustomType1());
            statement.setInt(7, this.getCustomType2());
            statement.setInt(8, this.getMana());
            statement.setLong(9, this.getTime());
            statement.setInt(10, this.getObjectId());
            statement.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update item " + this + " in DB: Reason: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoDb() {
        assert (!this._existsInDb && this.getObjectId() != 0);
        if (this._wear) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("INSERT INTO items (owner_id,item_id,count,loc,loc_data,enchant_level,object_id,custom_type1,custom_type2,mana_left,time) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            statement.setInt(1, this._ownerId);
            statement.setInt(2, this._itemId);
            statement.setLong(3, this.getCount());
            statement.setString(4, this._loc.name());
            statement.setInt(5, this._locData);
            statement.setInt(6, this.getEnchantLevel());
            statement.setInt(7, this.getObjectId());
            statement.setInt(8, this._type1);
            statement.setInt(9, this._type2);
            statement.setInt(10, this.getMana());
            statement.setLong(11, this.getTime());
            statement.executeUpdate();
            this._existsInDb = true;
            this._storedInDb = true;
            statement.close();
            if (this._augmentation != null) {
                this.updateItemAttributes(con);
            }
            if (this._elementals != null) {
                this.updateItemElements(con);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not insert item " + this + " into DB: Reason: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDb() {
        assert (this._existsInDb);
        if (this._wear) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("DELETE FROM items WHERE object_id=?");
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            this._existsInDb = false;
            this._storedInDb = false;
            statement.close();
            statement = con.prepareStatement("DELETE FROM item_attributes WHERE itemId = ?");
            statement.setInt(1, this.getObjectId());
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not delete item " + this + " in DB: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    @Override
    public String toString() {
        return this._item + "[" + this.getObjectId() + "]";
    }

    public void resetOwnerTimer() {
        if (this.itemLootShedule != null) {
            this.itemLootShedule.cancel(true);
        }
        this.itemLootShedule = null;
    }

    public void setItemLootShedule(ScheduledFuture<?> sf) {
        this.itemLootShedule = sf;
    }

    public ScheduledFuture<?> getItemLootShedule() {
        return this.itemLootShedule;
    }

    public void setProtected(boolean is_protected) {
        this._protected = is_protected;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isNightLure() {
        return this._itemId >= 8505 && this._itemId <= 8513 || this._itemId == 8485;
    }

    public void setCountDecrease(boolean decrease) {
        this._decrease = decrease;
    }

    public boolean getCountDecrease() {
        return this._decrease;
    }

    public void setInitCount(int InitCount) {
        this._initCount = InitCount;
    }

    public long getInitCount() {
        return this._initCount;
    }

    public void restoreInitCount() {
        if (this._decrease) {
            this.setCount(this._initCount);
        }
    }

    public boolean isTimeLimitedItem() {
        return this._time > 0L;
    }

    public long getTime() {
        return this._time;
    }

    public long getRemainingTime() {
        return this._time - System.currentTimeMillis();
    }

    public void endOfLife() {
        L2PcInstance player = L2World.getInstance().getPlayer(this.getOwnerId());
        if (player != null) {
            if (this.isEquipped()) {
                L2ItemInstance[] unequiped = player.getInventory().unEquipItemInSlotAndRecord(this.getLocationSlot());
                InventoryUpdate iu = new InventoryUpdate();
                for (L2ItemInstance item : unequiped) {
                    player.checkSShotsMatch(null, item);
                    iu.addModifiedItem(item);
                }
                player.sendPacket(iu);
                player.broadcastUserInfo();
            }
            if (this.getLocation() != ItemLocation.WAREHOUSE) {
                player.getInventory().destroyItem("L2ItemInstance", this, player, null);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addRemovedItem(this);
                player.sendPacket(iu);
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(14, player.getCurrentLoad());
                player.sendPacket(su);
            } else {
                player.getWarehouse().destroyItem("L2ItemInstance", this, player, null);
            }
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TIME_LIMITED_ITEM_DELETED));
            L2World.getInstance().removeObject(this);
        }
    }

    public void scheduleLifeTimeTask() {
        if (!this.isTimeLimitedItem()) {
            return;
        }
        if (this.getRemainingTime() <= 0L) {
            this.endOfLife();
        } else {
            if (this._lifeTimeTask != null) {
                this._lifeTimeTask.cancel(false);
            }
            this._lifeTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleLifeTimeTask(this), this.getRemainingTime());
        }
    }

    public void updateElementAttrBonus(L2PcInstance player) {
        if (this._elementals == null) {
            return;
        }
        for (Elementals elm : this._elementals) {
            elm.updateBonus(player, this.isArmor());
        }
    }

    public void removeElementAttrBonus(L2PcInstance player) {
        if (this._elementals == null) {
            return;
        }
        for (Elementals elm : this._elementals) {
            elm.removeBonus(player);
        }
    }

    public void setDropperObjectId(int id) {
        this._dropperObjectId = id;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._dropperObjectId != 0) {
            activeChar.sendPacket(new DropItem(this, this._dropperObjectId));
        } else {
            activeChar.sendPacket(new SpawnItem(this));
        }
    }

    public final DropProtection getDropProtection() {
        return this._dropProtection;
    }

    public boolean isPublished() {
        return this._published;
    }

    public void publish() {
        this._published = true;
    }

    @Override
    public void decayMe() {
        if (Config.SAVE_DROPPED_ITEM) {
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
        super.decayMe();
    }

    public boolean isQuestItem() {
        return this.getItem().isQuestItem();
    }

    public static class ScheduleLifeTimeTask
    implements Runnable {
        private final L2ItemInstance _limitedItem;

        public ScheduleLifeTimeTask(L2ItemInstance item) {
            this._limitedItem = item;
        }

        @Override
        public void run() {
            try {
                if (this._limitedItem != null) {
                    this._limitedItem.endOfLife();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class ItemDropTask
    implements Runnable {
        private int _x;
        private int _y;
        private int _z;
        private final L2Character _dropper;
        private final L2ItemInstance _itm;

        public ItemDropTask(L2ItemInstance item, L2Character dropper, int x, int y, int z) {
            this._x = x;
            this._y = y;
            this._z = z;
            this._dropper = dropper;
            this._itm = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            assert (this._itm.getPosition().getWorldRegion() == null);
            if (Config.GEODATA > 0 && this._dropper != null) {
                Location dropDest = GeoData.getInstance().moveCheck(this._dropper.getX(), this._dropper.getY(), this._dropper.getZ(), this._x, this._y, this._z, this._dropper.getInstanceId());
                this._x = dropDest.getX();
                this._y = dropDest.getY();
                this._z = dropDest.getZ();
            }
            if (this._dropper != null) {
                L2ItemInstance.this.setInstanceId(this._dropper.getInstanceId());
            } else {
                L2ItemInstance.this.setInstanceId(0);
            }
            L2ItemInstance l2ItemInstance = this._itm;
            synchronized (l2ItemInstance) {
                this._itm.setIsVisible(true);
                this._itm.getPosition().setWorldPosition(this._x, this._y, this._z);
                this._itm.getPosition().setWorldRegion(L2World.getInstance().getRegion(L2ItemInstance.this.getPosition().getWorldPosition()));
            }
            this._itm.getPosition().getWorldRegion().addVisibleObject(this._itm);
            this._itm.setDropTime(System.currentTimeMillis());
            this._itm.setDropperObjectId(this._dropper != null ? this._dropper.getObjectId() : 0);
            L2World.getInstance().addVisibleObject(this._itm, this._itm.getPosition().getWorldRegion());
            if (Config.SAVE_DROPPED_ITEM) {
                ItemsOnGroundManager.getInstance().save(this._itm);
            }
            this._itm.setDropperObjectId(0);
        }
    }

    public static class ScheduleConsumeManaTask
    implements Runnable {
        private final L2ItemInstance _shadowItem;

        public ScheduleConsumeManaTask(L2ItemInstance item) {
            this._shadowItem = item;
        }

        @Override
        public void run() {
            try {
                if (this._shadowItem != null) {
                    this._shadowItem.decreaseMana(true);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static enum ItemLocation {
        VOID,
        INVENTORY,
        PAPERDOLL,
        WAREHOUSE,
        CLANWH,
        PET,
        PET_EQUIP,
        LEASE,
        REFUND,
        MAIL;

    }
}

