/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillSpellbookTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.datatables.SubPledgeSkillTree;
import com.l2jserver.gameserver.model.L2PledgeSkillLearn;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TransformManagerInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillInfo;
import java.util.logging.Logger;

public class RequestAcquireSkillInfo
extends L2GameClientPacket {
    private static final String _C__6B_REQUESTAQUIRESKILLINFO = "[C] 6B RequestAcquireSkillInfo";
    private static Logger _log = Logger.getLogger(RequestAcquireSkillInfo.class.getName());
    private int _id;
    private int _level;
    private int _skillType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._id <= 0 || this._level <= 0) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        boolean canteach = false;
        if (skill == null) {
            if (Config.DEBUG) {
                _log.warning("skill id " + this._id + " level " + this._level + " is undefined. aquireSkillInfo failed.");
            }
            return;
        }
        switch (this._skillType) {
            case 0: {
                L2SkillLearn[] skills;
                if (trainer instanceof L2TransformManagerInstance) {
                    L2TransformSkillLearn[] skillst;
                    int itemId = 0;
                    for (L2TransformSkillLearn s : skillst = SkillTreeTable.getInstance().getAvailableTransformSkills(activeChar)) {
                        if (s.getId() != this._id || s.getLevel() != this._level) continue;
                        canteach = true;
                        itemId = s.getItemId();
                        break;
                    }
                    if (!canteach) {
                        return;
                    }
                    int requiredSp = 0;
                    AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), requiredSp, 0);
                    asi.addRequirement(99, itemId, 1, 50);
                    this.sendPacket(asi);
                    return;
                }
                if (!trainer.getTemplate().canTeach(activeChar.getSkillLearningClassId())) {
                    return;
                }
                for (L2SkillLearn s : skills = SkillTreeTable.getInstance().getAvailableSkills(activeChar, activeChar.getSkillLearningClassId())) {
                    if (s.getId() != this._id || s.getLevel() != this._level) continue;
                    canteach = true;
                    break;
                }
                if (!canteach) {
                    return;
                }
                int requiredSp = SkillTreeTable.getInstance().getSkillCost(activeChar, skill);
                AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), requiredSp, 0);
                int spbId = -1;
                if (Config.DIVINE_SP_BOOK_NEEDED && skill.getId() == 1405) {
                    spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill, this._level);
                } else if (Config.SP_BOOK_NEEDED && skill.getLevel() == 1) {
                    spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill);
                }
                if (spbId > -1) {
                    asi.addRequirement(99, spbId, 1, 50);
                }
                this.sendPacket(asi);
                break;
            }
            case 2: {
                L2PledgeSkillLearn[] skills;
                int requiredRep = 0;
                int itemId = 0;
                int itemCount = 0;
                for (L2PledgeSkillLearn s : skills = SkillTreeTable.getInstance().getAvailablePledgeSkills(activeChar)) {
                    if (s.getId() != this._id || s.getLevel() != this._level) continue;
                    canteach = true;
                    requiredRep = s.getRepCost();
                    itemId = s.getItemId();
                    itemCount = s.getItemCount();
                    break;
                }
                if (!canteach) {
                    return;
                }
                AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), requiredRep, 2);
                if (Config.LIFE_CRYSTAL_NEEDED) {
                    asi.addRequirement(1, itemId, itemCount, 0);
                }
                this.sendPacket(asi);
                break;
            }
            case 3: {
                if (!(trainer instanceof L2SquadTrainer)) break;
                SubPledgeSkillTree.SubUnitSkill sus = SubPledgeSkillTree.getInstance().getSkill(SkillTable.getSkillHashCode(skill));
                AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), sus.getReputation(), 3);
                asi.addRequirement(0, sus.getItemId(), sus.getCount(), 0);
                this.sendPacket(asi);
                break;
            }
            case 4: 
            case 5: {
                Quest[] qlst = trainer.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_LEARN);
                if (qlst != null && qlst.length == 1) {
                    if (qlst[0].notifyAcquireSkillInfo(trainer, activeChar, skill)) break;
                    qlst[0].notifyAcquireSkillList(trainer, activeChar);
                    return;
                }
                return;
            }
            case 6: {
                L2SkillLearn[] skillsc;
                int costid = 0;
                int costcount = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSpecialSkills(activeChar)) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    canteach = true;
                    costid = s.getIdCost();
                    costcount = s.getCostCount();
                }
                AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), 0, 6);
                asi.addRequirement(5, costid, costcount, 0);
                this.sendPacket(asi);
                break;
            }
            default: {
                L2SkillLearn[] skillsc;
                int costid = 0;
                int costcount = 0;
                int spcost = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSkills(activeChar)) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    canteach = true;
                    costid = s.getIdCost();
                    costcount = s.getCostCount();
                    spcost = s.getSpCost();
                }
                AcquireSkillInfo asi = new AcquireSkillInfo(skill.getId(), skill.getLevel(), spcost, 1);
                asi.addRequirement(4, costid, costcount, 0);
                this.sendPacket(asi);
                break;
            }
        }
    }

    @Override
    public String getType() {
        return _C__6B_REQUESTAQUIRESKILLINFO;
    }
}

