/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestDeleteReceivedPost
extends L2GameClientPacket {
    private static final String _C__D0_68_REQUESTDELETERECEIVEDPOST = "[C] D0:68 RequestDeleteReceivedPost";
    private static final int BATCH_LENGTH = 4;
    int[] _msgIds = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 4 != this._buf.remaining()) {
            return;
        }
        this._msgIds = new int[count];
        for (int i = 0; i < count; ++i) {
            this._msgIds[i] = this.readD();
        }
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || this._msgIds == null || !Config.ALLOW_MAIL) {
            return;
        }
        if (!activeChar.isInsideZone((byte)1)) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_USE_MAIL_OUTSIDE_PEACE_ZONE));
            return;
        }
        for (int msgId : this._msgIds) {
            Message msg = MailManager.getInstance().getMessage(msgId);
            if (msg == null) continue;
            if (msg.getReceiverId() != activeChar.getObjectId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to delete not own post!", Config.DEFAULT_PUNISH);
                return;
            }
            if (msg.hasAttachments() || msg.isDeletedByReceiver()) {
                return;
            }
            msg.setDeletedByReceiver();
        }
        activeChar.sendPacket(new ExChangePostState(true, this._msgIds, 0));
    }

    @Override
    public String getType() {
        return _C__D0_68_REQUESTDELETERECEIVEDPOST;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

