/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.File;
import java.io.FileNotFoundException;
import javax.script.ScriptException;

public abstract class ManagedScript {
    private File _scriptFile = L2ScriptEngineManager.getInstance().getCurrentLoadingScript();
    private long _lastLoadTime;
    private boolean _isActive;

    public ManagedScript() {
        this.setLastLoadTime(System.currentTimeMillis());
    }

    public boolean reload() {
        try {
            L2ScriptEngineManager.getInstance().executeScript(this.getScriptFile());
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (ScriptException e) {
            return false;
        }
    }

    public abstract boolean unload();

    public void setActive(boolean status) {
        this._isActive = status;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public File getScriptFile() {
        return this._scriptFile;
    }

    protected void setLastLoadTime(long lastLoadTime) {
        this._lastLoadTime = lastLoadTime;
    }

    protected long getLastLoadTime() {
        return this._lastLoadTime;
    }

    public abstract String getScriptName();

    public abstract ScriptManager<?> getScriptManager();
}

