/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package custom.FortuneTelling;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;

/**
 * @authors Kerberos (python), Nyaran (java)
 */
public class FortuneTelling extends Quest
{
	private static final String qn = "FortuneTelling";

	private static final int ADENA = 57;
	private static final int COST = 1000;

	private static final int NPC = 32616;

	private static final String[] FORTUNE =
	{
		"ڕWWQꂽA󂯂肷B",
		"ڕWɌĐiމߒŗ\zO̖肪邩ȂB",
		"󋵂sɂȂāAsŏőɎ邱ƂɂȂB",
		"ꂪ낤Ȃ΁Af݂͂ėɂȂʂƂBCB",
		"MłlɉāA`XށB",
		"pbƂȂ炵B",
		"lCĎ͂̎gɏW߂B",
		"d|ĂaɋHB",
		"ƒfŎi߂΁AꂫB",
		"mbƑn͂ŖڕWBB",
		"킫ڂӂ炸ɎdɐS΁AڕWBłB",
		"mb𓭂ʂU߂Η͂𓾂B",
		"ڕW߂ėECčs΁AʂB",
		"Ȃ鍢낤ƂA肭B",
		"ʂATdɌĎuāB",
		"uĂ肪ȂAɍlB",
		"ɋ󂪓]荞łB",
		"sK̐̉ɐ܂ꂽȂB^C㏸ĕxƖ_ɂB",
		"Ă\zȌ𓾂Č悤ɂȂB",
		"傫ȎdB",
		"ɔ߂Ă₵Ɗ𐁂΂ĂMlɉB",
		"͂̐lX̌ɗ͂𓾂B",
		"~ɐiށB",
		"~ȐlԊ֌Wێ΁AȂ̉l߂ĂlB",
		"̎LׂNBɋ͂SYꂸɁB",
		"܂^񂾂Ƃĕߐɗ߁B",
		"dAAlԊ֌WׂĂɂĉʂԂ΂ƂNB",
		"Ďdɒe͂tB",
		"_IɂIɂ𓾂ĐB",
		"ńA˔\AĈӂ܂ŊFDB",
		"FȂ悤ƂB",
		"HɂFB",
		"lXȐlɏoėǉɂ߂荇B",
		"wсAǂ߂p̐SBɂĐ^ȑԓxŗՂ߁B",
		"t̒gȋCɏĂĂԂɂƂ܂B",
		"ǂ肵ɁAu~AB",
		"͂̐lXɒgڂΈ萶B",
		"^ꂽd𒅎ɐi߂΁AM𓾂ĂɍXe[Wɐi߂B",
		"^C㏸B~𒣂ΖAɋAB",
		"lƂ̕t܂߂ɁB",
		"𓾂B",
		"͂ꂩ̖؂ɎȂB",
		"w͂ēʂŕ܂𓾂B",
		"AMOĐi߂Α傫ȐʂB",
		"Ȃ̖͂͂ǂȂƂłꏊȂƂB",
		"ľƂɐU񂳂ׂ炸BMB",
		"̂̌ςđnIȍlāB",
		"炸]TČʂ҂Ă΂ʂB",
		"lԂB",
		"̏oȂ҂󂯂B",
		"Ȃڂő听߂B",
		"߂ĂƂɊՂNBŌ܂ł߂ȁB",
		"ڕWBɍőPspKvB",
		"RlɏoāÅ͂𓾂B",
		"炵ɑ傫ȏ𓾂B",
		"WւƂȂ`XށB",
		"邪llB",
		"ɍƐH]荞łB",
		"l畨IA_Iȏ𓾂ċꋫEB",
		"߂ڕW͂Ƃ΁AƏ̎肪LׂB",
		"^ŐȑԓxۂĂ΁A̐lXMB",
		"Nɂ炸ɕ点B",
		"Ԃ̎ԗւȂB",
		"uĂA̎WB",
		"ڕWɌ簐i邪Avقǂ̐ʂ͓ȂB",
		"זĔY܂B",
		"̏lɋsΎsB",
		"ATdɂBȂΎ̐lX̐MB",
		"Ȃ݂D@҂āB",
		"nmA\𓾂BȂڂ̗\B",
		"ɃpXĕxƖ_𓾂B",
		"ƖB",
		"GȖ͏B",
		"߂ƂŔY܂AڕWĂĎɓw͂΂ʂB",
		"K͑ŔjׂB",
		"Cꂽd͐ӔCĂʂBA͂̏ϋɓIɋ߂B",
		"΂YށB",
		"]݂Ė_ƍ𓾂B",
		"v悪vʂɐiށB",
		"vʂƂ납K`X]荞ށB",
		"Ă͑ATdɍlB",
		"lɎނȁB",
		"ɍsBfӂ񂾂肷̂͋֕B",
		"lɂ͐ɂ݂Ȃ𒍂B傫ȕ܂B",
		"daɗǖ𓾂B",
		"aŋꂵނAǖ𓾂Ċ͂߂B",
		"ꋫŋMlɏo]݂B",
		"Hɂ͓́B",
		"΂Yꂸ܂Ȃ΁A̐lXMƏ𓾂B",
		"ω͈B",
		"ATdmɐi߂ׂB",
		"葫킸di߂ȂB",
		"i͂܂悤B",
		"pAdɏWłȂB",
		"蕿lɉ肳B",
		"młȂΎȁB",
		"ɔB",
		"@ɕmĂ߂ɂ܂ʓw͂BF߂ĂlB",
		"̐^̎pB",
		"Xɐ^𔭊B",
		"ʂłBVƂǂ߂BȂ̉lオB",
		"dlԊ֌W悭BʂB",
		"ߐM͍Ђ̂ƁBԂƋ͂B",
		"Sɋ_B",
		"Sɋ_BƖڕWB",
		"dAAƑAlB^C㏸B",
		"ƂGȂB",
		"vʂƂ납K`X]荞ށB",
		"~Čli߂ΉB",
		"ÂɍlāATdɍsB",
		"Bʂ͂ĂB",
		"܂葹̂тׂB",
		"ċꋫɗB",
		"ɐiłƂɋ}u[LB",
		"vقǂ̐ʂ͓ꂸǂB",
		"̐lXɓU点ΐlԊ֌WɂЂтB",
		"~𒣂炸AmB",
		"lB",
		"lԊ֌WɋCgΊFǂȂAB",
		"ltŗQ֌W΂lėVȂ΁AA@ĐM͒nɗB",
		"ɑ̗ɗčlāA^SŐڂB",
		"ْȁB",
		"ƒfŎi߂ΎsB̌ƂɎXB",
		"炭ǰʂB",
		"d̃S[ǂB",
		"{肵ĂǂB",
		"ꏊŎɂĂ̂ɖɂԂB",
		"ɎMAl𗊂ɂȂB",
		"ɓI߂Ă͔W͖]߂ȂBMɏ]B",
		"sȂƂɂ͎ȁBM̒ulTB",
		"ɏオ͓̂悤B",
		"邱ƂȂƂ܂ȂB",
		"ߐMė~΁A܂͂̂ƂsB",
		"sȏ󋵂ŏőɎB",
		"ڂɑȂ悤ɐʂڂāB",
		"ƒfIȍsT߁BF̐S߂B",
		"炭炷B",
		"悩ʂƂNāAꋫɗB",
		"lԊ֌WɂЂтB",
		"菈͏ł͂ȂA{̌B",
		"}ĐS𕽉ɕۂāB",
		"Θb͐ւ̋ߓB",
		"AMāB",
		"Iڂ݁B",
		"ȂڂɋKƃ`XB",
		"͏B\ʋKƐʂɂB",
		"GɈB΂炭̊Ԃ͉^Ɍb܂B",
		"v͒ɁAs͂΂₭B",
		"ȌׂĒBʂ͂Ȃ̉l߂B",
		"߂Ȃ݂Ȃ΁AɕȂقǂ̑厸sB",
		"\O̔o͔Ɏ󂯓B",
		"vƂɂȂȂĂAȁB",
		"mɈӎuƁBȂ΁AɗB",
		"ڂ͒ĂĂS͋сB",
		"̖ɎɂŐlBl]B",
		"ŜyXB",
		"ځ[ƂĂ邤ɖ]܂ʕɐiށB",
		"VɐlɉĂAlɂ͂ȂȂ߂荇ȂB",
		"肩Ȃ߂B",
		"邢B͕ω̎łȂB",
		"gƂ͖̂߂̓B",
		"l̂߂ɂgĂǂԂɎ̂Ă̂ƓBlɒӂB",
		"QɒӁB",
		"iiv[gCxgɎQB哖̗\B",
		"RK^ށB",
		"҂lB",
		"l̕]ȂǋCɂɃ}Cy[Xێ΂ʂB",
		"\zO̍K^łAЂŐAɋABӂB",
		"ŉ΂ɓĂ̒BߐM͋֕B",
		"dvȔf͌ɂB",
		"ڏ̐l⒇Ԃ̌tŃguB",
		"tő菝ꂽ肷B",
		"rbO}EX͘Q̂ƁB",
		"邪A܂킹BȂΑ化܂ɂȂB",
		"Ȏ咣̂Ŕ𔃂B",
		"Aʂ悤A𔃂sT߁B",
		"ɒӁB",
		"ɘbɂ͂ÂāB",
		"lԊ֌WBT߁B",
		"dvȌ̏uԁBlڂCɂAvʂɐi߂BACǂ߁B",
		"ėɏoB",
		"ACfBAԁBȂ̃AhoCXKvƂĂƂɍsB",
		"Ȃ̃AhoCX̐lςB",
		"ߎɊׂ邱ƂȂAOɒuB",
		"悭Yłv𗧂ĂB",
		"߂lƂ̌܂ɒӁB䖝̂݁B",
		"KvłS͂ȁBvCh邾B",
		"ȋRǉɂȂB",
		"łɂȂΊ@B",
		"Ƃgu̎킠B݁A}i[ɂCB",
		"ςِɏoB",
		"~肷čЂB",
		"^Bxo}B",
		"^悩炸B̖S͑ɂȁB",
		"ׂƂ𖾓悤Ƃ΋ꋫɗB",
		"ɏPĂӔCĖ]߂΂ʂ𓾂B",
		"ǂĂƐӔĈdBKB",
		"gӐ˂΁AWłȂB",
		"l͒ǂ҂gB",
		"ً}łĂ炩Lׂׂ炸Bpč܂jڂɁB",
		"^㏸B",
		"vŎi߂΁A@ɕmB",
		"ڏ̐l̑Oł͍Α̐U镑B",
		"VɂȂΉ^B",
		"^𒷎B",
		"O҂̏oɂOp֌WɂpSB",
		"ƓX^C̐lTB",
		"It@[͒fB͎ł͂ȂB",
		"}悤ȃIt@[͒fB",
		"uɂlX̃lbg[NBɑ傫d邱ƂɂȂB",
		"Ȃ͏^ȐlƌċߊĂ҂ɋCB",
		"\̋ꂠBȂ߂ꂽ呹B",
		"͌̎ł͂ȂB̍l펯ɉfB",
		"S̎コŏdׂwށBȎ咣͂͂ƁB",
		"ׂ̗VѐlɗpSBgűꂠB",
		"rMi[YbN̗\B",
		"^͂AmׂB",
		"~肷ĖׂB",
		"lłł邱ƂłNƂƂB",
		"ł̐SȂƂ͘aB킪܂܂΋ꋫɗB",
		"߂l̒mȂƂ킩B",
		"ς̂ĂBƂ͈Ⴄ^Cv̐lƂB",
		"[_[ɂȂ\Bl̏ɗA炢B",
		"^㏸BēB",
		"^͍ŗǂň̂ǂ炩B",
		"ׂȑŋ߂lƂ̒ȂB",
		"^㏸B",
		"͐l̂߂Ȃ炸B",
		"𔃂Ύ̋ꂠB",
		"󂯂ĂȒPɐMĂ͂ȂȂB",
		"΂ɂ͕B",
		"ȑł܂ł悭悷ȁB",
		"R~jP[V܂AB",
		"l̏W܂Ƃ납K^ĂB",
		"܂̂͋pĂ悭ȂB",
		"ڂ蒆g̐SB",
		"lԊ֌W͂ƌ܂炢B",
		"ƂqŖׂB",
		"lԊ֌W̓EFbgɂȂ肷Ȃ悤ɁBÂɍl邱ƂKvB",
		"d͌yd킸ǂi߂ׂB",
		"蒲ׂĎMčs΁AFɕB",
		"΂ĎW߂B",
		"dvȌ͉BK͔̎B",
		"߂l̏Sɍ߁B",
		"ȂO҂̗ꂩlB~ȉ􂪌B",
		"߂lƂ̎͒fB̒ɂƂB",
		"baɂΎdグɖ肪B",
		"̋ʂ͂ƁB",
		"d肭ȂȂ牡Ă݂̂̎B",
		"ȂƂƔ΂΁A\zȌ󋵂ɋꂵ߂B",
		"lɂ͕Kvȏ˂ނȁB",
		"f؂AmȈӎv\ɂ͕KvB",
		"ߋ̂ƂŌBsɒӂB",
		"ɗĎԂ𖳑ʂɂBԊǗɋCB",
		"ĝȂ`S͈ӖȂB",
		"ꂽlƒ肹B֌W񕜂B",
		"ɍsɂǂAɏoB",
		"኱̑ւ̓B",
		"~~ĂԁBmׂB",
		"li߂΃guɊ܂B󋵂悭ǂ߁B",
		"lӂ߂莩Ȃ݂B",
		"Ƃ̍sŊ@𓦂B㏈ƁB",
		"VȒւ̗~킭BLׂB",
		"vCĥĂΌB",
		"VɂȂ炸̏ɎXB",
		"ɂ鎞ɔB",
		"܂nBvʂɐɐi߂B",
		"vŎi߂ΐ_IAKIɑ呹Bpӂ͂ƁB",
		"l̖ڂɋCĂȂȂIȂB",
		"ǂmŏB",
		"ڐׂ̍ȗvɕ߂ȁBlƂ̊֌WB",
		"qɕĂ悭悷ȁB",
		"Ȏ̂gűꂠB]TāB",
		"񑩂j΋ꋫɗB",
		"̋ꂠB͕ۗB",
		"lƂ̔rɂȂB",
		"ɂ͒ɂ݂tBJbオB",
		"VĐsB",
		"ȂƂő傫ȏ΂B",
		"ʂ悵BMčsB",
		"܂Ƃ낪ȂȂ瓰XƌB",
		"eɂVBȂΌǗ̋B",
		"ʂ̂Ƃł܂ł悭悷ȁB悩ʂƂNB",
		"rœoΌXƂɂȂBCāB",
		"c̍sł͓ȂB",
		"ł΂炸B󋵂ɂ͔\IɑΏB",
		"őpďȍK^߁B",
		"̋ꂠB厖Ȃ̂Ȃ炿ƕۊǂB",
		"w͕͂B",
		"VɃX^[g؂CŗՂ߂΁Asɕ₦B",
		"肪ΕSɕςB",
		"~̒肷Őςݏd˂ĂƂxɕB",
		"ɘ_͎ΐS₩B",
		"u̖fŉAjڂɁB",
		"~ӂB߂Ō܂ł΂B",
		"߂lɂ͋Cg₳B͐l̂߂Ȃ炸B",
		"|WeBuVLOʂɂȂB",
		"߂l̃~X͂΂ĂB",
		"\zO̎xoB",
		"ĂłȂΌǂB؂ʂvB",
		"ANZT[bL[ACeB",
		"dČB͖LB",
		"ׂȌɂȂB",
		"]Tĉ~ɐi߂B",
		"~炸v̐SāBSȂĂʂ낤B",
		"sȂƂɍsB",
		"l̏W܂Ƃ납K^ĂB",
		"Ȃ̂͂yĐMpB[AĂA^ʖڂKvB",
		"ߒɖ肪ĂA㏈肷΂ʂB",
		"dΓ̂Bꏊ΂̕܂B",
		"ꃖɗ܂炸ǂǂ񓮂B",
		"lŔwŗUfł߂ɂȂB",
		"ȂƂłXB",
		"炵ג҂̗\BȂƂ؂ɂB",
		"̂҂AĂ܂B",
		"Ƃxȍ͎ɂȂBɂނȁB",
		"Ufɘf킳₷B}B",
		"ȂƂƑaɂāAŋƂɂȂB",
		"ߖxBgׂƂ͎gB",
		"ΌɂƂ΁A𓾂ĂB",
		"bL[ACe̓XC[cB",
		"؋͕ԂĂ炦B͕UĂ炦B",
		"{̖ŖCNB",
		"߂l̏ȍsɋCgBA͋֕B",
		"XgX͕\ɏoAΊYȁB",
		"ωΏ𓾂B",
		"ԊǗOꂹB]݂̌ʂB",
		"ZʂȂȂA炢ƂNB",
		"fbꐶBÂɁB",
		"͉̒B",
		"^BɗΑB",
		"DȐl֘A邱ƂȂ]ݓxʂi߂Ă悢B",
		"ِƘbĐSʂB",
		"ɎcƂɓ̂gB",
		"yƂɓΏ𓾂B",
		"ZȂBттƍsB",
		"u̖fŉAjڂɁB",
		"K̎͋BƂĂB",
		"Ζʂł͎ŝȂ悤ɁB",
		"ȂȂȂƂɎԂĂȂBȁB",
		"葹邱Ƃ͂ȁB",
		"ǉ̒BِɊ֐SāB",
		"̂t͂ΈꋓB",
		"ėv𓾂B",
		"҂ĂΊCH̓aB",
		"ِK^炷B",
		"l̗݂𕷂΍K^ĂB",
		"ꂵĂΊYȁBK^͂ɂB",
		"܂BĂB܂oƂB",
		"BĂ܂oB̉l܂B",
		"ǂCC悭ՂŉɎ߁BʂƋɉBꂽ\͂łB",
		"yVIŃ[AYȂȂ̎ɂ͏Ί炪₦ȂB",
		"mbƋZŎd͏B",
		"ւƓ҂B",
		"킹̒ϗ͂Ɠ@͂B",
		"ɍK^炷B",
		"}ĖڕWBB",
		"Ml̓ŕx搉̂B",
		"IȖِ͂ɏoB",
		"͑S͂Ő킦B",
		"ߋ̍šʂoB",
		"Ɨꂪ΂ɁB",
		"̒Eđ̒B",
		"A_𓾂B",
		"ωւ̗~]ӂBVȂƂɃ`WB",
		"\ƗUf߂B{͉BB",
		"Nq낤ɋߊ炸B",
		"ωȁB@̓`XB",
		"MƍCōsBsł܂B",
		"邢҂ĂB",
		"x͂Ȃ鐬ւ̋ߓB",
		"|WeBuɍlčsB",
		"|WeBuŊ͂ӂ邠Ȃ͕̒SɗB",
		"Ă̒MčsB",
		"yBΊŎ𖾂邭B",
		"ߋ̍sɑ΂鐳ȕ]ƕ܂҂ĂB",
		"ق炩̎d؋ЕtBVȊт̒B",
		"đB",
		"܂ł̎d̕܂𓾂B",
		"тׂ{ׂ̖ɂȂB",
		"Đ̗͋BÂ̂ĂĐV𓾂B",
		"肩畨SʂŏB",
		"ւ肪҂ĂB",
		"lɉB",
		"҂͑B",
		"MlLׂBʂ肩̐l悭B",
	};

	public FortuneTelling(int questId, String name, String descr)
	{
		super(questId, name, descr);
		addStartNpc(NPC);
		addTalkId(NPC);
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		NpcHtmlMessage html = new NpcHtmlMessage(1);
		String PARENT_DIR = "data/scripts/custom/FortuneTelling/";
		
		if (st == null)
			return null;

		if (st.getQuestItemsCount(ADENA) < COST)
			html.setFile(player.getHtmlPrefix(), PARENT_DIR + "lowadena.htm");
		else
		{
			st.takeItems(ADENA, COST);
			html.setFile(player.getHtmlPrefix(), PARENT_DIR + "fortune.htm");
			html.replace("%fortune%", FORTUNE[st.getRandom(FORTUNE.length)]);
		}
		st.exitQuest(true);
		player.sendPacket(html);
		return null;
	}

	public static void main(String args[])
	{
		new FortuneTelling(-1, qn, "custom");
	}
}
