/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2ArmorSet;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArmorSetsTable {
    private static Logger _log = Logger.getLogger(ArmorSetsTable.class.getName());
    private TIntObjectHashMap<L2ArmorSet> _armorSets = new TIntObjectHashMap();

    public static ArmorSetsTable getInstance() {
        return SingletonHolder._instance;
    }

    private ArmorSetsTable() {
        this.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT chest, legs, head, gloves, feet, skill, shield, shield_skill_id, enchant6skill, mw_legs, mw_head, mw_gloves, mw_feet, mw_shield FROM armorsets");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int chest = rset.getInt("chest");
                int legs = rset.getInt("legs");
                int head = rset.getInt("head");
                int gloves = rset.getInt("gloves");
                int feet = rset.getInt("feet");
                String[] skills = rset.getString("skill").split(";");
                int shield = rset.getInt("shield");
                int shield_skill_id = rset.getInt("shield_skill_id");
                int enchant6skill = rset.getInt("enchant6skill");
                int mw_legs = rset.getInt("mw_legs");
                int mw_head = rset.getInt("mw_head");
                int mw_gloves = rset.getInt("mw_gloves");
                int mw_feet = rset.getInt("mw_feet");
                int mw_shield = rset.getInt("mw_shield");
                this._armorSets.put(chest, (Object)new L2ArmorSet(chest, legs, head, gloves, feet, skills, shield, shield_skill_id, enchant6skill, mw_legs, mw_head, mw_gloves, mw_feet, mw_shield));
            }
            _log.info("ArmorSetsTable: Loaded " + this._armorSets.size() + " armor sets.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "ArmorSetsTable: Error reading ArmorSets table: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        if (Config.CUSTOM_ARMORSETS_TABLE) {
            try {
                int cSets = this._armorSets.size();
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT chest, legs, head, gloves, feet, skill, shield, shield_skill_id, enchant6skill, mw_legs, mw_head, mw_gloves, mw_feet, mw_shield FROM custom_armorsets");
                ResultSet rset = statement.executeQuery();
                while (rset.next()) {
                    int chest = rset.getInt("chest");
                    int legs = rset.getInt("legs");
                    int head = rset.getInt("head");
                    int gloves = rset.getInt("gloves");
                    int feet = rset.getInt("feet");
                    String[] skills = rset.getString("skill").split(";");
                    int shield = rset.getInt("shield");
                    int shield_skill_id = rset.getInt("shield_skill_id");
                    int enchant6skill = rset.getInt("enchant6skill");
                    int mw_legs = rset.getInt("mw_legs");
                    int mw_head = rset.getInt("mw_head");
                    int mw_gloves = rset.getInt("mw_gloves");
                    int mw_feet = rset.getInt("mw_feet");
                    int mw_shield = rset.getInt("mw_shield");
                    this._armorSets.put(chest, (Object)new L2ArmorSet(chest, legs, head, gloves, feet, skills, shield, shield_skill_id, enchant6skill, mw_legs, mw_head, mw_gloves, mw_feet, mw_shield));
                }
                _log.info("ArmorSetsTable: Loaded " + (this._armorSets.size() - cSets) + " Custom armor sets.");
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "ArmorSetsTable: Error reading Custom ArmorSets table: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    public boolean setExists(int chestId) {
        return this._armorSets.containsKey(chestId);
    }

    public L2ArmorSet getSet(int chestId) {
        return (L2ArmorSet)this._armorSets.get(chestId);
    }

    private static class SingletonHolder {
        protected static final ArmorSetsTable _instance = new ArmorSetsTable();

        private SingletonHolder() {
        }
    }
}

