/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class HerbDropTable {
    private static Logger _log = Logger.getLogger(HerbDropTable.class.getName());
    private TIntObjectHashMap<FastList<L2DropCategory>> _herbGroups = new TIntObjectHashMap();

    public static HerbDropTable getInstance() {
        return SingletonHolder._instance;
    }

    private HerbDropTable() {
        this.restoreData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreData() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement2 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("groupId", "itemId", "min", "max", "category", "chance") + " FROM herb_droplist_groups ORDER BY groupId, chance DESC");
            ResultSet dropData = statement2.executeQuery();
            L2DropData dropDat = null;
            while (dropData.next()) {
                FastList category;
                int groupId = dropData.getInt("groupId");
                if (this._herbGroups.contains(groupId)) {
                    category = (FastList)this._herbGroups.get(groupId);
                } else {
                    category = new FastList();
                    this._herbGroups.put(groupId, (Object)category);
                }
                dropDat = new L2DropData();
                dropDat.setItemId(dropData.getInt("itemId"));
                dropDat.setMinDrop(dropData.getInt("min"));
                dropDat.setMaxDrop(dropData.getInt("max"));
                dropDat.setChance(dropData.getInt("chance"));
                int categoryType = dropData.getInt("category");
                if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                    _log.warning("Herb Drop data for undefined item template! GroupId: " + groupId + " itemId: " + dropDat.getItemId());
                    continue;
                }
                boolean catExists = false;
                for (L2DropCategory cat : category) {
                    if (cat.getCategoryType() != categoryType) continue;
                    cat.addDropData(dropDat, false);
                    catExists = true;
                    break;
                }
                if (catExists) continue;
                L2DropCategory cat = new L2DropCategory(categoryType);
                cat.addDropData(dropDat, false);
                category.add((Object)cat);
            }
            dropData.close();
            statement2.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "HerbDroplistGroupsTable: Error reading Herb dropdata. ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public FastList<L2DropCategory> getHerbDroplist(int groupId) {
        return (FastList)this._herbGroups.get(groupId);
    }

    private static class SingletonHolder {
        protected static final HerbDropTable _instance = new HerbDropTable();

        private SingletonHolder() {
        }
    }
}

