/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class RaidBossPointsManager {
    private static final Logger _log = Logger.getLogger(RaidBossPointsManager.class.getName());
    private FastMap<Integer, Map<Integer, Integer>> _list;
    private final Comparator<Map.Entry<Integer, Integer>> _comparator = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> entry, Map.Entry<Integer, Integer> entry1) {
            return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue() < entry1.getValue() ? 1 : -1);
        }
    };

    public static final RaidBossPointsManager getInstance() {
        return SingletonHolder._instance;
    }

    public RaidBossPointsManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init() {
        this._list = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT `charId`,`boss_id`,`points` FROM `character_raid_points`");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int charId = rset.getInt("charId");
                int bossId = rset.getInt("boss_id");
                int points = rset.getInt("points");
                Map values = (Map)this._list.get((Object)charId);
                if (values == null) {
                    values = new FastMap();
                }
                values.put(bossId, points);
                this._list.put((Object)charId, (Object)values);
            }
            rset.close();
            statement.close();
            _log.info(this.getClass().getSimpleName() + ": Loaded " + this._list.size() + " Characters Raid Points.");
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "RaidPointsManager: Couldnt load raid points ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updatePointsInDB(L2PcInstance player, int raidId, int points) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO character_raid_points (`charId`,`boss_id`,`points`) VALUES (?,?,?)");
            statement.setInt(1, player.getObjectId());
            statement.setInt(2, raidId);
            statement.setInt(3, points);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not update char raid points:", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final void addPoints(L2PcInstance player, int bossId, int points) {
        int ownerId = player.getObjectId();
        Map tmpPoint = (Map)this._list.get((Object)ownerId);
        if (tmpPoint == null) {
            tmpPoint = new FastMap();
            tmpPoint.put(bossId, points);
            this.updatePointsInDB(player, bossId, points);
        } else {
            int currentPoins = tmpPoint.containsKey(bossId) ? (Integer)tmpPoint.get(bossId) : 0;
            tmpPoint.put(bossId, currentPoins += points);
            this.updatePointsInDB(player, bossId, currentPoins);
        }
        this._list.put((Object)ownerId, (Object)tmpPoint);
    }

    public final int getPointsByOwnerId(int ownerId) {
        Map tmpPoint = (Map)this._list.get((Object)ownerId);
        int totalPoints = 0;
        if (tmpPoint == null || tmpPoint.isEmpty()) {
            return 0;
        }
        Iterator i$ = tmpPoint.values().iterator();
        while (i$.hasNext()) {
            int points = (Integer)i$.next();
            totalPoints += points;
        }
        return totalPoints;
    }

    public final Map<Integer, Integer> getList(L2PcInstance player) {
        return (Map)this._list.get((Object)player.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanUp() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE from character_raid_points WHERE charId > 0");
            statement.executeUpdate();
            statement.close();
            this._list.clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not clean raid points: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final int calculateRanking(int playerObjId) {
        Map<Integer, Integer> rank = this.getRankList();
        if (rank.containsKey(playerObjId)) {
            return rank.get(playerObjId);
        }
        return 0;
    }

    public Map<Integer, Integer> getRankList() {
        FastMap tmpRanking = new FastMap();
        FastMap tmpPoints = new FastMap();
        Iterator i$ = this._list.keySet().iterator();
        while (i$.hasNext()) {
            int ownerId = (Integer)i$.next();
            int totalPoints = this.getPointsByOwnerId(ownerId);
            if (totalPoints == 0) continue;
            tmpPoints.put(ownerId, totalPoints);
        }
        ArrayList list = new ArrayList(tmpPoints.entrySet());
        Collections.sort(list, this._comparator);
        int ranking = 1;
        for (Map.Entry entry : list) {
            tmpRanking.put(entry.getKey(), ranking++);
        }
        return tmpRanking;
    }

    private static class SingletonHolder {
        protected static final RaidBossPointsManager _instance = new RaidBossPointsManager();

        private SingletonHolder() {
        }
    }
}

