/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.AccessLevels;
import java.util.logging.Logger;

public class L2AccessLevel {
    private static Logger _log = Logger.getLogger(L2AccessLevel.class.getName());
    private int _accessLevel = 0;
    private String _name = null;
    L2AccessLevel[] _childsAccessLevel = null;
    private String _childs = null;
    private int _nameColor = 0;
    private int _titleColor = 0;
    private boolean _isGm = false;
    private boolean _allowPeaceAttack = false;
    private boolean _allowFixedRes = false;
    private boolean _allowTransaction = false;
    private boolean _allowAltG = false;
    private boolean _giveDamage = false;
    private boolean _takeAggro = false;
    private boolean _gainExp = false;

    public L2AccessLevel(int accessLevel, String name, int nameColor, int titleColor, String childs, boolean isGm, boolean allowPeaceAttack, boolean allowFixedRes, boolean allowTransaction, boolean allowAltG, boolean giveDamage, boolean takeAggro, boolean gainExp) {
        this._accessLevel = accessLevel;
        this._name = name;
        this._nameColor = nameColor;
        this._titleColor = titleColor;
        this._childs = childs;
        this._isGm = isGm;
        this._allowPeaceAttack = allowPeaceAttack;
        this._allowFixedRes = allowFixedRes;
        this._allowTransaction = allowTransaction;
        this._allowAltG = allowAltG;
        this._giveDamage = giveDamage;
        this._takeAggro = takeAggro;
        this._gainExp = gainExp;
    }

    public int getLevel() {
        return this._accessLevel;
    }

    public String getName() {
        return this._name;
    }

    public int getNameColor() {
        return this._nameColor;
    }

    public int getTitleColor() {
        return this._titleColor;
    }

    public boolean isGm() {
        return this._isGm;
    }

    public boolean allowPeaceAttack() {
        return this._allowPeaceAttack;
    }

    public boolean allowFixedRes() {
        return this._allowFixedRes;
    }

    public boolean allowTransaction() {
        return this._allowTransaction;
    }

    public boolean allowAltG() {
        return this._allowAltG;
    }

    public boolean canGiveDamage() {
        return this._giveDamage;
    }

    public boolean canTakeAggro() {
        return this._takeAggro;
    }

    public boolean canGainExp() {
        return this._gainExp;
    }

    public boolean hasChildAccess(L2AccessLevel accessLevel) {
        if (this._childsAccessLevel == null) {
            if (this._childs == null) {
                return false;
            }
            this.setChildAccess(this._childs);
            for (L2AccessLevel childAccess : this._childsAccessLevel) {
                if (childAccess == null || childAccess.getLevel() != accessLevel.getLevel() && !childAccess.hasChildAccess(accessLevel)) continue;
                return true;
            }
        } else {
            for (L2AccessLevel childAccess : this._childsAccessLevel) {
                if (childAccess == null || childAccess.getLevel() != accessLevel.getLevel() && !childAccess.hasChildAccess(accessLevel)) continue;
                return true;
            }
        }
        return false;
    }

    private void setChildAccess(String childs) {
        String[] childsSplit = childs.split(";");
        this._childsAccessLevel = new L2AccessLevel[childsSplit.length];
        for (int i = 0; i < childsSplit.length; ++i) {
            L2AccessLevel accessLevelInst = AccessLevels.getInstance().getAccessLevel(Integer.parseInt(childsSplit[i]));
            if (accessLevelInst == null) {
                _log.warning("AccessLevel: Undefined child access level " + childsSplit[i]);
                continue;
            }
            if (accessLevelInst.hasChildAccess(this)) {
                _log.warning("AccessLevel: Child access tree overlapping for " + this._name + " and " + accessLevelInst.getName());
                continue;
            }
            this._childsAccessLevel[i] = accessLevelInst;
        }
    }
}

