/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.instancemanager.SiegeGuardManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ControlTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FlameTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SiegeInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Siege
implements Siegable {
    protected static final Logger _log = Logger.getLogger(Siege.class.getName());
    public static final byte OWNER = -1;
    public static final byte DEFENDER = 0;
    public static final byte ATTACKER = 1;
    public static final byte DEFENDER_NOT_APPROWED = 2;
    private int _controlTowerCount;
    private int _controlTowerMaxCount;
    private int _flameTowerCount;
    private int _flameTowerMaxCount;
    private List<L2SiegeClan> _attackerClans = new FastList();
    private List<L2SiegeClan> _defenderClans = new FastList();
    private List<L2SiegeClan> _defenderWaitingClans = new FastList();
    private List<L2ControlTowerInstance> _controlTowers = new FastList();
    private List<L2FlameTowerInstance> _flameTowers = new FastList();
    private Castle[] _castle;
    private boolean _isInProgress = false;
    private boolean _isNormalSide = true;
    protected boolean _isRegistrationOver = false;
    protected Calendar _siegeEndDate;
    private SiegeGuardManager _siegeGuardManager;
    protected ScheduledFuture<?> _scheduledStartSiegeTask = null;
    protected int _firstOwnerClanId = -1;

    public Siege(Castle[] castle) {
        this._castle = castle;
        this._siegeGuardManager = new SiegeGuardManager(this.getCastle());
        this.startAutoTask();
    }

    @Override
    public void endSiege() {
        if (this.getIsInProgress()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_ENDED);
            sm.addFortId(this.getCastle().getCastleId());
            Announcements.getInstance().announceToAll(sm);
            if (this.getCastle().getOwnerId() > 0) {
                L2Clan clan = ClanTable.getInstance().getClan(this.getCastle().getOwnerId());
                sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE);
                sm.addString(clan.getName());
                sm.addFortId(this.getCastle().getCastleId());
                Announcements.getInstance().announceToAll(sm);
                if (clan.getClanId() == this._firstOwnerClanId) {
                    int num = SiegeManager.getInstance().getBloodAllianceReward();
                    int count = this.getCastle().getBloodAlliance();
                    if (num > 0) {
                        this.getCastle().setBloodAlliance(count + num);
                    }
                } else {
                    this.getCastle().setBloodAlliance(0);
                    for (L2ClanMember member : clan.getMembers()) {
                        L2PcInstance player;
                        if (member == null || (player = member.getPlayerInstance()) == null || !player.isNoble()) continue;
                        Hero.getInstance().setCastleTaken(player.getObjectId(), this.getCastle().getCastleId());
                    }
                }
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_S1_DRAW);
                sm.addFortId(this.getCastle().getCastleId());
                Announcements.getInstance().announceToAll(sm);
            }
            this.getCastle().updateClansReputation();
            this.removeFlags();
            this.teleportPlayer(TeleportWhoType.Attacker, MapRegionTable.TeleportWhereType.Town);
            this.teleportPlayer(TeleportWhoType.DefenderNotOwner, MapRegionTable.TeleportWhereType.Town);
            this.teleportPlayer(TeleportWhoType.Spectator, MapRegionTable.TeleportWhereType.Town);
            this._isInProgress = false;
            this.updatePlayerSiegeStateFlags(true);
            this.saveCastleSiege();
            this.clearSiegeClan();
            this.removeControlTower();
            this.removeFlameTower();
            this._siegeGuardManager.unspawnSiegeGuard();
            if (this.getCastle().getOwnerId() > 0) {
                this._siegeGuardManager.removeMercs();
            }
            this.getCastle().spawnDoor();
            this.getCastle().getZone().setIsActive(false);
            this.getCastle().getZone().updateZoneStatusForCharactersInside();
            this.getCastle().getZone().setSiegeInstance(null);
        }
    }

    private void removeDefender(L2SiegeClan sc) {
        if (sc != null) {
            this.getDefenderClans().remove(sc);
        }
    }

    private void removeAttacker(L2SiegeClan sc) {
        if (sc != null) {
            this.getAttackerClans().remove(sc);
        }
    }

    private void addDefender(L2SiegeClan sc, L2SiegeClan.SiegeClanType type) {
        if (sc == null) {
            return;
        }
        sc.setType(type);
        this.getDefenderClans().add(sc);
    }

    private void addAttacker(L2SiegeClan sc) {
        if (sc == null) {
            return;
        }
        sc.setType(L2SiegeClan.SiegeClanType.ATTACKER);
        this.getAttackerClans().add(sc);
    }

    public void midVictory() {
        if (this.getIsInProgress()) {
            if (this.getCastle().getOwnerId() > 0) {
                this._siegeGuardManager.removeMercs();
            }
            if (this.getDefenderClans().isEmpty() && this.getAttackerClans().size() == 1) {
                L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                this.removeAttacker(sc_newowner);
                this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                this.endSiege();
                return;
            }
            if (this.getCastle().getOwnerId() > 0) {
                int allyId = ClanTable.getInstance().getClan(this.getCastle().getOwnerId()).getAllyId();
                if (this.getDefenderClans().isEmpty() && allyId != 0) {
                    boolean allinsamealliance = true;
                    for (L2SiegeClan sc : this.getAttackerClans()) {
                        if (sc == null || ClanTable.getInstance().getClan(sc.getClanId()).getAllyId() == allyId) continue;
                        allinsamealliance = false;
                    }
                    if (allinsamealliance) {
                        L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                        this.removeAttacker(sc_newowner);
                        this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                        this.endSiege();
                        return;
                    }
                }
                for (L2SiegeClan sc : this.getDefenderClans()) {
                    if (sc == null) continue;
                    this.removeDefender(sc);
                    this.addAttacker(sc);
                }
                L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                this.removeAttacker(sc_newowner);
                this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                if (allyId != 0) {
                    L2Clan[] clanList;
                    for (L2Clan clan : clanList = ClanTable.getInstance().getClans()) {
                        L2SiegeClan sc;
                        if (clan.getAllyId() != allyId || (sc = this.getAttackerClan(clan.getClanId())) == null) continue;
                        this.removeAttacker(sc);
                        this.addDefender(sc, L2SiegeClan.SiegeClanType.DEFENDER);
                    }
                }
                this.teleportPlayer(TeleportWhoType.Attacker, MapRegionTable.TeleportWhereType.SiegeFlag);
                this.teleportPlayer(TeleportWhoType.Spectator, MapRegionTable.TeleportWhereType.Town);
                this.removeDefenderFlags();
                this.getCastle().removeUpgrade();
                this.getCastle().spawnDoor(true);
                this.removeControlTower();
                this.removeFlameTower();
                this._controlTowerCount = 0;
                this._controlTowerMaxCount = 0;
                this._flameTowerCount = 0;
                this._flameTowerMaxCount = 0;
                this.spawnControlTower(this.getCastle().getCastleId());
                this.spawnFlameTower(this.getCastle().getCastleId());
                this.updatePlayerSiegeStateFlags(false);
            }
        }
    }

    @Override
    public void startSiege() {
        if (!this.getIsInProgress()) {
            this._firstOwnerClanId = this.getCastle().getOwnerId();
            if (this.getAttackerClans().isEmpty()) {
                SystemMessage sm = this.getCastle().getOwnerId() <= 0 ? SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST) : SystemMessage.getSystemMessage(SystemMessageId.S1_SIEGE_WAS_CANCELED_BECAUSE_NO_CLANS_PARTICIPATED);
                sm.addFortId(this.getCastle().getCastleId());
                Announcements.getInstance().announceToAll(sm);
                this.saveCastleSiege();
                return;
            }
            this._isNormalSide = true;
            this._isInProgress = true;
            this.loadSiegeClan();
            this.updatePlayerSiegeStateFlags(false);
            this.teleportPlayer(TeleportWhoType.Attacker, MapRegionTable.TeleportWhereType.Town);
            this._controlTowerCount = 0;
            this._controlTowerMaxCount = 0;
            this.spawnControlTower(this.getCastle().getCastleId());
            this.spawnFlameTower(this.getCastle().getCastleId());
            this.getCastle().spawnDoor();
            this.spawnSiegeGuard();
            MercTicketManager.getInstance().deleteTickets(this.getCastle().getCastleId());
            this.getCastle().getZone().setSiegeInstance(this);
            this.getCastle().getZone().setIsActive(true);
            this.getCastle().getZone().updateZoneStatusForCharactersInside();
            this._siegeEndDate = Calendar.getInstance();
            this._siegeEndDate.add(12, SiegeManager.getInstance().getSiegeLength());
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this.getCastle()), 1000L);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_STARTED);
            sm.addFortId(this.getCastle().getCastleId());
            Announcements.getInstance().announceToAll(sm);
        }
    }

    public void announceToPlayer(SystemMessage message, boolean bothSides) {
        L2Clan clan;
        for (L2SiegeClan siegeClans : this.getDefenderClans()) {
            clan = ClanTable.getInstance().getClan(siegeClans.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(message);
            }
        }
        if (bothSides) {
            for (L2SiegeClan siegeClans : this.getAttackerClans()) {
                clan = ClanTable.getInstance().getClan(siegeClans.getClanId());
                for (L2PcInstance member : clan.getOnlineMembers(0)) {
                    if (member == null) continue;
                    member.sendPacket(message);
                }
            }
        }
    }

    public void updatePlayerSiegeStateFlags(boolean clear) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            if (siegeclan == null) continue;
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)1);
                    member.setSiegeSide(this.getCastle().getCastleId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.CASTLE_ZONE_FAME_TASK_FREQUENCY * 1000, Config.CASTLE_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.sendPacket(new UserInfo(member));
                member.sendPacket(new ExBrExtraUserInfo(member));
                for (L2PcInstance player : member.getKnownList().getKnownPlayers().values()) {
                    if (player == null) continue;
                    player.sendPacket(new RelationChanged(member, member.getRelation(player), member.isAutoAttackable(player)));
                    if (member.getPet() == null) continue;
                    player.sendPacket(new RelationChanged(member.getPet(), member.getRelation(player), member.isAutoAttackable(player)));
                }
            }
        }
        for (L2SiegeClan siegeclan : this.getDefenderClans()) {
            if (siegeclan == null) continue;
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)2);
                    member.setSiegeSide(this.getCastle().getCastleId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.CASTLE_ZONE_FAME_TASK_FREQUENCY * 1000, Config.CASTLE_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.sendPacket(new UserInfo(member));
                member.sendPacket(new ExBrExtraUserInfo(member));
                for (L2PcInstance player : member.getKnownList().getKnownPlayers().values()) {
                    if (player == null) continue;
                    player.sendPacket(new RelationChanged(member, member.getRelation(player), member.isAutoAttackable(player)));
                    if (member.getPet() == null) continue;
                    player.sendPacket(new RelationChanged(member.getPet(), member.getRelation(player), member.isAutoAttackable(player)));
                }
            }
        }
    }

    public void approveSiegeDefenderClan(int clanId) {
        if (clanId <= 0) {
            return;
        }
        this.saveSiegeClan(ClanTable.getInstance().getClan(clanId), (byte)0, true);
        this.loadSiegeClan();
    }

    public boolean checkIfInZone(L2Object object) {
        return this.checkIfInZone(object.getX(), object.getY(), object.getZ());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getIsInProgress() && this.getCastle().checkIfInZone(x, y, z);
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        return this.getAttackerClan(clan) != null;
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return this.getDefenderClan(clan) != null;
    }

    public boolean checkIsDefenderWaiting(L2Clan clan) {
        return this.getDefenderWaitingClan(clan) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSiegeClan() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=?");
            statement.setInt(1, this.getCastle().getCastleId());
            statement.execute();
            statement.close();
            if (this.getCastle().getOwnerId() > 0) {
                statement = con.prepareStatement("DELETE FROM siege_clans WHERE clan_id=?");
                statement.setInt(1, this.getCastle().getOwnerId());
                statement.execute();
            }
            this.getAttackerClans().clear();
            this.getDefenderClans().clear();
            this.getDefenderWaitingClans().clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeClan(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSiegeWaitingClan() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=? and type = 2");
            statement.setInt(1, this.getCastle().getCastleId());
            statement.execute();
            this.getDefenderWaitingClans().clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeWaitingClan(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        FastList players = new FastList();
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getDefendersButNotOwnersInZone() {
        FastList players = new FastList();
        for (L2SiegeClan siegeclan : this.getDefenderClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            if (clan.getClanId() == this.getCastle().getOwnerId()) continue;
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getPlayersInZone() {
        return this.getCastle().getZone().getAllPlayers();
    }

    public List<L2PcInstance> getOwnersInZone() {
        FastList players = new FastList();
        for (L2SiegeClan siegeclan : this.getDefenderClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            if (clan.getClanId() != this.getCastle().getOwnerId()) continue;
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getSpectatorsInZone() {
        FastList players = new FastList();
        for (L2PcInstance player : this.getCastle().getZone().getAllPlayers()) {
            if (player == null || player.isInSiege()) continue;
            players.add(player);
        }
        return players;
    }

    public void killedCT(L2Npc ct) {
        --this._controlTowerCount;
        if (this._controlTowerCount < 0) {
            this._controlTowerCount = 0;
        }
    }

    public void killedFlag(L2Npc flag) {
        if (flag == null) {
            return;
        }
        for (L2SiegeClan clan : this.getAttackerClans()) {
            if (!clan.removeFlag(flag)) continue;
            return;
        }
    }

    public void listRegisterClan(L2PcInstance player) {
        player.sendPacket(new SiegeInfo(this.getCastle()));
    }

    public void registerAttacker(L2PcInstance player) {
        this.registerAttacker(player, false);
    }

    public void registerAttacker(L2PcInstance player, boolean force) {
        if (player.getClan() == null) {
            return;
        }
        int allyId = 0;
        if (this.getCastle().getOwnerId() != 0) {
            allyId = ClanTable.getInstance().getClan(this.getCastle().getOwnerId()).getAllyId();
        }
        if (allyId != 0 && player.getClan().getAllyId() == allyId && !force) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_ATTACK_ALLIANCE_CASTLE));
            return;
        }
        if (force || this.checkIfCanRegister(player, (byte)1)) {
            this.saveSiegeClan(player.getClan(), (byte)1, false);
        }
    }

    public void registerDefender(L2PcInstance player) {
        this.registerDefender(player, false);
    }

    public void registerDefender(L2PcInstance player, boolean force) {
        if (this.getCastle().getOwnerId() <= 0) {
            player.sendMessage(this.getCastle().getCastleName() + "\u306fNPC\u304c\u6240\u6709\u3057\u3066\u3044\u308b\u306e\u3067\u5b88\u5099\u5074\u306b\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
        } else if (force || this.checkIfCanRegister(player, (byte)2)) {
            this.saveSiegeClan(player.getClan(), (byte)2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSiegeClan(int clanId) {
        if (clanId <= 0) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=? and clan_id=?");
            statement.setInt(1, this.getCastle().getCastleId());
            statement.setInt(2, clanId);
            statement.execute();
            this.loadSiegeClan();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeSiegeClan(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void removeSiegeClan(L2Clan clan) {
        if (clan == null || clan.getHasCastle() == this.getCastle().getCastleId() || !SiegeManager.getInstance().checkIsRegistered(clan, this.getCastle().getCastleId())) {
            return;
        }
        this.removeSiegeClan(clan.getClanId());
    }

    public void removeSiegeClan(L2PcInstance player) {
        this.removeSiegeClan(player.getClan());
    }

    public void startAutoTask() {
        this.correctSiegeDateTime();
        _log.info("Siege of " + this.getCastle().getCastleName() + ": " + Util.dateFormat(this.getCastle().getSiegeDate()));
        this.loadSiegeClan();
        if (this._scheduledStartSiegeTask != null) {
            this._scheduledStartSiegeTask.cancel(false);
        }
        this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this.getCastle()), 1000L);
    }

    public void teleportPlayer(TeleportWhoType teleportWho, MapRegionTable.TeleportWhereType teleportWhere) {
        List<L2PcInstance> players;
        switch (teleportWho) {
            case Owner: {
                players = this.getOwnersInZone();
                break;
            }
            case Attacker: {
                players = this.getAttackersInZone();
                break;
            }
            case DefenderNotOwner: {
                players = this.getDefendersButNotOwnersInZone();
                break;
            }
            case Spectator: {
                players = this.getSpectatorsInZone();
                break;
            }
            default: {
                players = this.getPlayersInZone();
            }
        }
        for (L2PcInstance player : players) {
            if (player.isGM() || player.isInJail()) continue;
            player.teleToLocation(teleportWhere);
        }
    }

    private void addAttacker(int clanId) {
        this.getAttackerClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.ATTACKER));
    }

    private void addDefender(int clanId) {
        this.getDefenderClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.DEFENDER));
    }

    private void addDefender(int clanId, L2SiegeClan.SiegeClanType type) {
        this.getDefenderClans().add(new L2SiegeClan(clanId, type));
    }

    private void addDefenderWaiting(int clanId) {
        this.getDefenderWaitingClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.DEFENDER_PENDING));
    }

    private boolean checkIfCanRegister(L2PcInstance player, byte typeId) {
        if (this.getIsRegistrationOver()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEADLINE_FOR_SIEGE_S1_PASSED);
            sm.addFortId(this.getCastle().getCastleId());
            player.sendPacket(sm);
        } else if (this.getIsInProgress()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_SIEGE_REGISTRATION_TIME2));
        } else if (player.getClan() == null || player.getClan().getLevel() < SiegeManager.getInstance().getSiegeClanMinLevel()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_CLAN_LEVEL_5_ABOVE_MAY_SIEGE));
        } else if (player.getClan().getHasCastle() > 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE));
        } else if (player.getClan().getClanId() == this.getCastle().getOwnerId()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING));
        } else if (SiegeManager.getInstance().checkIsRegistered(player.getClan(), this.getCastle().getCastleId())) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE));
        } else if (this.checkIfAlreadyRegisteredForSameDay(player.getClan())) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE));
        } else if (typeId == 1 && this.getAttackerClans().size() >= SiegeManager.getInstance().getAttackerMaxClans()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ATTACKER_SIDE_FULL));
        } else if ((typeId == 0 || typeId == 2 || typeId == -1) && this.getDefenderClans().size() + this.getDefenderWaitingClans().size() >= SiegeManager.getInstance().getDefenderMaxClans()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DEFENDER_SIDE_FULL));
        } else {
            return true;
        }
        return false;
    }

    public boolean checkIfAlreadyRegisteredForSameDay(L2Clan clan) {
        for (Siege siege : SiegeManager.getInstance().getSieges()) {
            if (siege == this || siege.getSiegeDate().get(7) != this.getSiegeDate().get(7)) continue;
            if (siege.checkIsAttacker(clan)) {
                return true;
            }
            if (siege.checkIsDefender(clan)) {
                return true;
            }
            if (!siege.checkIsDefenderWaiting(clan)) continue;
            return true;
        }
        return false;
    }

    public void correctSiegeDateTime() {
        boolean corrected = false;
        if (this.getCastle().getSiegeDate().getTimeInMillis() < Calendar.getInstance().getTimeInMillis()) {
            corrected = true;
            this.setNextSiegeDate();
        }
        if (!SevenSigns.getInstance().isDateInSealValidPeriod(this.getCastle().getSiegeDate())) {
            corrected = true;
            this.setNextSiegeDate();
        }
        if (corrected) {
            this.saveSiegeDate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSiegeClan() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            this.getAttackerClans().clear();
            this.getDefenderClans().clear();
            this.getDefenderWaitingClans().clear();
            if (this.getCastle().getOwnerId() > 0) {
                this.addDefender(this.getCastle().getOwnerId(), L2SiegeClan.SiegeClanType.OWNER);
            }
            ResultSet rs = null;
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT clan_id,type FROM siege_clans where castle_id=?");
            statement.setInt(1, this.getCastle().getCastleId());
            rs = statement.executeQuery();
            while (rs.next()) {
                int typeId = rs.getInt("type");
                if (typeId == 0) {
                    this.addDefender(rs.getInt("clan_id"));
                    continue;
                }
                if (typeId == 1) {
                    this.addAttacker(rs.getInt("clan_id"));
                    continue;
                }
                if (typeId != 2) continue;
                this.addDefenderWaiting(rs.getInt("clan_id"));
            }
        }
        catch (Exception e) {
            try {
                _log.log(Level.WARNING, "Exception: loadSiegeClan(): " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                L2DatabaseFactory.close(con);
                throw throwable;
            }
            L2DatabaseFactory.close(con);
        }
        L2DatabaseFactory.close(con);
    }

    private void removeControlTower() {
        if (this._controlTowers != null && !this._controlTowers.isEmpty()) {
            for (L2ControlTowerInstance ct : this._controlTowers) {
                if (ct == null) continue;
                try {
                    ct.deleteMe();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception: removeControlTower(): " + e.getMessage(), e);
                }
            }
            this._controlTowers.clear();
            this._controlTowers = null;
        }
    }

    private void removeFlameTower() {
        if (this._flameTowers != null && !this._flameTowers.isEmpty()) {
            for (L2FlameTowerInstance ct : this._flameTowers) {
                if (ct == null) continue;
                try {
                    ct.deleteMe();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception: removeFlamelTower(): " + e.getMessage(), e);
                }
            }
            this._flameTowers.clear();
            this._flameTowers = null;
        }
    }

    private void removeFlags() {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void removeDefenderFlags() {
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void saveCastleSiege() {
        this.setNextSiegeDate();
        this.getTimeRegistrationOverDate().setTimeInMillis(Calendar.getInstance().getTimeInMillis());
        this.getTimeRegistrationOverDate().add(5, 1);
        this.getCastle().setIsTimeRegistrationOver(false);
        this.saveSiegeDate();
        this.startAutoTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSiegeDate() {
        if (this._scheduledStartSiegeTask != null) {
            this._scheduledStartSiegeTask.cancel(true);
            this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this.getCastle()), 1000L);
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE castle SET siegeDate = ?, regTimeEnd = ?, regTimeOver = ?  WHERE id = ?");
            statement.setLong(1, this.getSiegeDate().getTimeInMillis());
            statement.setLong(2, this.getTimeRegistrationOverDate().getTimeInMillis());
            statement.setString(3, String.valueOf(this.getIsTimeRegistrationOver()));
            statement.setInt(4, this.getCastle().getCastleId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeDate(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveSiegeClan(L2Clan clan, byte typeId, boolean isUpdateRegistration) {
        block14: {
            block13: {
                block12: {
                    if (clan.getHasCastle() > 0) {
                        return;
                    }
                    con = null;
                    statement = null;
                    if (typeId != 0 && typeId != 2 && typeId != -1) break block12;
                    ** if (this.getDefenderClans().size() + this.getDefenderWaitingClans().size() < SiegeManager.getInstance().getDefenderMaxClans()) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        L2DatabaseFactory.close(con);
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block13;
                    }
                }
                if (this.getAttackerClans().size() < SiegeManager.getInstance().getAttackerMaxClans()) break block13;
                L2DatabaseFactory.close(con);
                return;
            }
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                if (!isUpdateRegistration) {
                    statement = con.prepareStatement("INSERT INTO siege_clans (clan_id,castle_id,type,castle_owner) values (?,?,?,0)");
                    statement.setInt(1, clan.getClanId());
                    statement.setInt(2, this.getCastle().getCastleId());
                    statement.setInt(3, typeId);
                    statement.execute();
                } else {
                    statement = con.prepareStatement("UPDATE siege_clans SET type = ? WHERE castle_id = ? AND clan_id = ?");
                    statement.setInt(1, typeId);
                    statement.setInt(2, this.getCastle().getCastleId());
                    statement.setInt(3, clan.getClanId());
                    statement.execute();
                }
                if (typeId == 0 || typeId == -1) {
                    this.addDefender(clan.getClanId());
                    break block14;
                }
                if (typeId == 1) {
                    this.addAttacker(clan.getClanId());
                    break block14;
                }
                if (typeId != 2) break block14;
                this.addDefenderWaiting(clan.getClanId());
            }
            catch (Exception e) {
                try {
                    Siege._log.log(Level.WARNING, "Exception: saveSiegeClan(L2Clan clan, int typeId, boolean isUpdateRegistration): " + e.getMessage(), e);
                }
                catch (Throwable var7_7) {
                    L2DatabaseFactory.close(con);
                    throw var7_7;
                }
                L2DatabaseFactory.close(con);
            }
        }
        L2DatabaseFactory.close(con);
    }

    private void setNextSiegeDate() {
        while (this.getCastle().getSiegeDate().getTimeInMillis() < Calendar.getInstance().getTimeInMillis()) {
            if (this.getCastle().getSiegeDate().get(7) != 7 && this.getCastle().getSiegeDate().get(7) != 1) {
                this.getCastle().getSiegeDate().set(7, 7);
            }
            if (this.getCastle().getSiegeDate().get(7) == 7 && !Config.CL_SET_SIEGE_TIME_LIST.contains("day")) {
                this.getCastle().getSiegeDate().set(7, 1);
            }
            this.getCastle().getSiegeDate().add(5, 7);
        }
        if (!SevenSigns.getInstance().isDateInSealValidPeriod(this.getCastle().getSiegeDate())) {
            this.getCastle().getSiegeDate().add(5, 7);
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ANNOUNCED_SIEGE_TIME);
        sm.addFortId(this.getCastle().getCastleId());
        Announcements.getInstance().announceToAll(sm);
        this._isRegistrationOver = false;
    }

    private void spawnControlTower(int Id) {
        if (this._controlTowers == null) {
            this._controlTowers = new FastList();
        }
        for (SiegeManager.SiegeSpawn _sp : SiegeManager.getInstance().getControlTowerSpawnList(Id)) {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(_sp.getNpcId());
            L2ControlTowerInstance ct = new L2ControlTowerInstance(IdFactory.getInstance().getNextId(), template);
            ct.setCurrentHpMp(_sp.getHp(), ct.getMaxMp());
            ct.spawnMe(_sp.getLocation().getX(), _sp.getLocation().getY(), _sp.getLocation().getZ() + 20);
            ++this._controlTowerCount;
            ++this._controlTowerMaxCount;
            this._controlTowers.add(ct);
        }
    }

    private void spawnFlameTower(int Id) {
        if (this._flameTowers == null) {
            this._flameTowers = new FastList();
        }
        for (SiegeManager.SiegeSpawn _sp : SiegeManager.getInstance().getFlameTowerSpawnList(Id)) {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(_sp.getNpcId());
            L2FlameTowerInstance ct = new L2FlameTowerInstance(IdFactory.getInstance().getNextId(), template);
            ct.setCurrentHpMp(_sp.getHp(), ct.getMaxMp());
            ct.spawnMe(_sp.getLocation().getX(), _sp.getLocation().getY(), _sp.getLocation().getZ() + 20);
            ++this._flameTowerCount;
            ++this._flameTowerMaxCount;
            this._flameTowers.add(ct);
        }
        if (this._flameTowerCount == 0) {
            this._flameTowerCount = 1;
        }
    }

    private void spawnSiegeGuard() {
        this.getSiegeGuardManager().spawnSiegeGuard();
        if (!this.getSiegeGuardManager().getSiegeGuardSpawn().isEmpty() && !this._controlTowers.isEmpty()) {
            double distanceClosest = 0.0;
            for (L2Spawn spawn : this.getSiegeGuardManager().getSiegeGuardSpawn()) {
                if (spawn == null) continue;
                L2ControlTowerInstance closestCt = null;
                distanceClosest = 2.147483647E9;
                int x = spawn.getLocx();
                int y = spawn.getLocy();
                int z = spawn.getLocz();
                for (L2ControlTowerInstance ct : this._controlTowers) {
                    double distance;
                    if (ct == null || !((distance = ct.getDistanceSq(x, y, z)) < distanceClosest)) continue;
                    closestCt = ct;
                    distanceClosest = distance;
                }
                if (closestCt == null) continue;
                closestCt.registerGuard(spawn);
            }
        }
    }

    @Override
    public final L2SiegeClan getAttackerClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getAttackerClan(clan.getClanId());
    }

    @Override
    public final L2SiegeClan getAttackerClan(int clanId) {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getAttackerClans() {
        if (this._isNormalSide) {
            return this._attackerClans;
        }
        return this._defenderClans;
    }

    public final int getAttackerRespawnDelay() {
        return SiegeManager.getInstance().getAttackerRespawnDelay();
    }

    public final Castle getCastle() {
        if (this._castle == null || this._castle.length <= 0) {
            return null;
        }
        return this._castle[0];
    }

    @Override
    public final L2SiegeClan getDefenderClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getDefenderClan(clan.getClanId());
    }

    @Override
    public final L2SiegeClan getDefenderClan(int clanId) {
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getDefenderClans() {
        if (this._isNormalSide) {
            return this._defenderClans;
        }
        return this._attackerClans;
    }

    public final L2SiegeClan getDefenderWaitingClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getDefenderWaitingClan(clan.getClanId());
    }

    public final L2SiegeClan getDefenderWaitingClan(int clanId) {
        for (L2SiegeClan sc : this.getDefenderWaitingClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    public final List<L2SiegeClan> getDefenderWaitingClans() {
        return this._defenderWaitingClans;
    }

    public final boolean getIsInProgress() {
        return this._isInProgress;
    }

    public final boolean getIsRegistrationOver() {
        return this._isRegistrationOver;
    }

    public final boolean getIsTimeRegistrationOver() {
        return this.getCastle().getIsTimeRegistrationOver();
    }

    @Override
    public final Calendar getSiegeDate() {
        return this.getCastle().getSiegeDate();
    }

    public final Calendar getTimeRegistrationOverDate() {
        return this.getCastle().getTimeRegistrationOverDate();
    }

    public void endTimeRegistration(boolean automatic) {
        this.getCastle().setIsTimeRegistrationOver(true);
        if (!automatic) {
            this.saveSiegeDate();
        }
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        L2SiegeClan sc;
        if (clan != null && (sc = this.getAttackerClan(clan)) != null) {
            return sc.getFlag();
        }
        return null;
    }

    public final SiegeGuardManager getSiegeGuardManager() {
        if (this._siegeGuardManager == null) {
            this._siegeGuardManager = new SiegeGuardManager(this.getCastle());
        }
        return this._siegeGuardManager;
    }

    public int getControlTowerCount() {
        return this._controlTowerCount;
    }

    public void disableTraps() {
        --this._flameTowerCount;
    }

    public boolean isTrapsActive() {
        return this._flameTowerCount > 0;
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return Config.CASTLE_ZONE_FAME_TASK_FREQUENCY;
    }

    @Override
    public int getFameAmount() {
        return Config.CASTLE_ZONE_FAME_AQUIRE_POINTS;
    }

    public class ScheduleStartSiegeTask
    implements Runnable {
        private Castle _castleInst;

        public ScheduleStartSiegeTask(Castle pCastle) {
            this._castleInst = pCastle;
        }

        @Override
        public void run() {
            Siege.this._scheduledStartSiegeTask.cancel(false);
            if (Siege.this.getIsInProgress()) {
                return;
            }
            try {
                long timeRemaining;
                if (!Siege.this.getIsTimeRegistrationOver()) {
                    long regTimeRemaining = Siege.this.getTimeRegistrationOverDate().getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
                    if (regTimeRemaining > 0L) {
                        Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), regTimeRemaining);
                        return;
                    }
                    Siege.this.endTimeRegistration(true);
                }
                if ((timeRemaining = Siege.this.getSiegeDate().getTimeInMillis() - Calendar.getInstance().getTimeInMillis()) > 86400000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 86400000L);
                } else if (timeRemaining <= 86400000L && timeRemaining > 13600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REGISTRATION_TERM_FOR_S1_ENDED);
                    sm.addFortId(Siege.this.getCastle().getCastleId());
                    Announcements.getInstance().announceToAll(sm);
                    Siege.this._isRegistrationOver = true;
                    Siege.this.clearSiegeWaitingClan();
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 13600000L);
                } else if (timeRemaining <= 13600000L && timeRemaining > 600000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 10000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 10000L);
                } else if (timeRemaining <= 10000L && timeRemaining > 0L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining);
                } else {
                    this._castleInst.getSiege().startSiege();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class ScheduleEndSiegeTask
    implements Runnable {
        private Castle _castleInst;

        public ScheduleEndSiegeTask(Castle pCastle) {
            this._castleInst = pCastle;
        }

        @Override
        public void run() {
            if (!Siege.this.getIsInProgress()) {
                return;
            }
            try {
                long timeRemaining = Siege.this._siegeEndDate.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
                if (timeRemaining > 3600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HOURS_UNTIL_SIEGE_CONCLUSION);
                    sm.addNumber(2);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 3600000L);
                } else if (timeRemaining <= 3600000L && timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addNumber(Math.round(timeRemaining / 60000L));
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addNumber(Math.round(timeRemaining / 60000L));
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 10000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addNumber(Math.round(timeRemaining / 60000L));
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 10000L);
                } else if (timeRemaining <= 10000L && timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CASTLE_SIEGE_S1_SECONDS_LEFT);
                    sm.addNumber(Math.round(timeRemaining / 1000L));
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining);
                } else {
                    this._castleInst.getSiege().endSiege();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public static enum TeleportWhoType {
        All,
        Attacker,
        DefenderNotOwner,
        Owner,
        Spectator;

    }
}

