/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import javolution.util.FastList;

public class EffectConfusion
extends L2Effect {
    public EffectConfusion(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.CONFUSION;
    }

    @Override
    public boolean onStart() {
        this.getEffected().startConfused();
        this.onActionTime();
        return true;
    }

    @Override
    public void onExit() {
        this.getEffected().stopConfused(this);
    }

    @Override
    public boolean onActionTime() {
        FastList targetList = new FastList();
        Collection<L2Object> objs = this.getEffected().getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2Character) || obj == this.getEffected()) continue;
            targetList.add((L2Character)obj);
        }
        if (targetList.isEmpty()) {
            return true;
        }
        int nextTargetIdx = Rnd.nextInt(targetList.size());
        L2Object target = (L2Object)targetList.get(nextTargetIdx);
        this.getEffected().setTarget(target);
        this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        return true;
    }

    @Override
    public int getEffectFlags() {
        return 256;
    }
}

