/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.chars;

import com.l2jserver.gameserver.datatables.HerbDropTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class L2NpcTemplate
extends L2CharTemplate {
    protected static final Logger _log = Logger.getLogger(Quest.class.getName());
    public final int npcId;
    public final int idTemplate;
    public final String type;
    public final String name;
    public final boolean serverSideName;
    public final String title;
    public final boolean serverSideTitle;
    public final String sex;
    public final byte level;
    public final int rewardExp;
    public final int rewardSp;
    public final int aggroRange;
    public final int rhand;
    public final int lhand;
    public final int enchantEffect;
    public Race race;
    public final String jClass;
    public final int dropherbgroup;
    public boolean isQuestMonster;
    public final float baseVitalityDivider;
    public FastList<L2Skill> _buffskills;
    public FastList<L2Skill> _negativeskills;
    public FastList<L2Skill> _debuffskills;
    public FastList<L2Skill> _atkskills;
    public FastList<L2Skill> _rootskills;
    public FastList<L2Skill> _stunskills;
    public FastList<L2Skill> _sleepskills;
    public FastList<L2Skill> _paralyzeskills;
    public FastList<L2Skill> _fossilskills;
    public FastList<L2Skill> _floatskills;
    public FastList<L2Skill> _immobiliseskills;
    public FastList<L2Skill> _healskills;
    public FastList<L2Skill> _resskills;
    public FastList<L2Skill> _dotskills;
    public FastList<L2Skill> _cotskills;
    public FastList<L2Skill> _universalskills;
    public FastList<L2Skill> _manaskills;
    public FastList<L2Skill> _Lrangeskills;
    public FastList<L2Skill> _Srangeskills;
    public FastList<L2Skill> _generalskills;
    private boolean _hasbuffskills;
    private boolean _hasnegativeskills;
    private boolean _hasdebuffskills;
    private boolean _hasatkskills;
    private boolean _hasrootskills;
    private boolean _hasstunskills;
    private boolean _hassleepskills;
    private boolean _hasparalyzeskills;
    private boolean _hasfossilskills;
    private boolean _hasfloatskills;
    private boolean _hasimmobiliseskills;
    private boolean _hashealskills;
    private boolean _hasresskills;
    private boolean _hasdotskills;
    private boolean _hascotskills;
    private boolean _hasuniversalskills;
    private boolean _hasmanaskills;
    private boolean _hasLrangeskills;
    private boolean _hasSrangeskills;
    private boolean _hasgeneralskills;
    private L2NpcAIData _AIdataStatic = new L2NpcAIData();
    private FastList<L2DropCategory> _categories = null;
    private List<L2MinionData> _minions = null;
    private List<ClassId> _teachInfo;
    private Map<Integer, L2Skill> _skills;
    private Map<Quest.QuestEventType, Quest[]> _questEvents;

    public L2NpcTemplate(StatsSet set) {
        super(set);
        this.npcId = set.getInteger("npcId");
        this.idTemplate = set.getInteger("idTemplate");
        this.type = StringIntern.intern(set.getString("type"));
        this.name = StringIntern.intern(set.getString("name"));
        this.serverSideName = set.getBool("serverSideName");
        this.title = StringIntern.intern(set.getString("title"));
        this.isQuestMonster = this.title.equalsIgnoreCase("Quest Monster") || this.title.equals("\u30af\u30a8\u30b9\u30c8\u30e2\u30f3\u30b9\u30bf\u30fc");
        this.serverSideTitle = set.getBool("serverSideTitle");
        this.sex = StringIntern.intern(set.getString("sex"));
        this.level = set.getByte("level");
        this.rewardExp = set.getInteger("rewardExp");
        this.rewardSp = set.getInteger("rewardSp");
        this.aggroRange = set.getInteger("aggroRange");
        this.rhand = set.getInteger("rhand");
        this.lhand = set.getInteger("lhand");
        this.enchantEffect = set.getInteger("enchant");
        this.race = null;
        int herbGroup = set.getInteger("dropHerbGroup");
        if (herbGroup > 0 && HerbDropTable.getInstance().getHerbDroplist(herbGroup) == null) {
            _log.warning("Missing Herb Drop Group for npcId: " + this.npcId);
            this.dropherbgroup = 0;
        } else {
            this.dropherbgroup = herbGroup;
        }
        this._teachInfo = null;
        this.jClass = StringIntern.intern(set.getString("jClass"));
        this.baseVitalityDivider = this.level > 0 && this.rewardExp > 0 ? this.baseHpMax * 9.0f * (float)this.level * (float)this.level / (float)(100 * this.rewardExp) : 0.0f;
    }

    public void addTeachInfo(ClassId classId) {
        if (this._teachInfo == null) {
            this._teachInfo = new FastList();
        }
        this._teachInfo.add(classId);
    }

    public ClassId[] getTeachInfo() {
        if (this._teachInfo == null) {
            return null;
        }
        return this._teachInfo.toArray(new ClassId[this._teachInfo.size()]);
    }

    public boolean canTeach(ClassId classId) {
        if (this._teachInfo == null) {
            return false;
        }
        if (classId.level() == 3) {
            return this._teachInfo.contains((Object)classId.getParent());
        }
        return this._teachInfo.contains((Object)classId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDropData(L2DropData drop, int categoryType) {
        if (!drop.isQuestDrop()) {
            if (this._categories == null) {
                this._categories = new FastList();
            }
            FastList<L2DropCategory> fastList = this._categories;
            synchronized (fastList) {
                boolean catExists = false;
                for (L2DropCategory cat : this._categories) {
                    if (cat.getCategoryType() != categoryType) continue;
                    cat.addDropData(drop, this.type.equalsIgnoreCase("L2RaidBoss") || this.type.equalsIgnoreCase("L2GrandBoss"));
                    catExists = true;
                    break;
                }
                if (!catExists) {
                    L2DropCategory cat = new L2DropCategory(categoryType);
                    cat.addDropData(drop, this.type.equalsIgnoreCase("L2RaidBoss") || this.type.equalsIgnoreCase("L2GrandBoss"));
                    this._categories.add((Object)cat);
                }
            }
        }
    }

    public void addRaidData(L2MinionData minion) {
        if (this._minions == null) {
            this._minions = new FastList();
        }
        this._minions.add(minion);
    }

    public void addSkill(L2Skill skill) {
        if (this._skills == null) {
            this._skills = new FastMap();
        }
        if (!skill.isPassive()) {
            this.addGeneralSkill(skill);
            switch (skill.getSkillType()) {
                case BUFF: {
                    this.addBuffSkill(skill);
                    break;
                }
                case HEAL: 
                case HOT: 
                case HEAL_PERCENT: 
                case HEAL_STATIC: 
                case BALANCE_LIFE: {
                    this.addHealSkill(skill);
                    break;
                }
                case RESURRECT: {
                    this.addResSkill(skill);
                    break;
                }
                case DEBUFF: {
                    this.addDebuffSkill(skill);
                    this.addCOTSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case ROOT: {
                    this.addRootSkill(skill);
                    this.addImmobiliseSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case SLEEP: {
                    this.addSleepSkill(skill);
                    this.addImmobiliseSkill(skill);
                    break;
                }
                case STUN: {
                    this.addRootSkill(skill);
                    this.addImmobiliseSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case PARALYZE: {
                    this.addParalyzeSkill(skill);
                    this.addImmobiliseSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case PDAM: 
                case MDAM: 
                case BLOW: 
                case DRAIN: 
                case CHARGEDAM: 
                case FATAL: 
                case DEATHLINK: 
                case CPDAM: 
                case MANADAM: 
                case CPDAMPERCENT: {
                    this.addAtkSkill(skill);
                    this.addUniversalSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case POISON: 
                case DOT: 
                case MDOT: 
                case BLEED: {
                    this.addDOTSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case MUTE: 
                case FEAR: {
                    this.addCOTSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                case CANCEL: 
                case NEGATE: {
                    this.addNegativeSkill(skill);
                    this.addRangeSkill(skill);
                    break;
                }
                default: {
                    this.addUniversalSkill(skill);
                }
            }
        }
        this._skills.put(skill.getId(), skill);
    }

    public FastList<L2DropCategory> getDropData() {
        return this._categories;
    }

    public List<L2DropData> getAllDropData() {
        if (this._categories == null) {
            return null;
        }
        FastList lst = new FastList();
        for (L2DropCategory tmp : this._categories) {
            lst.addAll(tmp.getAllDrops());
        }
        return lst;
    }

    public synchronized void clearAllDropData() {
        if (this._categories == null) {
            return;
        }
        while (!this._categories.isEmpty()) {
            ((L2DropCategory)this._categories.getFirst()).clearAllDrops();
            this._categories.removeFirst();
        }
        this._categories.clear();
    }

    public List<L2MinionData> getMinionData() {
        return this._minions;
    }

    public Map<Integer, L2Skill> getSkills() {
        return this._skills;
    }

    public void addQuestEvent(Quest.QuestEventType EventType2, Quest q) {
        if (this._questEvents == null) {
            this._questEvents = new FastMap();
        }
        if (this._questEvents.get((Object)EventType2) == null) {
            this._questEvents.put(EventType2, new Quest[]{q});
        } else {
            Quest[] _quests = this._questEvents.get((Object)EventType2);
            int len = _quests.length;
            if (!EventType2.isMultipleRegistrationAllowed()) {
                if (_quests[0].getName().equals(q.getName()) || L2NpcTemplate.isAssignableTo(q, _quests[0].getClass())) {
                    _quests[0] = q;
                } else {
                    _log.warning("Quest event not allowed in multiple quests.  Skipped addition of Event Type \"" + (Object)((Object)EventType2) + "\" for NPC \"" + this.name + "\" and quest \"" + q.getName() + "\".");
                }
            } else {
                Quest[] tmp = new Quest[len + 1];
                for (int i = 0; i < len; ++i) {
                    if (_quests[i].getName().equals(q.getName()) || L2NpcTemplate.isAssignableTo(q, _quests[i].getClass())) {
                        _quests[i] = q;
                        return;
                    }
                    if (L2NpcTemplate.isAssignableTo(_quests[i], q.getClass())) {
                        return;
                    }
                    tmp[i] = _quests[i];
                }
                tmp[len] = q;
                this._questEvents.put(EventType2, tmp);
            }
        }
    }

    public static boolean isAssignableTo(Object obj, Class<?> clazz) {
        return L2NpcTemplate.isAssignableTo(obj.getClass(), clazz);
    }

    public static boolean isAssignableTo(Class<?> sub, Class<?> clazz) {
        if (clazz.isInterface()) {
            Class<?>[] interfaces = sub.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!clazz.getName().equals(interfaces[i].getName())) continue;
                return true;
            }
        } else {
            do {
                if (!sub.getName().equals(clazz.getName())) continue;
                return true;
            } while ((sub = sub.getSuperclass()) != null);
        }
        return false;
    }

    public Quest[] getEventQuests(Quest.QuestEventType EventType2) {
        if (this._questEvents == null) {
            return null;
        }
        return this._questEvents.get((Object)EventType2);
    }

    public void setRace(int raceId) {
        switch (raceId) {
            case 1: {
                this.race = Race.UNDEAD;
                break;
            }
            case 2: {
                this.race = Race.MAGICCREATURE;
                break;
            }
            case 3: {
                this.race = Race.BEAST;
                break;
            }
            case 4: {
                this.race = Race.ANIMAL;
                break;
            }
            case 5: {
                this.race = Race.PLANT;
                break;
            }
            case 6: {
                this.race = Race.HUMANOID;
                break;
            }
            case 7: {
                this.race = Race.SPIRIT;
                break;
            }
            case 8: {
                this.race = Race.ANGEL;
                break;
            }
            case 9: {
                this.race = Race.DEMON;
                break;
            }
            case 10: {
                this.race = Race.DRAGON;
                break;
            }
            case 11: {
                this.race = Race.GIANT;
                break;
            }
            case 12: {
                this.race = Race.BUG;
                break;
            }
            case 13: {
                this.race = Race.FAIRIE;
                break;
            }
            case 14: {
                this.race = Race.HUMAN;
                break;
            }
            case 15: {
                this.race = Race.ELVE;
                break;
            }
            case 16: {
                this.race = Race.DARKELVE;
                break;
            }
            case 17: {
                this.race = Race.ORC;
                break;
            }
            case 18: {
                this.race = Race.DWARVE;
                break;
            }
            case 19: {
                this.race = Race.OTHER;
                break;
            }
            case 20: {
                this.race = Race.NONLIVING;
                break;
            }
            case 21: {
                this.race = Race.SIEGEWEAPON;
                break;
            }
            case 22: {
                this.race = Race.DEFENDINGARMY;
                break;
            }
            case 23: {
                this.race = Race.MERCENARIE;
                break;
            }
            case 24: {
                this.race = Race.UNKNOWN;
                break;
            }
            case 25: {
                this.race = Race.KAMAEL;
                break;
            }
            default: {
                this.race = Race.NONE;
            }
        }
    }

    public void setAIData(L2NpcAIData aidata) {
        this._AIdataStatic = aidata;
    }

    public L2NpcAIData getAIDataStatic() {
        return this._AIdataStatic;
    }

    public void addBuffSkill(L2Skill skill) {
        if (this._buffskills == null) {
            this._buffskills = new FastList();
        }
        this._buffskills.add((Object)skill);
        this._hasbuffskills = true;
    }

    public void addHealSkill(L2Skill skill) {
        if (this._healskills == null) {
            this._healskills = new FastList();
        }
        this._healskills.add((Object)skill);
        this._hashealskills = true;
    }

    public void addResSkill(L2Skill skill) {
        if (this._resskills == null) {
            this._resskills = new FastList();
        }
        this._resskills.add((Object)skill);
        this._hasresskills = true;
    }

    public void addAtkSkill(L2Skill skill) {
        if (this._atkskills == null) {
            this._atkskills = new FastList();
        }
        this._atkskills.add((Object)skill);
        this._hasatkskills = true;
    }

    public void addDebuffSkill(L2Skill skill) {
        if (this._debuffskills == null) {
            this._debuffskills = new FastList();
        }
        this._debuffskills.add((Object)skill);
        this._hasdebuffskills = true;
    }

    public void addRootSkill(L2Skill skill) {
        if (this._rootskills == null) {
            this._rootskills = new FastList();
        }
        this._rootskills.add((Object)skill);
        this._hasrootskills = true;
    }

    public void addSleepSkill(L2Skill skill) {
        if (this._sleepskills == null) {
            this._sleepskills = new FastList();
        }
        this._sleepskills.add((Object)skill);
        this._hassleepskills = true;
    }

    public void addStunSkill(L2Skill skill) {
        if (this._stunskills == null) {
            this._stunskills = new FastList();
        }
        this._stunskills.add((Object)skill);
        this._hasstunskills = true;
    }

    public void addParalyzeSkill(L2Skill skill) {
        if (this._paralyzeskills == null) {
            this._paralyzeskills = new FastList();
        }
        this._paralyzeskills.add((Object)skill);
        this._hasparalyzeskills = true;
    }

    public void addFloatSkill(L2Skill skill) {
        if (this._floatskills == null) {
            this._floatskills = new FastList();
        }
        this._floatskills.add((Object)skill);
        this._hasfloatskills = true;
    }

    public void addFossilSkill(L2Skill skill) {
        if (this._fossilskills == null) {
            this._fossilskills = new FastList();
        }
        this._fossilskills.add((Object)skill);
        this._hasfossilskills = true;
    }

    public void addNegativeSkill(L2Skill skill) {
        if (this._negativeskills == null) {
            this._negativeskills = new FastList();
        }
        this._negativeskills.add((Object)skill);
        this._hasnegativeskills = true;
    }

    public void addImmobiliseSkill(L2Skill skill) {
        if (this._immobiliseskills == null) {
            this._immobiliseskills = new FastList();
        }
        this._immobiliseskills.add((Object)skill);
        this._hasimmobiliseskills = true;
    }

    public void addDOTSkill(L2Skill skill) {
        if (this._dotskills == null) {
            this._dotskills = new FastList();
        }
        this._dotskills.add((Object)skill);
        this._hasdotskills = true;
    }

    public void addUniversalSkill(L2Skill skill) {
        if (this._universalskills == null) {
            this._universalskills = new FastList();
        }
        this._universalskills.add((Object)skill);
        this._hasuniversalskills = true;
    }

    public void addCOTSkill(L2Skill skill) {
        if (this._cotskills == null) {
            this._cotskills = new FastList();
        }
        this._cotskills.add((Object)skill);
        this._hascotskills = true;
    }

    public void addManaHealSkill(L2Skill skill) {
        if (this._manaskills == null) {
            this._manaskills = new FastList();
        }
        this._manaskills.add((Object)skill);
        this._hasmanaskills = true;
    }

    public void addGeneralSkill(L2Skill skill) {
        if (this._generalskills == null) {
            this._generalskills = new FastList();
        }
        this._generalskills.add((Object)skill);
        this._hasgeneralskills = true;
    }

    public void addRangeSkill(L2Skill skill) {
        if (skill.getCastRange() <= 150 && skill.getCastRange() > 0) {
            if (this._Srangeskills == null) {
                this._Srangeskills = new FastList();
            }
            this._Srangeskills.add((Object)skill);
            this._hasSrangeskills = true;
        } else if (skill.getCastRange() > 150) {
            if (this._Lrangeskills == null) {
                this._Lrangeskills = new FastList();
            }
            this._Lrangeskills.add((Object)skill);
            this._hasLrangeskills = true;
        }
    }

    public boolean hasBuffSkill() {
        return this._hasbuffskills;
    }

    public boolean hasHealSkill() {
        return this._hashealskills;
    }

    public boolean hasResSkill() {
        return this._hasresskills;
    }

    public boolean hasAtkSkill() {
        return this._hasatkskills;
    }

    public boolean hasDebuffSkill() {
        return this._hasdebuffskills;
    }

    public boolean hasRootSkill() {
        return this._hasrootskills;
    }

    public boolean hasSleepSkill() {
        return this._hassleepskills;
    }

    public boolean hasStunSkill() {
        return this._hasstunskills;
    }

    public boolean hasParalyzeSkill() {
        return this._hasparalyzeskills;
    }

    public boolean hasFloatSkill() {
        return this._hasfloatskills;
    }

    public boolean hasFossilSkill() {
        return this._hasfossilskills;
    }

    public boolean hasNegativeSkill() {
        return this._hasnegativeskills;
    }

    public boolean hasImmobiliseSkill() {
        return this._hasimmobiliseskills;
    }

    public boolean hasDOTSkill() {
        return this._hasdotskills;
    }

    public boolean hasUniversalSkill() {
        return this._hasuniversalskills;
    }

    public boolean hasCOTSkill() {
        return this._hascotskills;
    }

    public boolean hasManaHealSkill() {
        return this._hasmanaskills;
    }

    public boolean hasAutoLrangeSkill() {
        return this._hasLrangeskills;
    }

    public boolean hasAutoSrangeSkill() {
        return this._hasSrangeskills;
    }

    public boolean hasSkill() {
        return this._hasgeneralskills;
    }

    public Race getRace() {
        if (this.race == null) {
            this.race = Race.NONE;
        }
        return this.race;
    }

    public boolean isCustom() {
        return this.npcId != this.idTemplate;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSpecialTree() {
        return this.npcId == 13007;
    }

    public boolean isUndead() {
        return this.race == Race.UNDEAD;
    }

    public static enum Race {
        UNDEAD,
        MAGICCREATURE,
        BEAST,
        ANIMAL,
        PLANT,
        HUMANOID,
        SPIRIT,
        ANGEL,
        DEMON,
        DRAGON,
        GIANT,
        BUG,
        FAIRIE,
        HUMAN,
        ELVE,
        DARKELVE,
        ORC,
        DWARVE,
        OTHER,
        NONLIVING,
        SIEGEWEAPON,
        DEFENDINGARMY,
        MERCENARIE,
        UNKNOWN,
        KAMAEL,
        NONE;

    }

    public static enum AIType {
        FIGHTER,
        ARCHER,
        BALANCED,
        MAGE,
        HEALER,
        CORPSE;

    }
}

