/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.communitybbs.Manager.ForumsBBSManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class ClanTable {
    private static Logger _log = Logger.getLogger(ClanTable.class.getName());
    private Map<Integer, L2Clan> _clans;

    public static ClanTable getInstance() {
        return SingletonHolder._instance;
    }

    public L2Clan[] getClans() {
        return this._clans.values().toArray(new L2Clan[this._clans.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClanTable() {
        if (Config.COMMUNITY_TYPE > 0) {
            ForumsBBSManager.getInstance().initRoot();
        }
        this._clans = new FastMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan_id FROM clan_data");
            ResultSet result = statement.executeQuery();
            int clanCount = 0;
            while (result.next()) {
                int clanId = result.getInt("clan_id");
                this._clans.put(clanId, new L2Clan(clanId));
                L2Clan clan = this.getClan(clanId);
                if (clan.getDissolvingExpiryTime() != 0L) {
                    this.scheduleRemoveClan(clan.getClanId());
                }
                ++clanCount;
            }
            result.close();
            statement.close();
            _log.info("Restored " + clanCount + " clans from the database.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring ClanTable.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.allianceCheck();
        this.restorewars();
    }

    public L2Clan getClan(int clanId) {
        L2Clan clan = this._clans.get(clanId);
        return clan;
    }

    public L2Clan getClanByName(String clanName) {
        for (L2Clan clan : this._clans.values()) {
            if (!clan.getName().equalsIgnoreCase(clanName)) continue;
            return clan;
        }
        return null;
    }

    public L2Clan createClan(L2PcInstance player, String clanName) {
        if (null == player) {
            return null;
        }
        if (Config.DEBUG) {
            _log.fine(player.getObjectId() + "(" + player.getName() + ") requested a clan creation.");
        }
        if (10 > player.getLevel()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN));
            return null;
        }
        if (0 != player.getClanId()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_CREATE_CLAN));
            return null;
        }
        if (System.currentTimeMillis() < player.getClanCreateExpiryTime()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MUST_WAIT_XX_DAYS_BEFORE_CREATING_A_NEW_CLAN));
            return null;
        }
        if (!Util.isAlphaNumeric(clanName) || 2 > clanName.length()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_NAME_INCORRECT));
            return null;
        }
        if (16 < clanName.length()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_NAME_TOO_LONG));
            return null;
        }
        if (null != this.getClanByName(clanName)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_EXISTS);
            sm.addString(clanName);
            player.sendPacket(sm);
            sm = null;
            return null;
        }
        L2Clan clan = new L2Clan(IdFactory.getInstance().getNextId(), clanName);
        L2ClanMember leader = new L2ClanMember(clan, player.getName(), player.getLevel(), player.getClassId().getId(), player.getObjectId(), player.getPledgeType(), player.getPowerGrade(), player.getTitle(), player.getAppearance().getSex(), player.getRace().ordinal());
        clan.setLeader(leader);
        leader.setPlayerInstance(player);
        clan.store();
        player.setClan(clan);
        player.setPledgeClass(leader.calculatePledgeClass(player));
        player.setClanPrivileges(0xFFFFFE);
        if (Config.DEBUG) {
            _log.fine("New clan created: " + clan.getClanId() + " " + clan.getName());
        }
        this._clans.put(clan.getClanId(), clan);
        player.sendPacket(new PledgeShowInfoUpdate(clan));
        player.sendPacket(new PledgeShowMemberListAll(clan, player));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.sendPacket(new PledgeShowMemberListUpdate(player));
        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_CREATED));
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, clan, 3));
        return clan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyClan(int clanId) {
        L2ClanMember leaderMember;
        int fortId;
        L2Clan clan = this.getClan(clanId);
        if (clan == null) {
            return;
        }
        clan.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_HAS_DISPERSED));
        int castleId = clan.getHasCastle();
        if (castleId == 0) {
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                siege.removeSiegeClan(clan);
            }
        }
        if ((fortId = clan.getHasFort()) == 0) {
            for (FortSiege siege : FortSiegeManager.getInstance().getSieges()) {
                siege.removeSiegeClan(clan);
            }
        }
        if ((leaderMember = clan.getLeader()) == null) {
            clan.getWarehouse().destroyAllItems("ClanRemove", null, null);
        } else {
            clan.getWarehouse().destroyAllItems("ClanRemove", clan.getLeader().getPlayerInstance(), null);
        }
        for (L2ClanMember member : clan.getMembers()) {
            clan.removeClanMember(member.getObjectId(), 0L);
        }
        this._clans.remove(clanId);
        IdFactory.getInstance().releaseId(clanId);
        Connection con = null;
        try {
            L2Clan owner;
            Fort fort;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_privs WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_skills WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_subpledges WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? OR clan2=?");
            statement.setInt(1, clanId);
            statement.setInt(2, clanId);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("DELETE FROM clan_notices WHERE clan_id=?");
            statement.setInt(1, clanId);
            statement.execute();
            statement.close();
            if (castleId != 0) {
                statement = con.prepareStatement("UPDATE castle SET taxPercent = 0 WHERE id = ?");
                statement.setInt(1, castleId);
                statement.execute();
                statement.close();
            }
            if (fortId != 0 && (fort = FortManager.getInstance().getFortById(fortId)) != null && clan == (owner = fort.getOwnerClan())) {
                fort.removeOwner(true);
            }
            if (Config.DEBUG) {
                _log.fine("clan removed in db: " + clanId);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error removing clan from DB.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void scheduleRemoveClan(final int clanId) {
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (ClanTable.this.getClan(clanId) == null) {
                    return;
                }
                if (ClanTable.this.getClan(clanId).getDissolvingExpiryTime() != 0L) {
                    ClanTable.this.destroyClan(clanId);
                }
            }
        }, Math.max(this.getClan(clanId).getDissolvingExpiryTime() - System.currentTimeMillis(), 300000L));
    }

    public boolean isAllyExists(String allyName) {
        for (L2Clan clan : this.getClans()) {
            if (clan.getAllyName() == null || !clan.getAllyName().equalsIgnoreCase(allyName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeclanswars(int clanId1, int clanId2) {
        L2Clan clan1 = ClanTable.getInstance().getClan(clanId1);
        L2Clan clan2 = ClanTable.getInstance().getClan(clanId2);
        clan1.setEnemyClan(clan2);
        clan2.setAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO clan_wars (clan1, clan2, wantspeace1, wantspeace2) VALUES(?,?,?,?)");
            statement.setInt(1, clanId1);
            statement.setInt(2, clanId2);
            statement.setInt(3, 0);
            statement.setInt(4, 0);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error storing clan wars data.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_AGAINST_S1_IF_KILLED_LOSE_LOW_EXP);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_DECLARED_WAR);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteclanswars(int clanId1, int clanId2) {
        L2Clan clan1 = ClanTable.getInstance().getClan(clanId1);
        L2Clan clan2 = ClanTable.getInstance().getClan(clanId2);
        clan1.deleteEnemyClan(clan2);
        clan2.deleteAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? AND clan2=?");
            statement.setInt(1, clanId1);
            statement.setInt(2, clanId2);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error removing clan wars data.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.WAR_AGAINST_S1_HAS_STOPPED);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_HAS_DECIDED_TO_STOP);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    public void checkSurrender(L2Clan clan1, L2Clan clan2) {
        int count = 0;
        for (L2ClanMember player : clan1.getMembers()) {
            if (player == null || player.getPlayerInstance().getWantsPeace() != 1) continue;
            ++count;
        }
        if (count == clan1.getMembers().length - 1) {
            clan1.deleteEnemyClan(clan2);
            clan2.deleteEnemyClan(clan1);
            this.deleteclanswars(clan1.getClanId(), clan2.getClanId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorewars() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT clan1, clan2, wantspeace1, wantspeace2 FROM clan_wars");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                this.getClan(rset.getInt("clan1")).setEnemyClan(rset.getInt("clan2"));
                this.getClan(rset.getInt("clan2")).setAttackerClan(rset.getInt("clan1"));
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error restoring clan wars data.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void allianceCheck() {
        for (L2Clan clan : this._clans.values()) {
            int allyId = clan.getAllyId();
            if (allyId == 0 || clan.getClanId() == allyId || this._clans.containsKey(allyId)) continue;
            clan.setAllyId(0);
            clan.setAllyName(null);
            clan.changeAllyCrest(0, true);
            clan.updateClanInDB();
            _log.info(this.getClass().getSimpleName() + ": Removed alliance from clan: " + clan);
        }
    }

    public void storeClanScore() {
        for (L2Clan clan : this._clans.values()) {
            clan.updateClanScoreInDB();
        }
    }

    private static class SingletonHolder {
        protected static final ClanTable _instance = new ClanTable();

        private SingletonHolder() {
        }
    }
}

