/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.util.logging.Logger;

public final class RequestMagicSkillUse
extends L2GameClientPacket {
    private static final String _C__2F_REQUESTMAGICSKILLUSE = "[C] 2F RequestMagicSkillUse";
    private static Logger _log = Logger.getLogger(RequestMagicSkillUse.class.getName());
    private int _magicId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._magicId = this.readD();
        this._ctrlPressed = this.readD() != 0;
        this._shiftPressed = this.readC() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int level = activeChar.getSkillLevel(this._magicId);
        if (level <= 0) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._magicId, level);
        if (skill != null) {
            if ((activeChar.isTransformed() || activeChar.isInStance()) && !activeChar.containsAllowedTransformSkill(skill.getId())) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (skill.getSkillType() == L2SkillType.RECALL && !Config.ALT_GAME_KARMA_PLAYER_CAN_TELEPORT && activeChar.getKarma() > 0) {
                return;
            }
            if (skill.isToggle() && activeChar.isMounted()) {
                return;
            }
            activeChar.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        } else {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            _log.warning("No skill found with id " + this._magicId + " and level " + level + " !!");
        }
    }

    @Override
    public String getType() {
        return _C__2F_REQUESTMAGICSKILLUSE;
    }
}

