/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.accountmanager;

import com.l2jserver.Base64;
import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.Server;
import com.l2jserver.ngl.ConsoleLocalizator;
import com.l2jserver.ngl.LocaleCodes;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import javolution.util.FastList;

public class SQLAccountManager {
    private static String _uname = "";
    private static String _pass = "";
    private static String _level = "";
    private static String _mode = "";
    private static ConsoleLocalizator cl;

    public static void main(String[] args) throws SQLException, IOException, NoSuchAlgorithmException {
        Server.serverMode = 2;
        Config.load();
        cl = args.length > 0 ? (LocaleCodes.getInstance().getLanguage(args[0]) != null ? new ConsoleLocalizator("accountmanager", "SQLAccountManager", LocaleCodes.getInstance().getLanguage(args[0])) : new ConsoleLocalizator("accountmanager", "SQLAccountManager", args[0])) : new ConsoleLocalizator("accountmanager", "SQLAccountManager", Locale.getDefault());
        while (true) {
            cl.println("functChooser", new Object[0]);
            cl.println();
            cl.println("functCreateAccount", new Object[0]);
            cl.println("functAccessLevel", new Object[0]);
            cl.println("functDeleteAccount", new Object[0]);
            cl.println("functListAccount", new Object[0]);
            cl.println("functExit", new Object[0]);
            while (!(_mode.equals("1") || _mode.equals("2") || _mode.equals("3") || _mode.equals("4") || _mode.equals("5"))) {
                _mode = cl.inputString("inputChoice", new Object[0]);
            }
            if (_mode.equals("1") || _mode.equals("2") || _mode.equals("3")) {
                if (_mode.equals("1") || _mode.equals("2")) {
                    while (_uname.trim().length() == 0) {
                        _uname = cl.inputString("inputUsername", new Object[0]).toLowerCase();
                    }
                } else if (_mode.equals("3")) {
                    while (_uname.trim().length() == 0) {
                        _uname = cl.inputString("inputUsername", new Object[0]).toLowerCase();
                    }
                }
                if (_mode.equals("1")) {
                    while (_pass.trim().length() == 0) {
                        _pass = cl.inputString("inputPassword", new Object[0]);
                    }
                }
                if (_mode.equals("1") || _mode.equals("2")) {
                    while (_level.trim().length() == 0) {
                        _level = cl.inputString("inputAccessLevel", new Object[0]);
                    }
                }
            }
            if (_mode.equals("1")) {
                SQLAccountManager.addOrUpdateAccount(_uname.trim(), _pass.trim(), _level.trim());
            } else if (_mode.equals("2")) {
                SQLAccountManager.changeAccountLevel(_uname.trim(), _level.trim());
            } else if (_mode.equals("3")) {
                String yesno = cl.inputString("functDeleteAccountConfirm", new Object[0]);
                if (yesno != null && yesno.equalsIgnoreCase(cl.getString("yesChar", new Object[0]))) {
                    SQLAccountManager.deleteAccount(_uname.trim());
                } else {
                    cl.println("functDeleteAccountCancel", new Object[0]);
                }
            } else if (_mode.equals("4")) {
                _mode = "";
                cl.println();
                cl.println("functListAccountChooser", new Object[0]);
                cl.println();
                cl.println("functListAccountBanned", new Object[0]);
                cl.println("functListAccountPrivileged", new Object[0]);
                cl.println("functListAccountRegular", new Object[0]);
                cl.println("functListAccountAll", new Object[0]);
                while (!(_mode.equals("1") || _mode.equals("2") || _mode.equals("3") || _mode.equals("4"))) {
                    _mode = cl.inputString("inputChoice", new Object[0]);
                }
                cl.println();
                SQLAccountManager.printAccInfo(_mode);
            } else if (_mode.equals("5")) {
                System.exit(0);
            }
            _uname = "";
            _pass = "";
            _level = "";
            _mode = "";
            cl.println();
        }
    }

    private static void printAccInfo(String m) throws SQLException {
        int count = 0;
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        String q = "SELECT login, accessLevel FROM accounts ";
        if (m.equals("1")) {
            q = q.concat("WHERE accessLevel < 0");
        } else if (m.equals("2")) {
            q = q.concat("WHERE accessLevel > 0");
        } else if (m.equals("3")) {
            q = q.concat("WHERE accessLevel = 0");
        }
        q = q.concat(" ORDER BY login ASC");
        PreparedStatement statement = con.prepareStatement(q);
        ResultSet rset = statement.executeQuery();
        while (rset.next()) {
            System.out.println(rset.getString("login") + " -> " + rset.getInt("accessLevel"));
            ++count;
        }
        rset.close();
        statement.close();
        L2DatabaseFactory.close(con);
        cl.println("functListAccountDisplayed", count);
    }

    private static void addOrUpdateAccount(String account, String password, String level) throws IOException, SQLException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] newpass = password.getBytes("UTF-8");
        newpass = md.digest(newpass);
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("REPLACE accounts (login, password, accessLevel) VALUES (?,?,?)");
        statement.setString(1, account);
        statement.setString(2, Base64.encodeBytes(newpass));
        statement.setString(3, level);
        statement.executeUpdate();
        statement.close();
        L2DatabaseFactory.close(con);
    }

    private static void changeAccountLevel(String account, String level) throws SQLException {
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("SELECT COUNT(*) FROM accounts WHERE login=?;");
        statement.setString(1, account);
        ResultSet rset = statement.executeQuery();
        if (!rset.next()) {
            cl.println("falseString", new Object[0]);
        } else if (rset.getInt(1) > 0) {
            statement = con.prepareStatement("UPDATE accounts SET accessLevel=? WHERE login=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, level);
            statement.setString(2, account);
            statement.executeUpdate();
            cl.println("functAccessLevelUpdated", account);
        } else {
            cl.println("functAccessLevelNotExist", account);
        }
        rset.close();
        statement.close();
        L2DatabaseFactory.close(con);
    }

    private static void deleteAccount(String account) throws SQLException {
        Connection con = null;
        con = L2DatabaseFactory.getInstance().getConnection();
        PreparedStatement statement = con.prepareStatement("SELECT COUNT(*) FROM accounts WHERE login=?;");
        statement.setString(1, account);
        ResultSet rset = statement.executeQuery();
        if (!rset.next()) {
            cl.println("falseString", new Object[0]);
            rset.close();
        } else if (rset.getInt(1) > 0) {
            rset.close();
            statement = con.prepareStatement("SELECT charId, char_name, clanid FROM characters WHERE account_name=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, account);
            rset = statement.executeQuery();
            FastList objIds = new FastList();
            FastList charNames = new FastList();
            FastList clanIds = new FastList();
            while (rset.next()) {
                objIds.add((Object)rset.getString("charId"));
                charNames.add((Object)rset.getString("char_name"));
                clanIds.add((Object)rset.getString("clanid"));
            }
            rset.close();
            for (int index = 0; index < objIds.size(); ++index) {
                cl.println("functDeleteAccountChar", charNames.get(index));
                statement.close();
                statement = con.prepareStatement("SELECT COUNT(*) FROM clan_data WHERE leader_id=?;");
                statement.setString(1, (String)clanIds.get(index));
                ResultSet rcln = statement.executeQuery();
                rcln.next();
                if (rcln.getInt(1) > 0) {
                    rcln.close();
                    statement.close();
                    statement = con.prepareStatement("SELECT clan_name FROM clan_data WHERE leader_id=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    rcln = statement.executeQuery();
                    rcln.next();
                    String clanName = rcln.getString("clan_name");
                    cl.println("functDeleteAccountClan", clanName);
                    statement.close();
                    statement = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? OR clan2=?;");
                    statement.setEscapeProcessing(true);
                    statement.setString(1, clanName);
                    statement.setString(2, clanName);
                    statement.executeUpdate();
                    rcln.close();
                    statement.close();
                    statement = con.prepareStatement("UPDATE characters SET clanid=0 WHERE clanid=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                    statement.close();
                    statement = con.prepareStatement("UPDATE clanhall SET ownerId=0, paidUntil=0, paid=0 WHERE ownerId=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                    statement.close();
                    statement = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                    statement.close();
                    statement = con.prepareStatement("DELETE FROM clan_privs WHERE clan_id=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                    statement.close();
                    statement = con.prepareStatement("DELETE FROM clan_subpledges WHERE clan_id=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                    statement.close();
                    statement = con.prepareStatement("DELETE FROM clan_skills WHERE clan_id=?;");
                    statement.setString(1, (String)clanIds.get(index));
                    statement.executeUpdate();
                } else {
                    rcln.close();
                }
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_skills WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_skills_save WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_subclasses WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM items WHERE owner_id=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_macroses WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_contacts WHERE charId=? OR contactId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.setString(2, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_friends WHERE charId=? OR friendId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.setString(2, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM boxaccess WHERE charname=?;");
                statement.setString(1, (String)charNames.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_hennas WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_reco_bonus WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_ui_categories WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM character_ui_keys WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
                statement.close();
                statement = con.prepareStatement("DELETE FROM characters WHERE charId=?;");
                statement.setString(1, (String)objIds.get(index));
                statement.executeUpdate();
            }
            statement.close();
            statement = con.prepareStatement("DELETE FROM account_gsdata WHERE account_name=?;");
            statement.setString(1, account);
            statement.executeUpdate();
            statement.close();
            statement = con.prepareStatement("DELETE FROM accounts WHERE login=?;");
            statement.setEscapeProcessing(true);
            statement.setString(1, account);
            statement.executeUpdate();
            cl.println("functDeleteAccountComplete", account);
        } else {
            cl.println("functDeleteAccountNotExist", account);
        }
        statement.close();
        L2DatabaseFactory.close(con);
    }
}

