/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.NpcWalkerRoutesTable;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2NpcWalkerInstance;
import com.l2jserver.util.Rnd;
import java.util.List;

public class L2NpcWalkerAI
extends L2CharacterAI
implements Runnable {
    private static final int DEFAULT_MOVE_DELAY = 0;
    private boolean _walkingToNextPoint = false;
    private List<L2NpcWalkerNode> _route;
    private int _currentPos;

    public L2NpcWalkerAI(L2Character.AIAccessor accessor) {
        super(accessor);
        if (!Config.ALLOW_NPC_WALKERS) {
            return;
        }
        this._route = NpcWalkerRoutesTable.getInstance().getRouteForNpc(this.getActor().getNpcId());
        if (this._route != null) {
            ThreadPoolManager.getInstance().scheduleAi(this, Rnd.get(300000, 36000));
        } else {
            _log.warning(this.getClass().getSimpleName() + ": Missing route data! Npc: " + this._actor);
        }
    }

    @Override
    public void run() {
        assert (!this.isWalkingToNextPoint());
        this._currentPos = (this._currentPos + 1) % this._route.size();
        L2NpcWalkerNode pos = this._route.get(this._currentPos);
        if (pos.getRunning()) {
            this.getActor().setRunning();
        } else {
            this.getActor().setWalking();
        }
        this.setWalkingToNextPoint(true);
        this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(pos.getMoveX(), pos.getMoveY(), pos.getMoveZ(), 0));
    }

    @Override
    protected void onEvtArrived() {
        super.onEvtArrived();
        if (!Config.ALLOW_NPC_WALKERS) {
            return;
        }
        if (this.isWalkingToNextPoint()) {
            long delay;
            String chat;
            L2NpcWalkerNode pos = this._route.get(this._currentPos);
            int id = pos.getChatId();
            String string = chat = id == 0 ? pos.getChatText() : null;
            if (id > 0 || chat != null && !chat.isEmpty()) {
                this.getActor().broadcastChat(chat, id);
            }
            if ((delay = (long)pos.getDelay()) <= 0L) {
                delay = 0L;
                if (Config.DEVELOPER) {
                    _log.warning("Wrong Delay Set in Npc Walker Functions = " + delay + " secs, using default delay: " + 0 + " secs instead.");
                }
            }
            this.setWalkingToNextPoint(false);
            ThreadPoolManager.getInstance().scheduleAi(this, delay * 1000L);
        }
    }

    @Override
    protected void onEvtArrivedBlocked(L2CharPosition blocked_at_pos) {
        _log.warning("NpcWalker ID: " + this.getActor().getNpcId() + ": Blocked at rote position [" + this._currentPos + "], coords: " + blocked_at_pos.x + ", " + blocked_at_pos.y + ", " + blocked_at_pos.z + ". Teleporting to next point");
        L2NpcWalkerNode pos = this._route.get(this._currentPos);
        this.getActor().teleToLocation(pos.getMoveX(), pos.getMoveY(), pos.getMoveZ(), false);
        super.onEvtArrivedBlocked(blocked_at_pos);
    }

    @Override
    public L2NpcWalkerInstance getActor() {
        return (L2NpcWalkerInstance)super.getActor();
    }

    private boolean isWalkingToNextPoint() {
        return this._walkingToNextPoint;
    }

    private void setWalkingToNextPoint(boolean value) {
        this._walkingToNextPoint = value;
    }
}

