/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.Rnd;
import javolution.util.FastList;

public class L2CastleMagicianInstance
extends L2NpcInstance
implements L2SquadTrainer {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;

    public L2CastleMagicianInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2CastleMagicianInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/castlemagician/magician-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/castlemagician/magician-busy.htm";
            } else if (condition == 2) {
                filename = val == 0 ? "data/html/castlemagician/magician.htm" : "data/html/castlemagician/magician-" + val + ".htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
            return;
        }
        if (command.startsWith("ExchangeKE")) {
            int item;
            String filename = null;
            int i0 = Rnd.get(100);
            if (i0 < 5) {
                int i1 = Rnd.get(100);
                item = i1 < 5 ? 9931 : (i1 <= 50 ? 9932 : (i1 <= 75 ? 10416 : 10417));
            } else if (i0 <= 15) {
                switch (Rnd.get(5)) {
                    case 1: {
                        item = 9917;
                        break;
                    }
                    case 2: {
                        item = 9918;
                        break;
                    }
                    case 3: {
                        item = 9928;
                        break;
                    }
                    case 4: {
                        item = 9929;
                        break;
                    }
                    default: {
                        item = 9920;
                        break;
                    }
                }
            } else if (i0 <= 30) {
                switch (Rnd.get(8)) {
                    case 1: {
                        item = 9916;
                        break;
                    }
                    case 2: {
                        item = 9916;
                        break;
                    }
                    case 3: {
                        item = 9924;
                        break;
                    }
                    case 4: {
                        item = 9925;
                        break;
                    }
                    case 5: {
                        item = 9926;
                        break;
                    }
                    case 6: {
                        item = 9927;
                        break;
                    }
                    case 7: {
                        item = 10518;
                        break;
                    }
                    default: {
                        item = 10424;
                        break;
                    }
                }
            } else {
                switch (Rnd.get(46)) {
                    case 0: {
                        item = 9914;
                        break;
                    }
                    case 1: {
                        item = 9915;
                        break;
                    }
                    case 2: {
                        item = 9920;
                        break;
                    }
                    case 3: {
                        item = 9920;
                        break;
                    }
                    case 4: {
                        item = 9921;
                        break;
                    }
                    case 5: {
                        item = 9922;
                        break;
                    }
                    case 6: {
                        item = 9933;
                        break;
                    }
                    case 7: {
                        item = 9934;
                        break;
                    }
                    case 8: {
                        item = 9935;
                        break;
                    }
                    case 9: {
                        item = 9936;
                        break;
                    }
                    case 10: {
                        item = 9937;
                        break;
                    }
                    case 11: {
                        item = 9938;
                        break;
                    }
                    case 12: {
                        item = 9939;
                        break;
                    }
                    case 13: {
                        item = 9940;
                        break;
                    }
                    case 14: {
                        item = 9941;
                        break;
                    }
                    case 15: {
                        item = 9942;
                        break;
                    }
                    case 16: {
                        item = 9943;
                        break;
                    }
                    case 17: {
                        item = 9944;
                        break;
                    }
                    case 18: {
                        item = 9945;
                        break;
                    }
                    case 19: {
                        item = 9946;
                        break;
                    }
                    case 20: {
                        item = 9947;
                        break;
                    }
                    case 21: {
                        item = 9948;
                        break;
                    }
                    case 22: {
                        item = 9949;
                        break;
                    }
                    case 23: {
                        item = 9950;
                        break;
                    }
                    case 24: {
                        item = 9965;
                        break;
                    }
                    case 25: {
                        item = 9952;
                        break;
                    }
                    case 26: {
                        item = 9953;
                        break;
                    }
                    case 27: {
                        item = 9954;
                        break;
                    }
                    case 28: {
                        item = 9955;
                        break;
                    }
                    case 29: {
                        item = 9956;
                        break;
                    }
                    case 30: {
                        item = 9957;
                        break;
                    }
                    case 31: {
                        item = 9958;
                        break;
                    }
                    case 32: {
                        item = 9959;
                        break;
                    }
                    case 33: {
                        item = 9960;
                        break;
                    }
                    case 34: {
                        item = 9961;
                        break;
                    }
                    case 35: {
                        item = 9962;
                        break;
                    }
                    case 36: {
                        item = 9963;
                        break;
                    }
                    case 37: {
                        item = 9964;
                        break;
                    }
                    case 38: {
                        item = 10418;
                        break;
                    }
                    case 39: {
                        item = 10420;
                        break;
                    }
                    case 40: {
                        item = 10519;
                        break;
                    }
                    case 41: {
                        item = 10422;
                        break;
                    }
                    case 42: {
                        item = 10423;
                        break;
                    }
                    case 43: {
                        item = 10419;
                        break;
                    }
                    default: {
                        item = 10421;
                    }
                }
            }
            if (player.destroyItemByItemId("ExchangeKE", 9912, 10L, this, false)) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                msg.addItemName(9912);
                msg.addNumber(10);
                player.sendPacket(msg);
                player.addItem("ExchangeKE", item, 1L, player, true);
                filename = "data/html/castlemagician/magician-KE-Exchange.htm";
            } else {
                filename = "data/html/castlemagician/magician-no-KE.htm";
            }
            this.showChatWindow(player, filename);
            return;
        }
        if (command.equals("gotoleader")) {
            if (player.getClan() != null) {
                L2PcInstance clanLeader = player.getClan().getLeader().getPlayerInstance();
                if (clanLeader == null) {
                    return;
                }
                if (clanLeader.getFirstEffect(L2EffectType.CLAN_GATE) != null) {
                    if (!L2CastleMagicianInstance.validateGateCondition(clanLeader, player)) {
                        return;
                    }
                    player.teleToLocation(clanLeader.getX(), clanLeader.getY(), clanLeader.getZ(), false);
                    return;
                }
                String filename = "data/html/castlemagician/magician-nogate.htm";
                this.showChatWindow(player, filename);
            }
            return;
        }
        if (command.equals("subskills")) {
            if (player.getClan() != null) {
                if (player.isClanLeader()) {
                    AcquireSkillList skilllist = new AcquireSkillList(AcquireSkillList.SkillType.SubClass);
                    FastList<L2SkillLearn> list = SkillTreesData.getInstance().getAvailableSubPledgeSkills(player.getClan());
                    if (list.isEmpty()) {
                        player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
                        return;
                    }
                    for (L2SkillLearn skillLearn : list) {
                        skilllist.addSkill(skillLearn.getSkillId(), skillLearn.getSkillLevel(), skillLearn.getSkillLevel(), skillLearn.getLevelUpSp(), 0);
                    }
                    player.sendPacket(skilllist);
                } else {
                    String filename = "data/html/castlemagician/magician-nosquad.htm";
                    this.showChatWindow(player, filename);
                }
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    protected int validateCondition(L2PcInstance player) {
        if (player.isGM()) {
            return 2;
        }
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getZone().isActive()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }

    private static final boolean validateGateCondition(L2PcInstance clanLeader, L2PcInstance player) {
        if (clanLeader.isAlikeDead()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInStoreMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isRooted() || clanLeader.isInCombat()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInOlympiadMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isFestivalParticipant()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.inObserverMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInsideZone((byte)12)) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.getInstanceId() > 0 && (!Config.ALLOW_SUMMON_TO_INSTANCE || InstanceManager.getInstance().getInstance(player.getInstanceId()).isSummonAllowed())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (player.isIn7sDungeon()) {
            int targetCabal = SevenSigns.getInstance().getPlayerCabal(clanLeader.getObjectId());
            if (SevenSigns.getInstance().isSealValidationPeriod()) {
                if (targetCabal != SevenSigns.getInstance().getCabalHighestScore()) {
                    player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                    return false;
                }
            } else if (targetCabal == 0) {
                player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                return false;
            }
        }
        if (!TvTEvent.onEscapeUse(player.getObjectId())) {
            player.sendMessage("You on TvT Event, teleporting disabled.");
            return false;
        }
        if (!TvTEvent.onEscapeUse(clanLeader.getObjectId())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        return true;
    }

    @Override
    public void showSubUnitSkillList(L2PcInstance player) {
        this.onBypassFeedback(player, "subskills");
    }
}

