/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2DoorAI;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DoorKnownList;
import com.l2jserver.gameserver.model.actor.stat.DoorStat;
import com.l2jserver.gameserver.model.actor.status.DoorStatus;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.DoorStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.OnEventTrigger;
import com.l2jserver.gameserver.network.serverpackets.StaticObject;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2DoorInstance
extends L2Character {
    protected static final Logger log = Logger.getLogger(L2DoorInstance.class.getName());
    private int _castleIndex = -2;
    private int _mapRegion = -1;
    private int _fortIndex = -2;
    private int _rangeXMin = 0;
    private int _rangeYMin = 0;
    private int _rangeZMin = 0;
    private int _rangeXMax = 0;
    private int _rangeYMax = 0;
    private int _rangeZMax = 0;
    private int _A = 0;
    private int _B = 0;
    private int _C = 0;
    private int _D = 0;
    protected final int _doorId;
    protected final String _name;
    private boolean _open;
    private boolean _isCommanderDoor;
    private boolean _unlockable;
    private boolean _isAttackableDoor = false;
    private boolean _isWall = false;
    private boolean _ShowHp = false;
    private int _meshindex = 1;
    private int _emitter = 0;
    private boolean _targetable = true;
    private int _level;
    private ClanHall _clanHall;
    protected int _autoActionDelay = -1;
    private ScheduledFuture<?> _autoActionTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2DoorInstance l2DoorInstance = this;
            synchronized (l2DoorInstance) {
                if (this._ai == null) {
                    this._ai = new L2DoorAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    public L2DoorInstance(int objectId, L2CharTemplate template, int doorId, String name, boolean unlockable) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2DoorInstance);
        this.setIsInvul(false);
        this._doorId = doorId;
        this._name = name;
        this._unlockable = unlockable;
    }

    @Override
    public final DoorKnownList getKnownList() {
        return (DoorKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DoorKnownList(this));
    }

    @Override
    public final DoorStat getStat() {
        return (DoorStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new DoorStat(this));
    }

    @Override
    public final DoorStatus getStatus() {
        return (DoorStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new DoorStatus(this));
    }

    public final boolean isUnlockable() {
        return this._unlockable;
    }

    public final void setLevel(int newLevel) {
        this._level = newLevel;
    }

    @Override
    public final int getLevel() {
        return this._level;
    }

    public int getDoorId() {
        return this._doorId;
    }

    public boolean getOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open;
    }

    public void setIsCommanderDoor(boolean val) {
        this._isCommanderDoor = val;
    }

    public boolean getIsCommanderDoor() {
        return this._isCommanderDoor;
    }

    public boolean getIsAttackableDoor() {
        return this._isAttackableDoor;
    }

    public boolean getIsShowHp() {
        return this._ShowHp;
    }

    public void setIsAttackableDoor(boolean val) {
        this._isAttackableDoor = val;
    }

    public void setIsShowHp(boolean val) {
        this._ShowHp = val;
    }

    public void setAutoActionDelay(int actionDelay) {
        if (this._autoActionDelay == actionDelay) {
            return;
        }
        if (actionDelay > -1) {
            AutoOpenClose ao = new AutoOpenClose();
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(ao, actionDelay, actionDelay);
        } else if (this._autoActionTask != null) {
            this._autoActionTask.cancel(false);
        }
        this._autoActionDelay = actionDelay;
    }

    public int getDamage() {
        int dmg = 6 - (int)Math.ceil(this.getCurrentHp() / (double)this.getMaxHp() * 6.0);
        if (dmg > 6) {
            return 6;
        }
        if (dmg < 0) {
            return 0;
        }
        return dmg;
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            this._castleIndex = CastleManager.getInstance().getCastleIndex(this);
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            this._fortIndex = FortManager.getInstance().getFortIndex(this);
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public void setClanHall(ClanHall clanhall) {
        this._clanHall = clanhall;
    }

    public ClanHall getClanHall() {
        return this._clanHall;
    }

    public boolean isEnemy() {
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getZone().isActive()) {
            return true;
        }
        return this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getZone().isActive() && !this.getIsCommanderDoor();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        L2Clan clan;
        boolean isFort;
        if (this.isUnlockable() && this.getFort() == null) {
            return true;
        }
        if (!(attacker instanceof L2Playable)) {
            return false;
        }
        if (this.getClanHall() != null) {
            return false;
        }
        boolean isCastle = this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getZone().isActive();
        boolean bl = isFort = this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getZone().isActive() && !this.getIsCommanderDoor();
        int activeSiegeId = this.getFort() != null ? this.getFort().getFortId() : (this.getCastle() != null ? this.getCastle().getCastleId() : 0);
        L2PcInstance actingPlayer = attacker.getActingPlayer();
        if (TerritoryWarManager.getInstance().isTWInProgress()) {
            return !TerritoryWarManager.getInstance().isAllyField(actingPlayer, activeSiegeId);
        }
        if (isFort ? (clan = actingPlayer.getClan()) != null && clan == this.getFort().getOwnerClan() : isCastle && (clan = actingPlayer.getClan()) != null && clan.getClanId() == this.getCastle().getOwnerId()) {
            return false;
        }
        return isCastle || isFort || this.getIsAttackableDoor();
    }

    public boolean isAttackable(L2Character attacker) {
        return this.isAutoAttackable(attacker);
    }

    @Override
    public void updateAbnormalEffect() {
    }

    public int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 3000;
    }

    public int getDistanceToForgetObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 4000;
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public void broadcastStatusUpdate() {
        Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        StaticObject su = new StaticObject(this, false);
        DoorStatusUpdate dsu = new DoorStatusUpdate(this);
        OnEventTrigger oe = null;
        if (this._emitter > 0) {
            oe = new OnEventTrigger(this, this.getOpen());
        }
        for (L2PcInstance player : knownPlayers) {
            if (this.getCastle() != null && this.getCastle().getCastleId() > 0 || this.getFort() != null && this.getFort().getFortId() > 0 && !this.getIsCommanderDoor()) {
                su = new StaticObject(this, true);
            }
            player.sendPacket(su);
            player.sendPacket(dsu);
            if (oe == null) continue;
            player.sendPacket(oe);
        }
    }

    public void onOpen() {
        ThreadPoolManager.getInstance().scheduleGeneral(new CloseTask(), 60000L);
    }

    public void onClose() {
        this.closeMe();
    }

    public final void closeMe() {
        this.setOpen(false);
        this.broadcastStatusUpdate();
    }

    public final void openMe() {
        this.setOpen(true);
        this.broadcastStatusUpdate();
    }

    @Override
    public String toString() {
        return "door " + this._doorId;
    }

    public String getDoorName() {
        return this._name;
    }

    public int getXMin() {
        return this._rangeXMin;
    }

    public int getYMin() {
        return this._rangeYMin;
    }

    public int getZMin() {
        return this._rangeZMin;
    }

    public int getXMax() {
        return this._rangeXMax;
    }

    public int getYMax() {
        return this._rangeYMax;
    }

    public int getZMax() {
        return this._rangeZMax;
    }

    public void setRange(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this._rangeXMin = xMin;
        this._rangeYMin = yMin;
        this._rangeZMin = zMin;
        this._rangeXMax = xMax;
        this._rangeYMax = yMax;
        this._rangeZMax = zMax;
        this._A = this._rangeYMax * (this._rangeZMax - this._rangeZMin) + this._rangeYMin * (this._rangeZMin - this._rangeZMax);
        this._B = this._rangeZMin * (this._rangeXMax - this._rangeXMin) + this._rangeZMax * (this._rangeXMin - this._rangeXMax);
        this._C = this._rangeXMin * (this._rangeYMax - this._rangeYMin) + this._rangeXMin * (this._rangeYMin - this._rangeYMax);
        this._D = -1 * (this._rangeXMin * (this._rangeYMax * this._rangeZMax - this._rangeYMin * this._rangeZMax) + this._rangeXMax * (this._rangeYMin * this._rangeZMin - this._rangeYMin * this._rangeZMax) + this._rangeXMin * (this._rangeYMin * this._rangeZMax - this._rangeYMax * this._rangeZMin));
    }

    public int getMapRegion() {
        return this._mapRegion;
    }

    public void setMapRegion(int region) {
        this._mapRegion = region;
    }

    public Collection<L2DefenderInstance> getKnownDefenders() {
        FastList result = new FastList();
        Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2DefenderInstance)) continue;
            result.add((Object)((L2DefenderInstance)obj));
        }
        return result;
    }

    public int getA() {
        return this._A;
    }

    public int getB() {
        return this._B;
    }

    public int getC() {
        return this._C;
    }

    public int getD() {
        return this._D;
    }

    public void setIsWall(boolean b) {
        this._isWall = b;
    }

    public boolean isWall() {
        return this._isWall;
    }

    public void setMeshIndex(int mesh) {
        this._meshindex = mesh;
    }

    public int getMeshIndex() {
        return this._meshindex;
    }

    public void setEmitter(int emitter) {
        this._emitter = emitter;
    }

    public int getEmitter() {
        return this._emitter;
    }

    public void setTargetable(boolean targetable) {
        this._targetable = targetable;
    }

    public boolean getTargetable() {
        return this._targetable;
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (this._isWall && !(attacker instanceof L2SiegeSummonInstance)) {
            return;
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    @Override
    public void reduceCurrentHpByDOT(double i, L2Character attacker, L2Skill skill) {
    }

    @Override
    public boolean doDie(L2Character killer) {
        boolean isCastle;
        if (!super.doDie(killer)) {
            return false;
        }
        boolean isFort = this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getSiege().getIsInProgress() && !this.getIsCommanderDoor();
        boolean bl = isCastle = this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress();
        if (isFort || isCastle) {
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.CASTLE_GATE_BROKEN_DOWN));
        }
        return true;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._emitter > 0) {
            activeChar.sendPacket(new OnEventTrigger(this, this.getOpen()));
        }
        activeChar.sendPacket(new StaticObject(this, false));
    }

    class AutoOpenClose
    implements Runnable {
        AutoOpenClose() {
        }

        @Override
        public void run() {
            try {
                String doorAction;
                if (!L2DoorInstance.this.getOpen()) {
                    doorAction = "opened";
                    L2DoorInstance.this.openMe();
                } else {
                    doorAction = "closed";
                    L2DoorInstance.this.closeMe();
                }
                if (Config.DEBUG) {
                    L2Character._log.info("Auto " + doorAction + " door ID " + L2DoorInstance.this._doorId + " (" + L2DoorInstance.this._name + ") for " + L2DoorInstance.this._autoActionDelay / 60000 + " minute(s).");
                }
            }
            catch (Exception e) {
                L2Character._log.warning("Could not auto open/close door ID " + L2DoorInstance.this._doorId + " (" + L2DoorInstance.this._name + ")");
            }
        }
    }

    class CloseTask
    implements Runnable {
        CloseTask() {
        }

        @Override
        public void run() {
            try {
                L2DoorInstance.this.onClose();
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        @Override
        public L2DoorInstance getActor() {
            return L2DoorInstance.this;
        }

        @Override
        public void moveTo(int x, int y, int z, int offset) {
        }

        @Override
        public void moveTo(int x, int y, int z) {
        }

        @Override
        public void stopMove(L2CharPosition pos) {
        }

        @Override
        public void doAttack(L2Character target) {
        }

        @Override
        public void doCast(L2Skill skill) {
        }
    }
}

