/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import javolution.util.FastList;

public final class L2FishermanInstance
extends L2MerchantInstance {
    public L2FishermanInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FishermanInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/fisherman/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.equalsIgnoreCase("FishSkillList")) {
            L2FishermanInstance.showFishSkillList(player);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public static void showFishSkillList(L2PcInstance player) {
        FastList<L2SkillLearn> skills = SkillTreesData.getInstance().getAvailableFishingSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Fishing);
        int count = 0;
        for (L2SkillLearn s : skills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
            if (sk == null) continue;
            ++count;
            asl.addSkill(s.getSkillId(), s.getSkillLevel(), s.getSkillLevel(), s.getLevelUpSp(), 1);
        }
        if (count == 0) {
            int minlLevel = SkillTreesData.getInstance().getMinLevelForNewSkill(player, SkillTreesData.getInstance().getFishingSkillTree());
            if (minlLevel > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1);
                sm.addNumber(minlLevel);
                player.sendPacket(sm);
            } else {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_MORE_SKILLS_TO_LEARN));
            }
        } else {
            player.sendPacket(asl);
        }
    }
}

