/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.CastleUpdater;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Manor;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2ArtefactInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.zone.type.L2CastleTeleportZone;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import gnu.trove.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Castle {
    protected static final Logger _log = Logger.getLogger(Castle.class.getName());
    private List<CastleManorManager.CropProcure> _procure = new ArrayList<CastleManorManager.CropProcure>();
    private List<CastleManorManager.SeedProduction> _production = new ArrayList<CastleManorManager.SeedProduction>();
    private List<CastleManorManager.CropProcure> _procureNext = new ArrayList<CastleManorManager.CropProcure>();
    private List<CastleManorManager.SeedProduction> _productionNext = new ArrayList<CastleManorManager.SeedProduction>();
    private boolean _isNextPeriodApproved = false;
    private static final String CASTLE_MANOR_DELETE_PRODUCTION = "DELETE FROM castle_manor_production WHERE castle_id=?;";
    private static final String CASTLE_MANOR_DELETE_PRODUCTION_PERIOD = "DELETE FROM castle_manor_production WHERE castle_id=? AND period=?;";
    private static final String CASTLE_MANOR_DELETE_PROCURE = "DELETE FROM castle_manor_procure WHERE castle_id=?;";
    private static final String CASTLE_MANOR_DELETE_PROCURE_PERIOD = "DELETE FROM castle_manor_procure WHERE castle_id=? AND period=?;";
    private static final String CASTLE_UPDATE_CROP = "UPDATE castle_manor_procure SET can_buy=? WHERE crop_id=? AND castle_id=? AND period=?";
    private static final String CASTLE_UPDATE_SEED = "UPDATE castle_manor_production SET can_produce=? WHERE seed_id=? AND castle_id=? AND period=?";
    private int _castleId = 0;
    private List<L2DoorInstance> _doors = new FastList();
    private List<String> _doorDefault = new FastList();
    private String _name = "";
    private String _castleName;
    private String _locName;
    private int _ownerId = 0;
    private Siege _siege = null;
    private Calendar _siegeDate;
    private boolean _isTimeRegistrationOver = true;
    private Calendar _siegeTimeRegistrationEndDate;
    private int _taxPercent = 0;
    private double _taxRate = 0.0;
    private long _treasury = 0L;
    private boolean _showNpcCrest = false;
    private L2SiegeZone _zone = null;
    private L2CastleZone _castleZone = null;
    private L2CastleTeleportZone _teleZone;
    private L2Clan _formerOwner = null;
    private List<L2ArtefactInstance> _artefacts = new ArrayList<L2ArtefactInstance>(1);
    private TIntIntHashMap _engrave = new TIntIntHashMap(1);
    private Map<Integer, CastleFunction> _function;
    private FastList<L2Skill> _residentialSkills = new FastList();
    private int _bloodAlliance = 0;
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_RESTORE_HP = 2;
    public static final int FUNC_RESTORE_MP = 3;
    public static final int FUNC_RESTORE_EXP = 4;
    public static final int FUNC_SUPPORT = 5;

    public Castle(int castleId) {
        this._castleId = castleId;
        this.load();
        this.loadDoor();
        this._function = new FastMap();
        FastList<L2SkillLearn> residentialSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(castleId);
        for (L2SkillLearn s : residentialSkills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
            if (sk != null) {
                this._residentialSkills.add((Object)sk);
                continue;
            }
            _log.warning("Castle Id: " + castleId + " has a null residential skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
        }
        if (this.getOwnerId() != 0) {
            this.loadFunctions();
        }
    }

    public CastleFunction getFunction(int type) {
        if (this._function.get(type) != null) {
            return this._function.get(type);
        }
        return null;
    }

    public synchronized void engrave(L2Clan clan, L2Object target) {
        if (!this._artefacts.contains(target)) {
            return;
        }
        this._engrave.put(target.getObjectId(), clan.getClanId());
        if (this._engrave.size() == this._artefacts.size()) {
            for (L2ArtefactInstance art : this._artefacts) {
                if (this._engrave.get(art.getObjectId()) == clan.getClanId()) continue;
                return;
            }
            this._engrave.clear();
            this.setOwner(clan);
        }
    }

    public void addToTreasury(long amount) {
        Castle aden;
        Castle rune;
        if (this.getOwnerId() <= 0) {
            return;
        }
        if ((this._name.equalsIgnoreCase("Schuttgart") || this._name.equalsIgnoreCase("Goddard")) && (rune = CastleManager.getInstance().getCastle("rune")) != null) {
            long runeTax = (long)((double)amount * rune.getTaxRate());
            if (rune.getOwnerId() > 0) {
                rune.addToTreasury(runeTax);
            }
            amount -= runeTax;
        }
        if (!(this._name.equalsIgnoreCase("aden") || this._name.equalsIgnoreCase("Rune") || this._name.equalsIgnoreCase("Schuttgart") || this._name.equalsIgnoreCase("Goddard") || (aden = CastleManager.getInstance().getCastle("aden")) == null)) {
            long adenTax = (long)((double)amount * aden.getTaxRate());
            if (aden.getOwnerId() > 0) {
                aden.addToTreasury(adenTax);
            }
            amount -= adenTax;
        }
        this.addToTreasuryNoTax(amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToTreasuryNoTax(long amount) {
        if (this.getOwnerId() <= 0) {
            return false;
        }
        if (amount < 0L) {
            if (this._treasury < (amount *= -1L)) {
                return false;
            }
            this._treasury -= amount;
        } else {
            this._treasury = this._treasury + amount > 99900000000L ? 99900000000L : (this._treasury += amount);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE castle SET treasury = ? WHERE id = ?");
            statement.setLong(1, this.getTreasury());
            statement.setInt(2, this.getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return true;
    }

    public void banishForeigners() {
        this.getCastleZone().banishForeigners(this.getOwnerId());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2SiegeZone getZone() {
        if (this._zone == null) {
            for (L2SiegeZone zone : ZoneManager.getInstance().getAllZones(L2SiegeZone.class)) {
                if (zone.getSiegeObjectId() != this.getCastleId()) continue;
                this._zone = zone;
                break;
            }
        }
        return this._zone;
    }

    public L2CastleZone getCastleZone() {
        if (this._castleZone == null) {
            for (L2CastleZone zone : ZoneManager.getInstance().getAllZones(L2CastleZone.class)) {
                if (zone.getCastleId() != this.getCastleId()) continue;
                this._castleZone = zone;
                break;
            }
        }
        return this._castleZone;
    }

    public L2CastleTeleportZone getTeleZone() {
        if (this._teleZone == null) {
            for (L2CastleTeleportZone zone : ZoneManager.getInstance().getAllZones(L2CastleTeleportZone.class)) {
                if (zone.getCastleId() != this.getCastleId()) continue;
                this._teleZone = zone;
                break;
            }
        }
        return this._teleZone;
    }

    public void oustAllPlayers() {
        this.getTeleZone().oustAllPlayers();
    }

    public double getDistance(L2Object obj) {
        return this.getZone().getDistanceToZone(obj);
    }

    public void closeDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, false);
    }

    public void openDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, true);
    }

    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar.getClanId() != this.getOwnerId()) {
            return;
        }
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    public void removeUpgrade() {
        this.removeDoorUpgrade();
        for (Map.Entry<Integer, CastleFunction> fc : this._function.entrySet()) {
            this.removeFunction(fc.getKey());
        }
        this._function.clear();
    }

    public void setOwner(L2Clan clan) {
        L2Clan oldOwner;
        if (this.getOwnerId() > 0 && (clan == null || clan.getClanId() != this.getOwnerId()) && (oldOwner = ClanTable.getInstance().getClan(this.getOwnerId())) != null) {
            if (this._formerOwner == null) {
                this._formerOwner = oldOwner;
                if (Config.REMOVE_CASTLE_CIRCLETS) {
                    CastleManager.getInstance().removeCirclet(this._formerOwner, this.getCastleId());
                }
            }
            try {
                L2PcInstance oldleader = oldOwner.getLeader().getPlayerInstance();
                if (oldleader != null && oldleader.getMountType() == 2) {
                    oldleader.dismount();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception in setOwner: " + e.getMessage(), e);
            }
            oldOwner.setHasCastle(0);
            for (L2PcInstance member : oldOwner.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
        }
        this.updateOwnerInDB(clan);
        this.setShowNpcCrest(false);
        if (clan.getHasFort() > 0) {
            FortManager.getInstance().getFortByOwner(clan).removeOwner(true);
        }
        if (this.getSiege().getIsInProgress()) {
            this.getSiege().midVictory();
        }
        TerritoryWarManager.getInstance().getTerritory(this._castleId).setOwnerClan(clan);
        for (L2PcInstance member : clan.getOnlineMembers(0)) {
            this.giveResidentialSkills(member);
            member.sendSkillList();
        }
    }

    public void removeOwner(L2Clan clan) {
        if (clan != null) {
            this._formerOwner = clan;
            if (Config.REMOVE_CASTLE_CIRCLETS) {
                CastleManager.getInstance().removeCirclet(this._formerOwner, this.getCastleId());
            }
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
            clan.setHasCastle(0);
            clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
        }
        this.updateOwnerInDB(null);
        if (this.getSiege().getIsInProgress()) {
            this.getSiege().midVictory();
        }
        for (Map.Entry<Integer, CastleFunction> fc : this._function.entrySet()) {
            this.removeFunction(fc.getKey());
        }
        this._function.clear();
    }

    public void setTaxPercent(L2PcInstance activeChar, int taxPercent) {
        int maxTax;
        switch (SevenSigns.getInstance().getSealOwner(3)) {
            case 2: {
                maxTax = 25;
                break;
            }
            case 1: {
                maxTax = 5;
                break;
            }
            default: {
                maxTax = 15;
            }
        }
        if (taxPercent < 0 || taxPercent > maxTax) {
            activeChar.sendMessage("Tax value must be between 0 and " + maxTax + ".");
            return;
        }
        this.setTaxPercent(taxPercent);
        activeChar.sendMessage(this.getName() + " castle tax changed to " + taxPercent + "%.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaxPercent(int taxPercent) {
        this._taxPercent = taxPercent;
        this._taxRate = (double)this._taxPercent / 100.0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Update castle set taxPercent = ? where id = ?");
            statement.setInt(1, taxPercent);
            statement.setInt(2, this.getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void spawnDoor() {
        this.spawnDoor(false);
    }

    public void spawnDoor(boolean isDoorWeak) {
        for (int i = 0; i < this.getDoors().size(); ++i) {
            L2DoorInstance door = this.getDoors().get(i);
            if (door.getCurrentHp() <= 0.0) {
                door.decayMe();
                door = DoorTable.parseList(this._doorDefault.get(i), false);
                DoorTable.getInstance().putDoor(door);
                if (isDoorWeak) {
                    door.setCurrentHp(door.getMaxHp() / 2);
                }
                door.spawnMe(door.getX(), door.getY(), door.getZ());
                this.getDoors().set(i, door);
                continue;
            }
            if (!door.getOpen()) continue;
            door.closeMe();
        }
        this.loadDoorUpgrade();
    }

    public void upgradeDoor(int doorId, int hp, int pDef, int mDef) {
        L2DoorInstance door = this.getDoor(doorId);
        if (door == null) {
            return;
        }
        door.setCurrentHp(door.getMaxHp() + hp);
        this.saveDoorUpgrade(doorId, hp, pDef, mDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT castle.*,castlename_ja.name AS castleName,castlename_ja.locName FROM castle LEFT JOIN castlename_ja ON castle.id=castlename_ja.id WHERE castle.id = ?");
            statement.setInt(1, this.getCastleId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._name = rs.getString("name");
                this._castleName = rs.getString("castleName");
                this._locName = rs.getString("locName").intern();
                this._siegeDate = Calendar.getInstance();
                this._siegeDate.setTimeInMillis(rs.getLong("siegeDate"));
                this._siegeTimeRegistrationEndDate = Calendar.getInstance();
                this._siegeTimeRegistrationEndDate.setTimeInMillis(rs.getLong("regTimeEnd"));
                this._isTimeRegistrationOver = rs.getBoolean("regTimeOver");
                this._taxPercent = rs.getInt("taxPercent");
                this._treasury = rs.getLong("treasury");
                this._showNpcCrest = rs.getBoolean("showNpcCrest");
                this._bloodAlliance = rs.getInt("bloodAlliance");
            }
            rs.close();
            statement.close();
            this._taxRate = (double)this._taxPercent / 100.0;
            statement = con.prepareStatement("Select clan_id from clan_data where hasCastle = ?");
            statement.setInt(1, this.getCastleId());
            rs = statement.executeQuery();
            while (rs.next()) {
                this._ownerId = rs.getInt("clan_id");
            }
            if (this.getOwnerId() > 0) {
                L2Clan clan = ClanTable.getInstance().getClan(this.getOwnerId());
                ThreadPoolManager.getInstance().scheduleGeneral(new CastleUpdater(clan, 1), 3600000L);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleData(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctions() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from castle_functions where castle_id = ?");
            statement.setInt(1, this.getCastleId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._function.put(rs.getInt("type"), new CastleFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Castle.loadFunctions(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(int functionType) {
        this._function.remove(functionType);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM castle_functions WHERE castle_id=? AND type=?");
            statement.setInt(1, this.getCastleId());
            statement.setInt(2, functionType);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Castle.removeFunctions(int functionType): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning("Called Castle.updateFunctions(int type, int lvl, int lease, long rate, boolean addNew) Owner : " + this.getOwnerId());
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._function.put(type, new CastleFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - this._function.get(type).getLease();
            if (Config.DEBUG) {
                _log.warning("Called Castle.updateFunctions diffLease : " + diffLease);
            }
            if (diffLease > 0) {
                this._function.remove(type);
                this._function.put(type, new CastleFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                this._function.get(type).setLease(lease);
                this._function.get(type).setLvl(lvl);
                this._function.get(type).dbSave();
            }
        }
        return true;
    }

    public void activateInstance() {
        for (L2DoorInstance door : this._doors) {
            door.spawnMe(door.getX(), door.getY(), door.getZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoor() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from castle_door where castleId = ?");
            statement.setInt(1, this.getCastleId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._doorDefault.add(rs.getString("name") + ";" + rs.getInt("id") + ";" + rs.getInt("x") + ";" + rs.getInt("y") + ";" + rs.getInt("z") + ";" + rs.getInt("range_xmin") + ";" + rs.getInt("range_ymin") + ";" + rs.getInt("range_zmin") + ";" + rs.getInt("range_xmax") + ";" + rs.getInt("range_ymax") + ";" + rs.getInt("range_zmax") + ";" + rs.getInt("hp") + ";" + rs.getInt("pDef") + ";" + rs.getInt("mDef") + ";0");
                L2DoorInstance door = DoorTable.parseList(this._doorDefault.get(this._doorDefault.size() - 1), false);
                door.setIsWall(rs.getBoolean("isWall"));
                this._doors.add(door);
                DoorTable.getInstance().putDoor(door);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleDoor(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoorUpgrade() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from castle_doorupgrade where doorId in (Select Id from castle_door where castleId = ?)");
            statement.setInt(1, this.getCastleId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.upgradeDoor(rs.getInt("id"), rs.getInt("hp"), rs.getInt("pDef"), rs.getInt("mDef"));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleDoorUpgrade(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDoorUpgrade() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("delete from castle_doorupgrade where doorId in (select id from castle_door where castleId=?)");
            statement.setInt(1, this.getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeDoorUpgrade(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDoorUpgrade(int doorId, int hp, int pDef, int mDef) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO castle_doorupgrade (doorId, hp, pDef, mDef) values (?,?,?,?)");
            statement.setInt(1, doorId);
            statement.setInt(2, hp);
            statement.setInt(3, pDef);
            statement.setInt(4, mDef);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveDoorUpgrade(int doorId, int hp, int pDef, int mDef): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOwnerInDB(L2Clan clan) {
        if (clan != null) {
            this._ownerId = clan.getClanId();
        } else {
            this._ownerId = 0;
            this.resetManor();
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clan_data SET hasCastle=0 WHERE hasCastle=?");
            statement.setInt(1, this.getCastleId());
            statement.execute();
            statement.close();
            statement = con.prepareStatement("UPDATE clan_data SET hasCastle=? WHERE clan_id=?");
            statement.setInt(1, this.getCastleId());
            statement.setInt(2, this.getOwnerId());
            statement.execute();
            statement.close();
            if (clan != null) {
                clan.setHasCastle(this.getCastleId());
                clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
                clan.broadcastToOnlineMembers(new PlaySound(1, "Siege_Victory", 0, 0, 0, 0, 0));
                ThreadPoolManager.getInstance().scheduleGeneral(new CastleUpdater(clan, 1), 3600000L);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: updateOwnerInDB(L2Clan clan): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final int getCastleId() {
        return this._castleId;
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getDoorId() != doorId) continue;
            return door;
        }
        return null;
    }

    public final List<L2DoorInstance> getDoors() {
        return this._doors;
    }

    public final String getName() {
        return this._name;
    }

    public final String getCastleName() {
        return this._castleName;
    }

    public final String getLocName() {
        return this._locName;
    }

    public final String getCastleNameHtm() {
        return "&%" + this._castleId + ";";
    }

    public final String getLocNameHtm() {
        return "&^" + this._castleId + ";";
    }

    public final int getOwnerId() {
        return this._ownerId;
    }

    public final Siege getSiege() {
        if (this._siege == null) {
            this._siege = new Siege(new Castle[]{this});
        }
        return this._siege;
    }

    public final Calendar getSiegeDate() {
        return this._siegeDate;
    }

    public boolean getIsTimeRegistrationOver() {
        return this._isTimeRegistrationOver;
    }

    public void setIsTimeRegistrationOver(boolean val) {
        this._isTimeRegistrationOver = val;
    }

    public Calendar getTimeRegistrationOverDate() {
        if (this._siegeTimeRegistrationEndDate == null) {
            this._siegeTimeRegistrationEndDate = Calendar.getInstance();
        }
        return this._siegeTimeRegistrationEndDate;
    }

    public final int getTaxPercent() {
        return this._taxPercent;
    }

    public final double getTaxRate() {
        return this._taxRate;
    }

    public final long getTreasury() {
        return this._treasury;
    }

    public final boolean getShowNpcCrest() {
        return this._showNpcCrest;
    }

    public final void setShowNpcCrest(boolean showNpcCrest) {
        if (this._showNpcCrest != showNpcCrest) {
            this._showNpcCrest = showNpcCrest;
            this.updateShowNpcCrest();
        }
    }

    public List<CastleManorManager.SeedProduction> getSeedProduction(int period) {
        return period == 0 ? this._production : this._productionNext;
    }

    public List<CastleManorManager.CropProcure> getCropProcure(int period) {
        return period == 0 ? this._procure : this._procureNext;
    }

    public void setSeedProduction(List<CastleManorManager.SeedProduction> seed, int period) {
        if (period == 0) {
            this._production = seed;
        } else {
            this._productionNext = seed;
        }
    }

    public void setCropProcure(List<CastleManorManager.CropProcure> crop, int period) {
        if (period == 0) {
            this._procure = crop;
        } else {
            this._procureNext = crop;
        }
    }

    public CastleManorManager.SeedProduction getSeed(int seedId, int period) {
        for (CastleManorManager.SeedProduction seed : this.getSeedProduction(period)) {
            if (seed.getId() != seedId) continue;
            return seed;
        }
        return null;
    }

    public CastleManorManager.CropProcure getCrop(int cropId, int period) {
        for (CastleManorManager.CropProcure crop : this.getCropProcure(period)) {
            if (crop.getId() != cropId) continue;
            return crop;
        }
        return null;
    }

    public long getManorCost(int period) {
        List<CastleManorManager.SeedProduction> production;
        List<CastleManorManager.CropProcure> procure;
        if (period == 0) {
            procure = this._procure;
            production = this._production;
        } else {
            procure = this._procureNext;
            production = this._productionNext;
        }
        long total = 0L;
        if (production != null) {
            for (CastleManorManager.SeedProduction seed : production) {
                total += L2Manor.getInstance().getSeedBuyPrice(seed.getId()) * seed.getStartProduce();
            }
        }
        if (procure != null) {
            for (CastleManorManager.CropProcure crop : procure) {
                total += crop.getPrice() * crop.getStartAmount();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSeedData() {
        Connection con = null;
        try {
            String[] values;
            StringBuilder query;
            int count;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_MANOR_DELETE_PRODUCTION);
            statement.setInt(1, this.getCastleId());
            statement.execute();
            statement.close();
            if (this._production != null) {
                count = 0;
                query = new StringBuilder(256).append("INSERT INTO castle_manor_production VALUES ");
                values = new String[this._production.size()];
                for (CastleManorManager.SeedProduction s : this._production) {
                    values[count++] = "(" + this.getCastleId() + "," + s.getId() + "," + s.getCanProduce() + "," + s.getStartProduce() + "," + s.getPrice() + "," + 0 + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
            if (this._productionNext != null) {
                count = 0;
                query = new StringBuilder(256).append("INSERT INTO castle_manor_production VALUES ");
                values = new String[this._productionNext.size()];
                for (CastleManorManager.SeedProduction s : this._productionNext) {
                    values[count++] = "(" + this.getCastleId() + "," + s.getId() + "," + s.getCanProduce() + "," + s.getStartProduce() + "," + s.getPrice() + "," + 1 + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            _log.info("Error adding seed production data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSeedData(int period) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_MANOR_DELETE_PRODUCTION_PERIOD);
            statement.setInt(1, this.getCastleId());
            statement.setInt(2, period);
            statement.execute();
            statement.close();
            List<CastleManorManager.SeedProduction> prod = null;
            prod = this.getSeedProduction(period);
            if (prod != null) {
                int count = 0;
                StringBuilder query = new StringBuilder(256).append("INSERT INTO castle_manor_production VALUES ");
                String[] values = new String[prod.size()];
                for (CastleManorManager.SeedProduction s : prod) {
                    values[count++] = "(" + this.getCastleId() + "," + s.getId() + "," + s.getCanProduce() + "," + s.getStartProduce() + "," + s.getPrice() + "," + period + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            _log.info("Error adding seed production data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCropData() {
        Connection con = null;
        try {
            String[] values;
            StringBuilder query;
            int count;
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_MANOR_DELETE_PROCURE);
            statement.setInt(1, this.getCastleId());
            statement.execute();
            statement.close();
            if (this._procure != null && this._procure.size() > 0) {
                count = 0;
                query = new StringBuilder(256).append("INSERT INTO castle_manor_procure VALUES ");
                values = new String[this._procure.size()];
                for (CastleManorManager.CropProcure cp : this._procure) {
                    values[count++] = "(" + this.getCastleId() + "," + cp.getId() + "," + cp.getAmount() + "," + cp.getStartAmount() + "," + cp.getPrice() + "," + cp.getReward() + "," + 0 + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
            if (this._procureNext != null && this._procureNext.size() > 0) {
                count = 0;
                query = new StringBuilder(256).append("INSERT INTO castle_manor_procure VALUES ");
                values = new String[this._procureNext.size()];
                for (CastleManorManager.CropProcure cp : this._procureNext) {
                    values[count++] = "(" + this.getCastleId() + "," + cp.getId() + "," + cp.getAmount() + "," + cp.getStartAmount() + "," + cp.getPrice() + "," + cp.getReward() + "," + 1 + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            _log.info("Error adding crop data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCropData(int period) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_MANOR_DELETE_PROCURE_PERIOD);
            statement.setInt(1, this.getCastleId());
            statement.setInt(2, period);
            statement.execute();
            statement.close();
            List<CastleManorManager.CropProcure> proc = null;
            proc = this.getCropProcure(period);
            if (proc != null && proc.size() > 0) {
                int count = 0;
                StringBuilder query = new StringBuilder(256).append("INSERT INTO castle_manor_procure VALUES ");
                String[] values = new String[proc.size()];
                for (CastleManorManager.CropProcure cp : proc) {
                    values[count++] = "(" + this.getCastleId() + "," + cp.getId() + "," + cp.getAmount() + "," + cp.getStartAmount() + "," + cp.getPrice() + "," + cp.getReward() + "," + period + ")";
                }
                if (values.length > 0) {
                    query.append(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        query.append(',').append(values[i]);
                    }
                    statement = con.prepareStatement(query.toString());
                    statement.execute();
                    statement.close();
                }
            }
        }
        catch (Exception e) {
            _log.info("Error adding crop data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCrop(int cropId, long amount, int period) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_UPDATE_CROP);
            statement.setLong(1, amount);
            statement.setInt(2, cropId);
            statement.setInt(3, this.getCastleId());
            statement.setInt(4, period);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.info("Error adding crop data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSeed(int seedId, long amount, int period) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(CASTLE_UPDATE_SEED);
            statement.setLong(1, amount);
            statement.setInt(2, seedId);
            statement.setInt(3, this.getCastleId());
            statement.setInt(4, period);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.info("Error adding seed production data for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean isNextPeriodApproved() {
        return this._isNextPeriodApproved;
    }

    public void setNextPeriodApproved(boolean val) {
        this._isNextPeriodApproved = val;
    }

    public void updateClansReputation() {
        if (this._formerOwner != null) {
            if (this._formerOwner != ClanTable.getInstance().getClan(this.getOwnerId())) {
                int maxreward = Math.max(0, this._formerOwner.getReputationScore());
                this._formerOwner.takeReputationScore(Config.LOOSE_CASTLE_POINTS, true);
                L2Clan owner = ClanTable.getInstance().getClan(this.getOwnerId());
                if (owner != null) {
                    owner.addReputationScore(Math.min(Config.TAKE_CASTLE_POINTS, maxreward), true);
                }
            } else {
                this._formerOwner.addReputationScore(Config.CASTLE_DEFENDED_POINTS, true);
            }
        } else {
            L2Clan owner = ClanTable.getInstance().getClan(this.getOwnerId());
            if (owner != null) {
                owner.addReputationScore(Config.TAKE_CASTLE_POINTS, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShowNpcCrest() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE castle SET showNpcCrest = ? WHERE id = ?");
            statement.setString(1, String.valueOf(this.getShowNpcCrest()));
            statement.setInt(2, this.getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.info("Error saving showNpcCrest for castle " + this.getName() + ": " + e.getMessage());
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public FastList<L2Skill> getResidentialSkills() {
        return this._residentialSkills;
    }

    public void giveResidentialSkills(L2PcInstance player) {
        TerritoryWarManager.Territory territory;
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (L2Skill sk : this._residentialSkills) {
                player.addSkill(sk, false);
            }
        }
        if ((territory = TerritoryWarManager.getInstance().getTerritory(this.getCastleId())) != null && territory.getOwnedWardIds().contains((Object)(this.getCastleId() + 80))) {
            Iterator i$ = territory.getOwnedWardIds().iterator();
            while (i$.hasNext()) {
                int wardId = (Integer)i$.next();
                FastList<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                for (L2SkillLearn s : territorySkills) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                    if (sk != null) {
                        player.addSkill(sk, false);
                        continue;
                    }
                    _log.warning("Trying to add a null skill for Territory Ward Id: " + wardId + ", skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
                }
            }
        }
    }

    public void removeResidentialSkills(L2PcInstance player) {
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (L2Skill sk : this._residentialSkills) {
                player.removeSkill(sk, false, true);
            }
        }
        if (TerritoryWarManager.getInstance().getTerritory(this.getCastleId()) != null) {
            Iterator i$ = TerritoryWarManager.getInstance().getTerritory(this.getCastleId()).getOwnedWardIds().iterator();
            while (i$.hasNext()) {
                int wardId = (Integer)i$.next();
                FastList<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                for (L2SkillLearn s : territorySkills) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
                    if (sk != null) {
                        player.removeSkill(sk, false, true);
                        continue;
                    }
                    _log.warning("Trying to remove a null skill for Territory Ward Id: " + wardId + ", skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
                }
            }
        }
    }

    public void registerArtefact(L2ArtefactInstance artefact) {
        if (Config.DEBUG) {
            _log.info("ArtefactId: " + artefact.getObjectId() + " is registered to " + this.getName() + " castle.");
        }
        this._artefacts.add(artefact);
    }

    public List<L2ArtefactInstance> getArtefacts() {
        return this._artefacts;
    }

    public void resetManor() {
        this.setCropProcure((List<CastleManorManager.CropProcure>)new FastList(), 0);
        this.setCropProcure((List<CastleManorManager.CropProcure>)new FastList(), 1);
        this.setSeedProduction((List<CastleManorManager.SeedProduction>)new FastList(), 0);
        this.setSeedProduction((List<CastleManorManager.SeedProduction>)new FastList(), 1);
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            this.saveCropData();
            this.saveSeedData();
        }
    }

    public int getBloodAlliance() {
        return this._bloodAlliance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBloodAlliance(int count) {
        this._bloodAlliance = count;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Update castle set bloodAlliance = ? where id = ?");
            statement.setInt(1, this._bloodAlliance);
            statement.setInt(2, this.getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public class CastleFunction {
        private int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public CastleFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (Castle.this.getOwnerId() <= 0) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbSave() {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("REPLACE INTO castle_functions (castle_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");
                statement.setInt(1, Castle.this.getCastleId());
                statement.setInt(2, this.getType());
                statement.setInt(3, this.getLvl());
                statement.setInt(4, this.getLease());
                statement.setLong(5, this.getRate());
                statement.setLong(6, this.getEndTime());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception: Castle.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                CastleFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (Castle.this.getOwnerId() <= 0) {
                        return;
                    }
                    if (ClanTable.getInstance().getClan(Castle.this.getOwnerId()).getWarehouse().getAdena() >= (long)CastleFunction.this._fee || !CastleFunction.this._cwh) {
                        int fee = CastleFunction.this._fee;
                        if (CastleFunction.this.getEndTime() == -1L) {
                            fee = CastleFunction.this._tempFee;
                        }
                        CastleFunction.this.setEndTime(System.currentTimeMillis() + CastleFunction.this.getRate());
                        CastleFunction.this.dbSave();
                        if (CastleFunction.this._cwh) {
                            ClanTable.getInstance().getClan(Castle.this.getOwnerId()).getWarehouse().destroyItemByItemId("CS_function_fee", 57, fee, null, null);
                            if (Config.DEBUG) {
                                _log.warning("deducted " + fee + " adena from " + Castle.this.getName() + " owner's cwh for function id : " + CastleFunction.this.getType());
                            }
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), CastleFunction.this.getRate());
                    } else {
                        Castle.this.removeFunction(CastleFunction.this.getType());
                    }
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

