/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.FortUpdater;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.StaticObjects;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Fort {
    protected static final Logger _log = Logger.getLogger(Fort.class.getName());
    private int _fortId = 0;
    private List<L2DoorInstance> _doors = new FastList();
    private L2StaticObjectInstance _flagPole = null;
    private List<String> _doorDefault = new FastList();
    private List<String> _flagPoleStats = new FastList();
    private String _name = "";
    private String _fortName;
    private String _fortNameShort;
    private FortSiege _siege = null;
    private Calendar _siegeDate;
    private Calendar _lastOwnedTime;
    private L2FortZone _fortZone;
    private L2SiegeZone _zone;
    private L2Clan _fortOwner = null;
    private int _fortType = 0;
    private int _state = 0;
    private int _castleId = 0;
    private int _blood = 0;
    private int _supplyLvL = 0;
    private FastMap<Integer, FortFunction> _function;
    private FastList<L2Skill> _residentialSkills = new FastList();
    private ScheduledFuture<?>[] _FortUpdater = new ScheduledFuture[2];
    private boolean _isSuspiciousMerchantSpawned = false;
    private FastList<L2Spawn> _siegeNpcs = new FastList();
    private FastList<L2Spawn> _npcCommanders = new FastList();
    private FastList<L2Spawn> _specialEnvoys = new FastList();
    private TIntIntHashMap _envoyCastles = new TIntIntHashMap(2);
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_RESTORE_HP = 2;
    public static final int FUNC_RESTORE_MP = 3;
    public static final int FUNC_RESTORE_EXP = 4;
    public static final int FUNC_SUPPORT = 5;

    public Fort(int fortId) {
        this._fortId = fortId;
        this.load();
        this.loadDoor();
        this.loadFlagPoles();
        this._function = new FastMap();
        FastList<L2SkillLearn> residentialSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(fortId);
        for (L2SkillLearn s : residentialSkills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getSkillId(), s.getSkillLevel());
            if (sk != null) {
                this._residentialSkills.add((Object)sk);
                continue;
            }
            _log.warning("Fort Id: " + fortId + " has a null residential skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
        }
        if (this.getOwnerClan() != null) {
            this.setVisibleFlag(true);
            this.loadFunctions();
        }
        this.initNpcs();
        this.initSiegeNpcs();
        this.initNpcCommanders();
        this.spawnNpcCommanders();
        this.initSpecialEnvoys();
        if (this.getOwnerClan() != null && this.getFortState() == 0) {
            this.spawnSpecialEnvoys();
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSpecialEnvoysDeSpawn(this), 3600000L);
        }
    }

    public FortFunction getFunction(int type) {
        if (this._function.get((Object)type) != null) {
            return (FortFunction)this._function.get((Object)type);
        }
        return null;
    }

    public void endOfSiege(L2Clan clan) {
        ThreadPoolManager.getInstance().scheduleGeneral(new endFortressSiege(this, clan), 1000L);
    }

    public void engrave(L2Clan clan) {
        this.setOwner(clan, true);
    }

    public void banishForeigners() {
        this.getFortZone().banishForeigners(this.getOwnerClan());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2SiegeZone getZone() {
        if (this._zone == null) {
            for (L2SiegeZone zone : ZoneManager.getInstance().getAllZones(L2SiegeZone.class)) {
                if (zone.getSiegeObjectId() != this.getFortId()) continue;
                this._zone = zone;
                break;
            }
        }
        return this._zone;
    }

    public L2FortZone getFortZone() {
        if (this._fortZone == null) {
            for (L2FortZone zone : ZoneManager.getInstance().getAllZones(L2FortZone.class)) {
                if (zone.getFortId() != this.getFortId()) continue;
                this._fortZone = zone;
                break;
            }
        }
        return this._fortZone;
    }

    public double getDistance(L2Object obj) {
        return this.getZone().getDistanceToZone(obj);
    }

    public void closeDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, false);
    }

    public void openDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, true);
    }

    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar.getClan() != this.getOwnerClan()) {
            return;
        }
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    public void removeUpgrade() {
        this.removeDoorUpgrade();
    }

    public boolean setOwner(L2Clan clan, boolean updateClansReputation) {
        L2Clan oldowner = this.getOwnerClan();
        if (oldowner != null && clan != null && clan != oldowner) {
            this.updateClansReputation(oldowner, true);
            try {
                L2PcInstance oldleader = oldowner.getLeader().getPlayerInstance();
                if (oldleader != null && oldleader.getMountType() == 2) {
                    oldleader.dismount();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception in setOwner: " + e.getMessage(), e);
            }
            this.removeOwner(true);
        }
        this.setFortState(0, 0);
        if (clan.getHasCastle() > 0) {
            this.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.NPCS_RECAPTURED_FORTRESS));
            return false;
        }
        if (updateClansReputation) {
            this.updateClansReputation(clan, false);
        }
        this.spawnSpecialEnvoys();
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSpecialEnvoysDeSpawn(this), 3600000L);
        if (clan.getHasFort() > 0) {
            FortManager.getInstance().getFortByOwner(clan).removeOwner(true);
        }
        this.setBloodOathReward(0);
        this.setSupplyLvL(0);
        this.setOwnerClan(clan);
        this.updateOwnerInDB();
        this.saveFortVariables();
        if (this.getSiege().getIsInProgress()) {
            this.getSiege().endSiege();
        }
        for (L2PcInstance member : clan.getOnlineMembers(0)) {
            this.giveResidentialSkills(member);
            member.sendSkillList();
        }
        return true;
    }

    public void removeOwner(boolean updateDB) {
        L2Clan clan = this.getOwnerClan();
        if (clan != null) {
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
            clan.setHasFort(0);
            clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
            this.setOwnerClan(null);
            this.setBloodOathReward(0);
            this.setSupplyLvL(0);
            this.saveFortVariables();
            this.removeAllFunctions();
            if (updateDB) {
                this.updateOwnerInDB();
            }
        }
    }

    public void setBloodOathReward(int val) {
        this._blood = val;
    }

    public int getBloodOathReward() {
        return this._blood;
    }

    public void raiseSupplyLvL() {
        ++this._supplyLvL;
        if (this._supplyLvL > Config.FS_MAX_SUPPLY_LEVEL) {
            this._supplyLvL = Config.FS_MAX_SUPPLY_LEVEL;
        }
    }

    public void setSupplyLvL(int val) {
        if (val <= Config.FS_MAX_SUPPLY_LEVEL) {
            this._supplyLvL = val;
        }
    }

    public int getSupplyLvL() {
        return this._supplyLvL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFortVariables() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE fort SET blood=?, supplyLvL=? WHERE id = ?");
            statement.setInt(1, this._blood);
            statement.setInt(2, this._supplyLvL);
            statement.setInt(3, this.getFortId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveFortVariables(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void setVisibleFlag(boolean val) {
        L2StaticObjectInstance flagPole = this.getFlagPole();
        if (flagPole != null) {
            flagPole.setMeshIndex(val ? 1 : 0);
        }
    }

    public void resetDoors() {
        for (int i = 0; i < this.getDoors().size(); ++i) {
            L2DoorInstance door = this.getDoors().get(i);
            if (door.getOpen()) {
                door.closeMe();
            }
            if (door.getCurrentHp() <= 0.0) {
                door.doRevive();
            }
            if (!(door.getCurrentHp() < (double)door.getMaxHp())) continue;
            door.setCurrentHp(door.getMaxHp());
        }
        this.loadDoorUpgrade();
    }

    public void upgradeDoor(int doorId, int hp, int pDef, int mDef) {
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null && door.getDoorId() == doorId) {
            door.setCurrentHp(door.getMaxHp() + hp);
            this.saveDoorUpgrade(doorId, hp, pDef, mDef);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT fort.*,castlename_ja.name AS fortName,fortname_ja.nameJA FROM fort LEFT JOIN castlename_ja ON fort.id=castlename_ja.id LEFT JOIN fortname_ja ON fort.id=fortname_ja.id WHERE fort.id=?");
            statement.setInt(1, this.getFortId());
            ResultSet rs = statement.executeQuery();
            int ownerId = 0;
            while (rs.next()) {
                this._name = rs.getString("name");
                this._fortName = rs.getString("fortName");
                if (this._fortName.length() == 0) {
                    this._fortName = this._name;
                }
                this._fortNameShort = rs.getString("nameJA");
                if (this._fortNameShort.length() == 0) {
                    this._fortNameShort = this._name;
                }
                this._siegeDate = Calendar.getInstance();
                this._lastOwnedTime = Calendar.getInstance();
                this._siegeDate.setTimeInMillis(rs.getLong("siegeDate"));
                this._lastOwnedTime.setTimeInMillis(rs.getLong("lastOwnedTime"));
                ownerId = rs.getInt("owner");
                this._fortType = rs.getInt("fortType");
                this._state = rs.getInt("state");
                this._castleId = rs.getInt("castleId");
                this._blood = rs.getInt("blood");
                this._supplyLvL = rs.getInt("supplyLvL");
            }
            rs.close();
            statement.close();
            if (ownerId > 0) {
                long initial;
                L2Clan clan = ClanTable.getInstance().getClan(ownerId);
                clan.setHasFort(this.getFortId());
                this.setOwnerClan(clan);
                int runCount = this.getOwnedTime() / (Config.FS_UPDATE_FRQ * 60);
                for (initial = System.currentTimeMillis() - this._lastOwnedTime.getTimeInMillis(); initial > (long)Config.FS_UPDATE_FRQ * 60000L; initial -= (long)Config.FS_UPDATE_FRQ * 60000L) {
                }
                initial = (long)Config.FS_UPDATE_FRQ * 60000L - initial;
                if (Config.FS_MAX_OWN_TIME <= 0 || this.getOwnedTime() < Config.FS_MAX_OWN_TIME * 3600) {
                    this._FortUpdater[0] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, runCount, FortUpdater.UpdaterType.PERIODIC_UPDATE), initial, (long)Config.FS_UPDATE_FRQ * 60000L);
                    if (Config.FS_MAX_OWN_TIME > 0) {
                        this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, runCount, FortUpdater.UpdaterType.MAX_OWN_TIME), 3600000L, 3600000L);
                    }
                } else {
                    this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneral(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.MAX_OWN_TIME), 60000L);
                }
            } else {
                this.setOwnerClan(null);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFortData(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctions() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_functions WHERE fort_id = ?");
            statement.setInt(1, this.getFortId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._function.put((Object)rs.getInt("type"), (Object)new FortFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Fort.loadFunctions(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(int functionType) {
        this._function.remove((Object)functionType);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM fort_functions WHERE fort_id=? AND type=?");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, functionType);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Fort.removeFunctions(int functionType): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void removeAllFunctions() {
        Iterator i$ = this._function.keySet().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            this.removeFunction(id);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning("Called Fort.updateFunctions(int type, int lvl, int lease, long rate, boolean addNew) Owner : " + this.getOwnerClan());
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._function.put((Object)type, (Object)new FortFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - ((FortFunction)this._function.get((Object)type)).getLease();
            if (Config.DEBUG) {
                _log.warning("Called Fort.updateFunctions diffLease : " + diffLease);
            }
            if (diffLease > 0) {
                this._function.remove((Object)type);
                this._function.put((Object)type, (Object)new FortFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                ((FortFunction)this._function.get((Object)type)).setLease(lease);
                ((FortFunction)this._function.get((Object)type)).setLvl(lvl);
                ((FortFunction)this._function.get((Object)type)).dbSave();
            }
        }
        return true;
    }

    public void activateInstance() {
        for (L2DoorInstance door : this._doors) {
            door.spawnMe(door.getX(), door.getY(), door.getZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoor() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_staticobjects WHERE fortId = ? AND objectType = ?");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 0);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._doorDefault.add(rs.getString("name") + ";" + rs.getInt("id") + ";" + rs.getInt("x") + ";" + rs.getInt("y") + ";" + rs.getInt("z") + ";" + rs.getInt("range_xmin") + ";" + rs.getInt("range_ymin") + ";" + rs.getInt("range_zmin") + ";" + rs.getInt("range_xmax") + ";" + rs.getInt("range_ymax") + ";" + rs.getInt("range_zmax") + ";" + rs.getInt("hp") + ";" + rs.getInt("pDef") + ";" + rs.getInt("mDef") + ";0;" + rs.getBoolean("openType") + ";" + rs.getBoolean("commanderDoor"));
                L2DoorInstance door = DoorTable.parseList(this._doorDefault.get(this._doorDefault.size() - 1), true);
                this._doors.add(door);
                DoorTable.getInstance().putDoor(door);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFortDoor(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFlagPoles() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_staticobjects WHERE fortId = ? AND objectType = ?");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 1);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._flagPoleStats.add(rs.getString("name") + ";" + rs.getInt("id") + ";" + rs.getInt("x") + ";" + rs.getInt("y") + ";" + rs.getInt("z") + ";3;none;0;0");
                this._flagPole = StaticObjects.parse(this._flagPoleStats.get(this._flagPoleStats.size() - 1));
                StaticObjects.getInstance().putObject(this._flagPole);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFlagPoles(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDoorUpgrade() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_doorupgrade WHERE doorId IN (SELECT Id FROM fort_staticobjects WHERE fortId = ? AND objectType = ?)");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 0);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.upgradeDoor(rs.getInt("id"), rs.getInt("hp"), rs.getInt("pDef"), rs.getInt("mDef"));
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFortDoorUpgrade(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDoorUpgrade() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM fort_doorupgrade WHERE doorId IN (SELECT id FROM fort_staticobjects WHERE fortId=? AND objectType = ?)");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 0);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeDoorUpgrade(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDoorUpgrade(int doorId, int hp, int pDef, int mDef) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO fort_doorupgrade (doorId, hp, pDef, mDef) VALUES (?,?,?,?)");
            statement.setInt(1, doorId);
            statement.setInt(2, hp);
            statement.setInt(3, pDef);
            statement.setInt(4, mDef);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveDoorUpgrade(int doorId, int hp, int pDef, int mDef): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOwnerInDB() {
        L2Clan clan = this.getOwnerClan();
        int clanId = 0;
        if (clan != null) {
            clanId = clan.getClanId();
            this._lastOwnedTime.setTimeInMillis(System.currentTimeMillis());
        } else {
            this._lastOwnedTime.setTimeInMillis(0L);
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE fort SET owner=?,lastOwnedTime=?,state=?,castleId=?,blood=? WHERE id = ?");
            statement.setInt(1, clanId);
            statement.setLong(2, this._lastOwnedTime.getTimeInMillis());
            statement.setInt(3, 0);
            statement.setInt(4, 0);
            statement.setInt(5, this.getBloodOathReward());
            statement.setInt(6, this.getFortId());
            statement.execute();
            statement.close();
            if (clan != null) {
                clan.setHasFort(this.getFortId());
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CLAN_IS_VICTORIOUS_IN_THE_FORTRESS_BATTLE_OF_S2);
                sm.addString(clan.getName());
                sm.addFortId(this.getFortId());
                Collection<L2PcInstance> pls = L2World.getInstance().getAllPlayers().values();
                for (L2PcInstance player : pls) {
                    player.sendPacket(sm);
                }
                clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
                clan.broadcastToOnlineMembers(new PlaySound(1, "Siege_Victory", 0, 0, 0, 0, 0));
                if (this._FortUpdater[0] != null) {
                    this._FortUpdater[0].cancel(false);
                }
                if (this._FortUpdater[1] != null) {
                    this._FortUpdater[1].cancel(false);
                }
                this._FortUpdater[0] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.PERIODIC_UPDATE), (long)Config.FS_UPDATE_FRQ * 60000L, (long)Config.FS_UPDATE_FRQ * 60000L);
                if (Config.FS_MAX_OWN_TIME > 0) {
                    this._FortUpdater[1] = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FortUpdater(this, clan, 0, FortUpdater.UpdaterType.MAX_OWN_TIME), 3600000L, 3600000L);
                }
            } else {
                if (this._FortUpdater[0] != null) {
                    this._FortUpdater[0].cancel(false);
                }
                this._FortUpdater[0] = null;
                if (this._FortUpdater[1] != null) {
                    this._FortUpdater[1].cancel(false);
                }
                this._FortUpdater[1] = null;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: updateOwnerInDB(L2Clan clan): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final int getFortId() {
        return this._fortId;
    }

    public final L2Clan getOwnerClan() {
        return this._fortOwner;
    }

    public final void setOwnerClan(L2Clan clan) {
        this.setVisibleFlag(clan != null);
        this._fortOwner = clan;
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getDoorId() != doorId) continue;
            return door;
        }
        return null;
    }

    public final List<L2DoorInstance> getDoors() {
        return this._doors;
    }

    public final L2StaticObjectInstance getFlagPole() {
        return this._flagPole;
    }

    public final FortSiege getSiege() {
        if (this._siege == null) {
            this._siege = new FortSiege(this);
        }
        return this._siege;
    }

    public final Calendar getSiegeDate() {
        return this._siegeDate;
    }

    public final void setSiegeDate(Calendar siegeDate) {
        this._siegeDate = siegeDate;
    }

    public final int getOwnedTime() {
        if (this._lastOwnedTime.getTimeInMillis() == 0L) {
            return 0;
        }
        return (int)((System.currentTimeMillis() - this._lastOwnedTime.getTimeInMillis()) / 1000L);
    }

    public final int getTimeTillRebelArmy() {
        if (this._lastOwnedTime.getTimeInMillis() == 0L) {
            return 0;
        }
        return (int)((this._lastOwnedTime.getTimeInMillis() + (long)Config.FS_MAX_OWN_TIME * 3600000L - System.currentTimeMillis()) / 1000L);
    }

    public final long getTimeTillNextFortUpdate() {
        if (this._FortUpdater[0] == null) {
            return 0L;
        }
        return this._FortUpdater[0].getDelay(TimeUnit.SECONDS);
    }

    public final String getName() {
        return this._name;
    }

    public final String getFortName() {
        return this._fortName;
    }

    public final String getFortNameShort() {
        return this._fortNameShort;
    }

    public final String getFortNameHtm() {
        return "&%" + this._fortId + ";";
    }

    public void updateClansReputation(L2Clan owner, boolean removePoints) {
        if (owner != null) {
            if (removePoints) {
                owner.takeReputationScore(Config.LOOSE_FORT_POINTS, true);
            } else {
                owner.addReputationScore(Config.TAKE_FORT_POINTS, true);
            }
        }
    }

    public final int getFortState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFortState(int state, int castleId) {
        this._state = state;
        this._castleId = castleId;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE fort SET state=?,castleId=? WHERE id = ?");
            statement.setInt(1, this.getFortState());
            statement.setInt(2, this.getCastleId());
            statement.setInt(3, this.getFortId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: setFortState(int state, int castleId): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final int getCastleId() {
        return this._castleId;
    }

    public final int getFortType() {
        return this._fortType;
    }

    public final int getCastleIdFromEnvoy(int npcId) {
        return this._envoyCastles.get(npcId);
    }

    public final int getFortSize() {
        return this.getFortType() == 0 ? 3 : 5;
    }

    public void spawnSuspiciousMerchant() {
        if (this._isSuspiciousMerchantSpawned) {
            return;
        }
        this._isSuspiciousMerchantSpawned = true;
        for (L2Spawn spawnDat : this._siegeNpcs) {
            spawnDat.doSpawn();
            spawnDat.startRespawn();
        }
    }

    public void despawnSuspiciousMerchant() {
        if (!this._isSuspiciousMerchantSpawned) {
            return;
        }
        this._isSuspiciousMerchantSpawned = false;
        for (L2Spawn spawnDat : this._siegeNpcs) {
            spawnDat.stopRespawn();
            spawnDat.getLastSpawn().deleteMe();
        }
    }

    public void spawnNpcCommanders() {
        for (L2Spawn spawnDat : this._npcCommanders) {
            spawnDat.doSpawn();
            spawnDat.startRespawn();
        }
    }

    public void despawnNpcCommanders() {
        for (L2Spawn spawnDat : this._npcCommanders) {
            spawnDat.stopRespawn();
            spawnDat.getLastSpawn().deleteMe();
        }
    }

    public void spawnSpecialEnvoys() {
        for (L2Spawn spawnDat : this._specialEnvoys) {
            spawnDat.doSpawn();
            spawnDat.startRespawn();
        }
    }

    public void despawnSpecialEnvoys() {
        for (L2Spawn spawnDat : this._specialEnvoys) {
            spawnDat.stopRespawn();
            spawnDat.getLastSpawn().deleteMe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNpcs() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 0);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(rset.getInt("npcId"));
                if (template != null) {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(rset.getInt("x"));
                    spawnDat.setLocy(rset.getInt("y"));
                    spawnDat.setLocz(rset.getInt("z"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    SpawnTable.getInstance().addNewSpawn(spawnDat, false);
                    spawnDat.doSpawn();
                    spawnDat.startRespawn();
                    continue;
                }
                _log.warning("Fort " + this.getFortId() + " initNpcs: Data missing in NPC table for ID: " + rset.getInt("npcId") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Fort " + this.getFortId() + " initNpcs: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSiegeNpcs() {
        Connection con = null;
        this._siegeNpcs.clear();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, npcId, x, y, z, heading FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 2);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(rset.getInt("npcId"));
                if (template != null) {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(rset.getInt("x"));
                    spawnDat.setLocy(rset.getInt("y"));
                    spawnDat.setLocz(rset.getInt("z"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._siegeNpcs.add((Object)spawnDat);
                    continue;
                }
                _log.warning("Fort " + this.getFortId() + " initSiegeNpcs: Data missing in NPC table for ID: " + rset.getInt("npcId") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Fort " + this.getFortId() + " initSiegeNpcs: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNpcCommanders() {
        Connection con = null;
        this._npcCommanders.clear();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, npcId, x, y, z, heading FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 1);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(rset.getInt("npcId"));
                if (template != null) {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(rset.getInt("x"));
                    spawnDat.setLocy(rset.getInt("y"));
                    spawnDat.setLocz(rset.getInt("z"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._npcCommanders.add((Object)spawnDat);
                    continue;
                }
                _log.warning("Fort " + this.getFortId() + " initNpcCommanders: Data missing in NPC table for ID: " + rset.getInt("npcId") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Fort " + this.getFortId() + " initNpcCommanders: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSpecialEnvoys() {
        Connection con = null;
        this._specialEnvoys.clear();
        this._envoyCastles.clear();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, npcId, x, y, z, heading, castleId FROM fort_spawnlist WHERE fortId = ? AND spawnType = ? ORDER BY id");
            statement.setInt(1, this.getFortId());
            statement.setInt(2, 3);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int castleId = rset.getInt("castleId");
                int npcId = rset.getInt("npcId");
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
                if (template != null) {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setLocx(rset.getInt("x"));
                    spawnDat.setLocy(rset.getInt("y"));
                    spawnDat.setLocz(rset.getInt("z"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(60);
                    this._specialEnvoys.add((Object)spawnDat);
                    this._envoyCastles.put(npcId, castleId);
                    continue;
                }
                _log.warning("Fort " + this.getFortId() + " initSpecialEnvoys: Data missing in NPC table for ID: " + rset.getInt("npcId") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Fort " + this.getFortId() + " initSpecialEnvoys: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public FastList<L2Skill> getResidentialSkills() {
        return this._residentialSkills;
    }

    public void giveResidentialSkills(L2PcInstance player) {
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (L2Skill sk : this._residentialSkills) {
                player.addSkill(sk, false);
            }
        }
    }

    public void removeResidentialSkills(L2PcInstance player) {
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (L2Skill sk : this._residentialSkills) {
                player.removeSkill(sk, false, true);
            }
        }
    }

    private static class endFortressSiege
    implements Runnable {
        private Fort _f;
        private L2Clan _clan;

        public endFortressSiege(Fort f, L2Clan clan) {
            this._f = f;
            this._clan = clan;
        }

        @Override
        public void run() {
            try {
                this._f.engrave(this._clan);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception in endFortressSiege " + e.getMessage(), e);
            }
        }
    }

    public static class ScheduleSpecialEnvoysDeSpawn
    implements Runnable {
        private Fort _fortInst;

        public ScheduleSpecialEnvoysDeSpawn(Fort pFort) {
            this._fortInst = pFort;
        }

        @Override
        public void run() {
            try {
                if (this._fortInst.getFortState() == 0) {
                    this._fortInst.setFortState(1, 0);
                }
                this._fortInst.despawnSpecialEnvoys();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleSpecialEnvoysSpawn() for Fort " + this._fortInst.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    public class FortFunction {
        private int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public FortFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (Fort.this.getOwnerClan() == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbSave() {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("REPLACE INTO fort_functions (fort_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");
                statement.setInt(1, Fort.this.getFortId());
                statement.setInt(2, this.getType());
                statement.setInt(3, this.getLvl());
                statement.setInt(4, this.getLease());
                statement.setLong(5, this.getRate());
                statement.setLong(6, this.getEndTime());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception: Fort.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                FortFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (Fort.this.getOwnerClan() == null) {
                        return;
                    }
                    if (Fort.this.getOwnerClan().getWarehouse().getAdena() >= (long)FortFunction.this._fee || !FortFunction.this._cwh) {
                        int fee = FortFunction.this._fee;
                        if (FortFunction.this.getEndTime() == -1L) {
                            fee = FortFunction.this._tempFee;
                        }
                        FortFunction.this.setEndTime(System.currentTimeMillis() + FortFunction.this.getRate());
                        FortFunction.this.dbSave();
                        if (FortFunction.this._cwh) {
                            Fort.this.getOwnerClan().getWarehouse().destroyItemByItemId("CS_function_fee", 57, fee, null, null);
                            if (Config.DEBUG) {
                                _log.warning("Deducted " + fee + " adena from " + Fort.this.getName() + " owner's cwh for function id : " + FortFunction.this.getType());
                            }
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), FortFunction.this.getRate());
                    } else {
                        Fort.this.removeFunction(FortFunction.this.getType());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

