/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ItemHolder;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcFreight;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;

public class RequestPackageSend
extends L2GameClientPacket {
    private final String _C_9F_REQUESTPACKAGESEND = "[C] 9F RequestPackageSend";
    private ItemHolder[] _items = null;
    private int _objectId;
    private int _count;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._count = this.readD();
        this._items = new ItemHolder[this._count];
        for (int i = 0; i < this._count; ++i) {
            int objId = this.readD();
            long cnt = this.readQ();
            if (objId < 1 || cnt < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new ItemHolder(objId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("deposit")) {
            player.sendMessage("You depositing items too fast.");
            return;
        }
        player.setActiveWarehouse(new PcFreight(this._objectId));
        ItemContainer warehouse = player.getActiveWarehouse();
        if (warehouse == null) {
            return;
        }
        L2Npc manager = player.getLastFolkNPC();
        if (!(manager != null && player.isInsideRadius(manager, 150, false, false) || player.isGM())) {
            return;
        }
        if (player.getActiveEnchantItem() != null) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use enchant Exploit!", Config.DEFAULT_PUNISH);
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && player.getKarma() > 0) {
            return;
        }
        int fee = this._count * Config.ALT_FREIGHT_PRIECE;
        double currentAdena = player.getAdena();
        int slots = 0;
        for (ItemHolder i : this._items) {
            L2ItemInstance item = player.checkItemManipulation(i.getObjectId(), i.getCount(), "deposit");
            if (item == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (validity check)");
                return;
            }
            if (!item.isFreightable()) {
                return;
            }
            if (item.getItemId() == 57) {
                currentAdena -= (double)i.getCount();
                continue;
            }
            if (!item.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (warehouse.getItemByItemId(item.getItemId()) != null) continue;
            ++slots;
        }
        if (!warehouse.validateCapacity(slots)) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
            return;
        }
        if (currentAdena < (double)fee || !player.reduceAdena(warehouse.getName(), fee, manager, false)) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA));
            return;
        }
        if (player.getActiveTradeList() != null) {
            return;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (ItemHolder i : this._items) {
            L2ItemInstance oldItem = player.checkItemManipulation(i.getObjectId(), i.getCount(), "deposit");
            if (oldItem == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (olditem == null)");
                return;
            }
            L2ItemInstance newItem = player.getInventory().transferItem("Trade", i.getObjectId(), i.getCount(), warehouse, player, null);
            if (newItem == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (newitem == null)");
                continue;
            }
            if (playerIU == null) continue;
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
                continue;
            }
            playerIU.addRemovedItem(oldItem);
        }
        warehouse.deleteMe();
        if (playerIU != null) {
            player.sendPacket(playerIU);
        } else {
            player.sendPacket(new ItemList(player, false));
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    @Override
    public String getType() {
        return "[C] 9F RequestPackageSend";
    }
}

