/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.readpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import java.util.logging.Logger;
import org.netcon.BaseReadPacket;

public final class ClanNoticeInfo
extends BaseReadPacket {
    private static Logger _log = Logger.getLogger(ClanNoticeInfo.class.getName());
    private final int _type;
    private final CommunityServerThread _cst;

    public ClanNoticeInfo(byte[] data, int type) {
        super(data);
        this._cst = null;
        this._type = type;
    }

    public ClanNoticeInfo(byte[] data, CommunityServerThread cst, int type) {
        super(data);
        this._type = type;
        this._cst = cst;
    }

    public final void run() {
        switch (this._type) {
            case 0: {
                int clanId = super.readD();
                L2Clan c = ClanTable.getInstance().getClan(clanId);
                String notice = super.readS();
                c.setNotice(notice);
                boolean noticeEnabled = super.readC() == 1;
                c.setNoticeEnabled(noticeEnabled);
                break;
            }
            case 1: {
                int clanId = super.readD();
                L2Clan c = ClanTable.getInstance().getClan(clanId);
                boolean noticeEnabled = super.readC() == 1;
                c.setNoticeEnabled(noticeEnabled);
                break;
            }
            case 2: {
                int clanId = super.readD();
                L2Clan clan = ClanTable.getInstance().getClan(clanId);
                if (clan != null) {
                    this._cst.sendPacket(new WorldInfo(null, clan, 4));
                    break;
                }
                _log.warning("Can't find clan with id: " + clanId);
            }
        }
    }
}

