/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.AccessLevels;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class Die
extends L2GameServerPacket {
    private static final String _S__0B_DIE = "[S] 00 Die";
    private int _charObjId;
    private boolean _canTeleport;
    private boolean _sweepable;
    private L2AccessLevel _access = AccessLevels._userAccessLevel;
    private L2Clan _clan;
    L2Character _activeChar;

    public Die(L2Character cha) {
        this._activeChar = cha;
        if (cha instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)cha;
            this._access = player.getAccessLevel();
            this._clan = player.getClan();
        }
        this._charObjId = cha.getObjectId();
        boolean bl = this._canTeleport = (!(cha instanceof L2PcInstance) || !TvTEvent.isStarted() || !TvTEvent.isPlayerParticipant(this._charObjId)) && !cha.isPendingRevive();
        if (cha instanceof L2Attackable) {
            this._sweepable = ((L2Attackable)cha).isSweepActive();
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(0);
        this.writeD(this._charObjId);
        this.writeD(this._canTeleport ? 1 : 0);
        if (this._canTeleport && this._clan != null) {
            boolean isInCastleDefense = false;
            boolean isInFortDefense = false;
            L2SiegeClan siegeClan = null;
            Castle castle = CastleManager.getInstance().getCastle(this._activeChar);
            Fort fort = FortManager.getInstance().getFort(this._activeChar);
            if (castle != null && castle.getSiege().getIsInProgress()) {
                siegeClan = castle.getSiege().getAttackerClan(this._clan);
                if (siegeClan == null && castle.getSiege().checkIsDefender(this._clan)) {
                    isInCastleDefense = true;
                }
            } else if (fort != null && fort.getSiege().getIsInProgress() && (siegeClan = fort.getSiege().getAttackerClan(this._clan)) == null && fort.getSiege().checkIsDefender(this._clan)) {
                isInFortDefense = true;
            }
            this.writeD(this._clan.getHasHideout() > 0 ? 1 : 0);
            this.writeD(this._clan.getHasCastle() > 0 || isInCastleDefense ? 1 : 0);
            this.writeD(TerritoryWarManager.getInstance().getFlagForClan(this._clan) != null || siegeClan != null && !isInCastleDefense && !isInFortDefense && !siegeClan.getFlag().isEmpty() ? 1 : 0);
            this.writeD(this._sweepable ? 1 : 0);
            this.writeD(this._access.allowFixedRes() ? 1 : 0);
            this.writeD(this._clan.getHasFort() > 0 || isInFortDefense ? 1 : 0);
        } else {
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._sweepable ? 1 : 0);
            this.writeD(this._access.allowFixedRes() ? 1 : 0);
            this.writeD(0);
        }
    }

    @Override
    public String getType() {
        return _S__0B_DIE;
    }
}

