/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public class EffectCombatPointHealOverTime
extends L2Effect {
    public EffectCombatPointHealOverTime(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectCombatPointHealOverTime(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    protected boolean effectCanBeStolen() {
        return true;
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.COMBAT_POINT_HEAL_OVER_TIME;
    }

    @Override
    public boolean onActionTime() {
        double maxcp;
        if (this.getEffected().isDead()) {
            return false;
        }
        double cp = this.getEffected().getCurrentCp();
        if (cp >= (maxcp = (double)this.getEffected().getMaxRecoverableCp())) {
            return true;
        }
        if ((cp += this.calc()) > maxcp) {
            cp = maxcp;
        }
        this.getEffected().setCurrentCp(cp);
        StatusUpdate sump = new StatusUpdate(this.getEffected());
        sump.addAttribute(33, (int)cp);
        this.getEffected().sendPacket(sump);
        return true;
    }
}

