/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.ngl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleCodes {
    Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static LocaleCodes getInstance() {
        return SingletonHolder._instance;
    }

    private LocaleCodes() {
        this.loadCodes();
    }

    private void loadCodes() {
        for (Locale locale : Locale.getAvailableLocales()) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (language == "" && country == "" && variant == "") continue;
            StringBuilder lang = new StringBuilder(256);
            lang.append(language);
            if (country != "") {
                lang.append(country);
            }
            if (variant != "") {
                lang.append('_' + variant);
            }
            this._locales.put(lang.toString(), locale);
        }
    }

    public Locale getLanguage(String lang) {
        return this._locales.get(lang);
    }

    private static class SingletonHolder {
        protected static final LocaleCodes _instance = new LocaleCodes();

        private SingletonHolder() {
        }
    }
}

