/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IUserCommandHandler;
import gnu.trove.TIntObjectHashMap;
import java.util.logging.Logger;

public class UserCommandHandler {
    private static Logger _log = Logger.getLogger(UserCommandHandler.class.getName());
    private TIntObjectHashMap<IUserCommandHandler> _datatable = new TIntObjectHashMap();

    public static UserCommandHandler getInstance() {
        return SingletonHolder._instance;
    }

    private UserCommandHandler() {
    }

    public void registerUserCommandHandler(IUserCommandHandler handler) {
        int[] ids = handler.getUserCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for user command " + ids[i]);
            }
            this._datatable.put(ids[i], (Object)handler);
        }
    }

    public IUserCommandHandler getUserCommandHandler(int userCommand) {
        if (Config.DEBUG) {
            _log.fine("getting handler for user command: " + userCommand);
        }
        return (IUserCommandHandler)this._datatable.get(userCommand);
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final UserCommandHandler _instance = new UserCommandHandler();

        private SingletonHolder() {
        }
    }
}

