/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Base64;
import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.communitybbs.Manager.ClanBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.CustomBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.RegionBBSManager;
import com.l2jserver.gameserver.datatables.AdminCommandAccessRights;
import com.l2jserver.gameserver.datatables.GMSkillTable;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2ClassMasterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Couple;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExBirthdayPopup;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import com.l2jserver.gameserver.network.serverpackets.ExNotifyPremiumItem;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.FriendList;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.PledgeStatusChanged;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.logging.Logger;

public class EnterWorld
extends L2GameClientPacket {
    private static final String _C__03_ENTERWORLD = "[C] 03 EnterWorld";
    private static Logger _log = Logger.getLogger(EnterWorld.class.getName());
    private int[][] tracert = new int[5][4];

    public TaskPriority getPriority() {
        return TaskPriority.PR_URGENT;
    }

    @Override
    protected void readImpl() {
        this.readB(new byte[32]);
        this.readD();
        this.readD();
        this.readD();
        this.readD();
        this.readB(new byte[32]);
        this.readD();
        for (int i = 0; i < 5; ++i) {
            for (int o = 0; o < 4; ++o) {
                this.tracert[i][o] = this.readC();
            }
        }
    }

    @Override
    protected void runImpl() {
        String serverNews;
        float points;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            _log.warning("EnterWorld failed! activeChar returned 'null'.");
            ((L2GameClient)this.getClient()).closeNow();
            return;
        }
        String[] adress = new String[5];
        for (int i = 0; i < 5; ++i) {
            adress[i] = this.tracert[i][0] + "." + this.tracert[i][1] + "." + this.tracert[i][2] + "." + this.tracert[i][3];
        }
        LoginServerThread.getInstance().sendClientTracert(activeChar.getAccountName(), adress);
        ((L2GameClient)this.getClient()).setClientTracert(this.tracert);
        if (Config.RESTORE_PLAYER_INSTANCE) {
            activeChar.setInstanceId(InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId()));
        } else {
            int instanceId = InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId());
            if (instanceId > 0) {
                InstanceManager.getInstance().getInstance(instanceId).removePlayer(activeChar.getObjectId());
            }
        }
        if (L2World.getInstance().findObject(activeChar.getObjectId()) != null && Config.DEBUG) {
            _log.warning("User already exists in Object ID map! User " + activeChar.getName() + " is a character clone.");
        }
        if (activeChar.isGM()) {
            if (Config.GM_STARTUP_INVULNERABLE && AdminCommandAccessRights.getInstance().hasAccess("admin_invul", activeChar.getAccessLevel())) {
                activeChar.setIsInvul(true);
            }
            if (Config.GM_STARTUP_INVISIBLE && AdminCommandAccessRights.getInstance().hasAccess("admin_invisible", activeChar.getAccessLevel())) {
                activeChar.getAppearance().setInvisible();
            }
            if (Config.GM_STARTUP_SILENCE && AdminCommandAccessRights.getInstance().hasAccess("admin_silence", activeChar.getAccessLevel())) {
                activeChar.setSilenceMode(true);
            }
            if (Config.GM_STARTUP_DIET_MODE && AdminCommandAccessRights.getInstance().hasAccess("admin_diet", activeChar.getAccessLevel())) {
                activeChar.setDietMode(true);
                activeChar.refreshOverloaded();
            }
            if (Config.GM_STARTUP_AUTO_LIST && AdminCommandAccessRights.getInstance().hasAccess("admin_gmliston", activeChar.getAccessLevel())) {
                GmListTable.getInstance().addGm(activeChar, false);
            } else {
                GmListTable.getInstance().addGm(activeChar, true);
            }
            if (Config.GM_GIVE_SPECIAL_SKILLS) {
                GMSkillTable.getInstance().addSkills(activeChar);
            }
        }
        if (activeChar.getCurrentHp() < 0.5) {
            activeChar.setIsDead(true);
        }
        boolean showClanNotice = false;
        if (activeChar.getClan() != null) {
            activeChar.sendPacket(new PledgeSkillList(activeChar.getClan()));
            this.notifyClanMembers(activeChar);
            this.notifySponsorOrApprentice(activeChar);
            ClanHall clanHall = ClanHallManager.getInstance().getClanHallByOwner(activeChar.getClan());
            if (clanHall != null && !clanHall.getPaid()) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW).addNumber(clanHall.getPaidTomorrow().get(11)));
            }
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                if (!siege.getIsInProgress()) continue;
                if (siege.checkIsAttacker(activeChar.getClan())) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(siege.getCastle().getCastleId());
                    continue;
                }
                if (!siege.checkIsDefender(activeChar.getClan())) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(siege.getCastle().getCastleId());
            }
            for (FortSiege fortSiege : FortSiegeManager.getInstance().getSieges()) {
                if (!fortSiege.getIsInProgress()) continue;
                if (fortSiege.checkIsAttacker(activeChar.getClan())) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(fortSiege.getFort().getFortId());
                    continue;
                }
                if (!fortSiege.checkIsDefender(activeChar.getClan())) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(fortSiege.getFort().getFortId());
            }
            this.sendPacket(new PledgeShowMemberListAll(activeChar.getClan(), activeChar));
            this.sendPacket(new PledgeStatusChanged(activeChar.getClan()));
            if (activeChar.getClan().getHasCastle() > 0) {
                CastleManager.getInstance().getCastleByOwner(activeChar.getClan()).giveResidentialSkills(activeChar);
            }
            if (activeChar.getClan().getHasFort() > 0) {
                FortManager.getInstance().getFortByOwner(activeChar.getClan()).giveResidentialSkills(activeChar);
            }
            showClanNotice = activeChar.getClan().isNoticeEnabled();
            String contents = ClanBBSManager.getInstance().getMsgData("announce", activeChar.getClan().getClanId());
            if (!contents.isEmpty()) {
                NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(1);
                npcHtmlMessage.setFile(activeChar.getHtmlPrefix(), "data/html/clannews.htm");
                npcHtmlMessage.replace((CharSequence)"%clan_name%", activeChar.getClan().getName());
                npcHtmlMessage.replace((CharSequence)"%contents%", contents);
                activeChar.sendPacket(npcHtmlMessage);
            }
            contents = null;
        }
        if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar) > 0) {
            if (TerritoryWarManager.getInstance().isTWInProgress()) {
                activeChar.setSiegeState((byte)1);
            }
            activeChar.setSiegeSide(TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar));
        }
        if (SevenSigns.getInstance().isSealValidationPeriod() && SevenSigns.getInstance().getSealOwner(3) != 0) {
            int cabal = SevenSigns.getInstance().getPlayerCabal(activeChar.getObjectId());
            if (cabal != 0) {
                if (cabal == SevenSigns.getInstance().getSealOwner(3)) {
                    activeChar.addSkill(SkillTable.FrequentSkill.THE_VICTOR_OF_WAR.getSkill());
                } else {
                    activeChar.addSkill(SkillTable.FrequentSkill.THE_VANQUISHED_OF_WAR.getSkill());
                }
            }
        } else {
            activeChar.removeSkill(SkillTable.FrequentSkill.THE_VICTOR_OF_WAR.getSkill());
            activeChar.removeSkill(SkillTable.FrequentSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
        if (Config.ENABLE_VITALITY && Config.RECOVER_VITALITY_ON_RECONNECT && (points = Config.RATE_RECOVERY_ON_RECONNECT * (float)(System.currentTimeMillis() - activeChar.getLastAccess()) / 60000.0f) > 0.0f) {
            activeChar.updateVitalityPoints(points, false, true);
        }
        activeChar.checkRecoBonusTask();
        activeChar.checkAuraItemEquipped();
        activeChar.broadcastUserInfo();
        activeChar.getMacroses().sendUpdate();
        this.sendPacket(new ItemList(activeChar, false));
        activeChar.queryGameGuard();
        this.sendPacket(new ExGetBookMarkInfoPacket(activeChar));
        this.sendPacket(new ShortCutInit(activeChar));
        activeChar.sendPacket(ExBasicActionList.getStaticPacket(activeChar));
        activeChar.sendSkillList();
        activeChar.sendPacket(new HennaInfo(activeChar));
        Quest.playerEnter(activeChar);
        if (!Config.DISABLE_TUTORIAL) {
            this.loadTutorial(activeChar);
        }
        for (Quest quest : QuestManager.getInstance().getAllManagedScripts()) {
            if (quest == null || !quest.getOnEnterWorld()) continue;
            quest.notifyEnterWorld(activeChar);
        }
        activeChar.sendPacket(new QuestList());
        if (Config.PLAYER_SPAWN_PROTECTION > 0) {
            activeChar.setProtection(true);
        }
        activeChar.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        if (L2Event.active && L2Event.connectionLossData.containsKey(activeChar.getName()) && L2Event.isOnEvent(activeChar)) {
            L2Event.restoreChar(activeChar);
        } else if (L2Event.connectionLossData.containsKey(activeChar.getName())) {
            L2Event.restoreAndTeleChar(activeChar);
        }
        if (Config.L2JMOD_ALLOW_WEDDING) {
            this.engage(activeChar);
            this.notifyPartner(activeChar, activeChar.getPartnerId());
        }
        if (activeChar.isCursedWeaponEquipped()) {
            CursedWeaponsManager.getInstance().getCursedWeapon(activeChar.getCursedWeaponEquippedId()).cursedOnLogin();
        }
        activeChar.updateEffectIcons();
        activeChar.sendPacket(new EtcStatusUpdate(activeChar));
        activeChar.sendPacket(new ExStorageMaxCount(activeChar));
        this.sendPacket(new FriendList(activeChar));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FRIEND_S1_HAS_LOGGED_IN);
        sm.addString(activeChar.getName());
        Iterator<Object> i$ = activeChar.getFriendList().iterator();
        while (i$.hasNext()) {
            int n = (Integer)i$.next();
            L2Object obj = L2World.getInstance().findObject(n);
            if (obj == null) continue;
            obj.sendPacket(sm);
        }
        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.WELCOME_TO_LINEAGE));
        activeChar.sendMessage(this.getText("VGhpcyBzZXJ2ZXIgdXNlcyBMMkosIGEgcHJvamVjdCBmb3VuZGVkIGJ5IEwyQ2hlZg==\n"));
        activeChar.sendMessage(this.getText("YW5kIGRldmVsb3BlZCBieSB0aGUgTDJKIERldiBUZWFtIGF0IGwyanNlcnZlci5jb20=\n"));
        if (Config.DISPLAY_SERVER_VERSION) {
            if (Config.SERVER_VERSION != null) {
                activeChar.sendMessage(this.getText("TDJKIFNlcnZlciBWZXJzaW9uOg==") + "   " + Config.SERVER_VERSION);
            }
            if (Config.DATAPACK_VERSION != null) {
                activeChar.sendMessage(this.getText("TDJKIERhdGFwYWNrIFZlcnNpb246") + " " + Config.DATAPACK_VERSION);
            }
        }
        activeChar.sendMessage(this.getText("Q29weXJpZ2h0IDIwMDQtMjAxMQ==\n"));
        SevenSigns.getInstance().sendCurrentPeriodMsg(activeChar);
        Announcements.getInstance().showAnnouncements(activeChar);
        if (showClanNotice) {
            NpcHtmlMessage notice = new NpcHtmlMessage(1);
            notice.setFile(activeChar.getHtmlPrefix(), "data/html/clanNotice.htm");
            notice.replace((CharSequence)"%clan_name%", activeChar.getClan().getName());
            notice.replace((CharSequence)"%notice_text%", activeChar.getClan().getNotice().replaceAll("\r\n", "<br>"));
            notice.disableValidation();
            this.sendPacket(notice);
        } else if (Config.SERVER_NEWS && (serverNews = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/servnews.htm")) != null) {
            this.sendPacket(new NpcHtmlMessage(1, serverNews));
        }
        if (Config.PETITIONING_ALLOWED) {
            PetitionManager.getInstance().checkPetitionMessages(activeChar);
        }
        if (activeChar.isAlikeDead()) {
            this.sendPacket(new Die(activeChar));
        }
        activeChar.onPlayerEnter();
        this.sendPacket(new SkillCoolTime(activeChar));
        this.sendPacket(new ExVoteSystemInfo(activeChar));
        for (L2ItemInstance i : activeChar.getInventory().getItems()) {
            if (i.isTimeLimitedItem()) {
                i.scheduleLifeTimeTask();
            }
            if (!i.isShadowItem() || !i.isEquipped()) continue;
            i.decreaseMana(false);
        }
        for (L2ItemInstance i : activeChar.getWarehouse().getItems()) {
            if (!i.isTimeLimitedItem()) continue;
            i.scheduleLifeTimeTask();
        }
        if (DimensionalRiftManager.getInstance().checkIfInRiftZone(activeChar.getX(), activeChar.getY(), activeChar.getZ(), false)) {
            DimensionalRiftManager.getInstance().teleportToWaitingRoom(activeChar);
        }
        if (activeChar.getClanJoinExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBERSHIP_TERMINATED));
        }
        if (activeChar.getInventory().getItemByItemId(9819) != null) {
            Fort fort = FortManager.getInstance().getFort(activeChar);
            if (fort != null) {
                FortSiegeManager.getInstance().dropCombatFlag(activeChar, fort.getFortId());
            } else {
                int n = activeChar.getInventory().getSlotFromItem(activeChar.getInventory().getItemByItemId(9819));
                activeChar.getInventory().unEquipItemInBodySlot(n);
                activeChar.destroyItem("CombatFlag", activeChar.getInventory().getItemByItemId(9819), null, true);
            }
        }
        if (!(activeChar.isGM() || !activeChar.isInsideZone((byte)2) || activeChar.isInSiege() && activeChar.getSiegeState() >= 2)) {
            activeChar.teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
        if (Config.ALLOW_MAIL && MailManager.getInstance().hasUnreadPost(activeChar)) {
            this.sendPacket(ExNoticePostArrived.valueOf(false));
        }
        RegionBBSManager.getInstance().changeCommunityBoard();
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(activeChar, null, 2));
        int privMsgCnt = CustomBBSManager.getInstance().getPrivateMsgCnt(activeChar);
        if (privMsgCnt > 0) {
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.S1_UNREAD_MESSAGES).addNumber(privMsgCnt));
            this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NEW_MAIL));
        }
        TvTEvent.onLogin(activeChar);
        if (Config.WELCOME_MESSAGE_ENABLED) {
            activeChar.sendPacket(new ExShowScreenMessage(Config.WELCOME_MESSAGE_TEXT, Config.WELCOME_MESSAGE_TIME));
        }
        L2ClassMasterInstance.showQuestionMark(activeChar);
        int n = activeChar.checkBirthDay();
        if (n == 0) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_BIRTHDAY_GIFT_HAS_ARRIVED));
            activeChar.sendPacket(new ExBirthdayPopup());
        } else if (n != -1) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_S1_DAYS_UNTIL_YOUR_CHARACTERS_BIRTHDAY);
            sm.addString(Integer.toString(n));
            activeChar.sendPacket(sm);
        }
        if (!activeChar.getPremiumItemList().isEmpty()) {
            activeChar.sendPacket(new ExNotifyPremiumItem());
        }
    }

    private void engage(L2PcInstance cha) {
        int _chaid = cha.getObjectId();
        for (Couple cl : CoupleManager.getInstance().getCouples()) {
            if (cl.getPlayer1Id() != _chaid && cl.getPlayer2Id() != _chaid) continue;
            if (cl.getMaried()) {
                cha.setMarried(true);
            }
            cha.setCoupleId(cl.getId());
            if (cl.getPlayer1Id() == _chaid) {
                cha.setPartnerId(cl.getPlayer2Id());
                continue;
            }
            cha.setPartnerId(cl.getPlayer1Id());
        }
    }

    private void notifyPartner(L2PcInstance cha, int partnerId) {
        if (cha.getPartnerId() != 0) {
            int objId = cha.getPartnerId();
            try {
                L2PcInstance partner = L2World.getInstance().getPlayer(objId);
                if (partner != null) {
                    partner.sendMessage("\u7d50\u5a5a\u76f8\u624b\u304c\u30ed\u30b0\u30a4\u30f3\u3057\u307e\u3057\u305f\u3002");
                }
                partner = null;
            }
            catch (ClassCastException cce) {
                _log.warning("Wedding Error: ID " + objId + " is now owned by a(n) " + L2World.getInstance().findObject(objId).getClass().getSimpleName());
            }
        }
    }

    private void notifyClanMembers(L2PcInstance activeChar) {
        L2Clan clan = activeChar.getClan();
        if (clan != null) {
            clan.getClanMember(activeChar.getObjectId()).setPlayerInstance(activeChar);
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_LOGGED_IN);
            msg.addString(activeChar.getName());
            clan.broadcastToOtherOnlineMembers(msg, activeChar);
            msg = null;
            clan.broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(activeChar), activeChar);
        }
    }

    private void notifySponsorOrApprentice(L2PcInstance activeChar) {
        L2PcInstance apprentice;
        if (activeChar.getSponsor() != 0) {
            L2PcInstance sponsor = L2World.getInstance().getPlayer(activeChar.getSponsor());
            if (sponsor != null) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_APPRENTICE_S1_HAS_LOGGED_IN);
                msg.addString(activeChar.getName());
                sponsor.sendPacket(msg);
            }
        } else if (activeChar.getApprentice() != 0 && (apprentice = L2World.getInstance().getPlayer(activeChar.getApprentice())) != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SPONSOR_C1_HAS_LOGGED_IN);
            msg.addString(activeChar.getName());
            apprentice.sendPacket(msg);
        }
    }

    private String getText(String string) {
        try {
            String result = new String(Base64.decode(string), "UTF-8");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void loadTutorial(L2PcInstance player) {
        QuestState qs = player.getQuestState("255_Tutorial");
        if (qs != null) {
            qs.getQuest().notifyEvent("UC", null, player);
        }
    }

    @Override
    public String getType() {
        return _C__03_ENTERWORLD;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

