/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SummonSkillsTable;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2ManufactureList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2BabyPetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ChairSit;
import com.l2jserver.gameserver.network.serverpackets.ExAskCoupleAction;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopManageList;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Arrays;
import java.util.logging.Logger;

public final class RequestActionUse
extends L2GameClientPacket {
    private static final String _C__45_REQUESTACTIONUSE = "[C] 45 RequestActionUse";
    private static Logger _log = Logger.getLogger(RequestActionUse.class.getName());
    private int _actionId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._actionId = this.readD();
        this._ctrlPressed = this.readD() == 1;
        this._shiftPressed = this.readC() == 1;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (Config.DEBUG) {
            _log.finest(activeChar.getName() + " request Action use: id " + this._actionId + " 2:" + this._ctrlPressed + " 3:" + this._shiftPressed);
        }
        if (activeChar.isAlikeDead() || activeChar.isDead()) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isOutOfControl()) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isTransformed()) {
            int[] allowedActions;
            int[] nArray = allowedActions = activeChar.isTransformed() ? ExBasicActionList._actionsOnTransform : ExBasicActionList._defaultActionList;
            if (Arrays.binarySearch(allowedActions, this._actionId) < 0) {
                ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
                _log.info("Player " + activeChar + " used action which he does not have! id = " + this._actionId + " transform: " + activeChar.getTransformation());
                return;
            }
        }
        L2Summon pet = activeChar.getPet();
        L2Object target = activeChar.getTarget();
        if (Config.DEBUG) {
            _log.info("Requested Action ID: " + this._actionId);
        }
        switch (this._actionId) {
            case 0: {
                if (activeChar.getMountType() != 0) break;
                if (target != null && !activeChar.isSitting() && target instanceof L2StaticObjectInstance && ((L2StaticObjectInstance)target).getType() == 1 && CastleManager.getInstance().getCastle(target) != null && activeChar.isInsideRadius(target, 150, false, false)) {
                    ChairSit cs = new ChairSit(activeChar, ((L2StaticObjectInstance)target).getStaticObjectId());
                    activeChar.sendPacket(cs);
                    activeChar.sitDown();
                    activeChar.broadcastPacket(cs);
                    break;
                }
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                } else {
                    activeChar.sitDown();
                }
                if (!Config.DEBUG) break;
                _log.fine("new wait type: " + (activeChar.isSitting() ? "SITTING" : "STANDING"));
                break;
            }
            case 1: {
                if (activeChar.isRunning()) {
                    activeChar.setWalking();
                } else {
                    activeChar.setRunning();
                }
                if (!Config.DEBUG) break;
                _log.fine("new move type: " + (activeChar.isRunning() ? "RUNNING" : "WALKIN"));
                break;
            }
            case 10: {
                activeChar.tryOpenPrivateSellStore(false);
                break;
            }
            case 28: {
                activeChar.tryOpenPrivateBuyStore();
                break;
            }
            case 15: 
            case 21: {
                if (pet == null || activeChar.isBetrayed()) break;
                ((L2SummonAI)pet.getAI()).notifyFollowStatusChange();
                break;
            }
            case 16: 
            case 22: {
                if (target == null || pet == null || pet == target || activeChar == target || pet.isBetrayed()) break;
                if (pet.isAttackingDisabled()) {
                    if (pet.getAttackEndTime() > GameTimeController.getGameTicks()) {
                        pet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
                    } else {
                        return;
                    }
                }
                if (pet instanceof L2PetInstance && pet.getLevel() - activeChar.getLevel() > 20) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_TOO_HIGH_TO_CONTROL));
                    return;
                }
                if (activeChar.isInOlympiadMode() && !activeChar.isOlympiadStart()) {
                    activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (target.getActingPlayer() != null && pet.getOwner().getSiegeState() > 0 && pet.getOwner().isInsideZone((byte)2) && target.getActingPlayer().getSiegeState() == pet.getOwner().getSiegeState() && target.getActingPlayer() != pet.getOwner() && target.getActingPlayer().getSiegeSide() == pet.getOwner().getSiegeSide()) {
                    if (TerritoryWarManager.getInstance().isTWInProgress()) {
                        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY));
                    } else {
                        this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS));
                    }
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (!activeChar.getAccessLevel().allowPeaceAttack() && activeChar.isInsidePeaceZone(pet, target)) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IN_PEACEZONE));
                    return;
                }
                if (pet.getNpcId() == 12564 || pet.getNpcId() == 12621) {
                    activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (pet.isLockedTarget()) {
                    pet.getOwner().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FAILED_CHANGE_TARGET));
                    return;
                }
                pet.setTarget(target);
                if (target.isAutoAttackable(activeChar) || this._ctrlPressed) {
                    if (target instanceof L2DoorInstance) {
                        if (!((L2DoorInstance)target).isAttackable(activeChar) || pet.getNpcId() == 14839) break;
                        pet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
                        break;
                    }
                    if (pet.getNpcId() == 14737 || pet.getNpcId() >= 14768 && pet.getNpcId() <= 14798) break;
                    pet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
                    break;
                }
                pet.setFollowStatus(false);
                pet.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, target);
                break;
            }
            case 17: 
            case 23: {
                if (pet == null || pet.isMovementDisabled() || pet.isBetrayed()) break;
                pet.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
                break;
            }
            case 19: {
                if (pet == null) break;
                if (pet.isDead()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DEAD_PET_CANNOT_BE_RETURNED));
                    break;
                }
                if (pet.isAttackingNow() || pet.isInCombat() || pet.isMovementDisabled() || pet.isBetrayed()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_CANNOT_SENT_BACK_DURING_BATTLE));
                    break;
                }
                if (!(pet instanceof L2PetInstance)) break;
                if (!pet.isHungry()) {
                    pet.unSummon(activeChar);
                    break;
                }
                if (((L2PetInstance)pet).getPetData().getFood().length > 0) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_RESTORE_HUNGRY_PETS));
                    break;
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_HELPER_PET_CANNOT_BE_RETURNED));
                break;
            }
            case 38: {
                activeChar.mountPlayer(pet);
                break;
            }
            case 32: {
                break;
            }
            case 36: {
                this.useSkill(4259);
                break;
            }
            case 37: {
                if (activeChar.isAlikeDead()) {
                    ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (activeChar.getPrivateStoreType() != 0) {
                    activeChar.setPrivateStoreType(0);
                    activeChar.broadcastUserInfo();
                }
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                }
                if (activeChar.getCreateList() == null) {
                    activeChar.setCreateList(new L2ManufactureList());
                }
                activeChar.sendPacket(new RecipeShopManageList(activeChar, true));
                break;
            }
            case 39: {
                this.useSkill(4138);
                break;
            }
            case 41: {
                if (target != null && (target instanceof L2DoorInstance || target instanceof L2SiegeFlagInstance)) {
                    this.useSkill(4230);
                    break;
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INCORRECT_TARGET));
                break;
            }
            case 42: {
                this.useSkill(4378, activeChar);
                break;
            }
            case 43: {
                this.useSkill(4137);
                break;
            }
            case 44: {
                this.useSkill(4139);
                break;
            }
            case 45: {
                this.useSkill(4025, activeChar);
                break;
            }
            case 46: {
                this.useSkill(4261);
                break;
            }
            case 47: {
                this.useSkill(4260);
                break;
            }
            case 48: {
                this.useSkill(4068);
                break;
            }
            case 51: {
                if (activeChar.isAlikeDead()) {
                    ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
                    return;
                }
                if (activeChar.getPrivateStoreType() != 0) {
                    activeChar.setPrivateStoreType(0);
                    activeChar.broadcastUserInfo();
                }
                if (activeChar.isSitting()) {
                    activeChar.standUp();
                }
                if (activeChar.getCreateList() == null) {
                    activeChar.setCreateList(new L2ManufactureList());
                }
                activeChar.sendPacket(new RecipeShopManageList(activeChar, false));
                break;
            }
            case 52: {
                if (pet == null || !(pet instanceof L2SummonInstance)) break;
                if (pet.isBetrayed()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_REFUSING_ORDER));
                    break;
                }
                if (pet.isAttackingNow() || pet.isInCombat()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_CANNOT_SENT_BACK_DURING_BATTLE));
                    break;
                }
                pet.unSummon(activeChar);
                break;
            }
            case 53: {
                if (target == null || pet == null || pet == target || pet.isMovementDisabled() || pet.isBetrayed()) break;
                pet.setFollowStatus(false);
                pet.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(target.getX(), target.getY(), target.getZ(), 0));
                break;
            }
            case 54: {
                if (target == null || pet == null || pet == target || pet.isMovementDisabled() || pet.isBetrayed()) break;
                pet.setFollowStatus(false);
                pet.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(target.getX(), target.getY(), target.getZ(), 0));
                break;
            }
            case 61: {
                activeChar.tryOpenPrivateSellStore(true);
                break;
            }
            case 65: {
                activeChar.sendMessage("Action not handled yet.");
                break;
            }
            case 67: {
                if (!activeChar.isInAirShip() || !activeChar.getAirShip().setCaptain(activeChar)) break;
                activeChar.broadcastUserInfo();
                break;
            }
            case 68: {
                if (!activeChar.isInAirShip() || !activeChar.getAirShip().isCaptain(activeChar) || !activeChar.getAirShip().setCaptain(null)) break;
                activeChar.broadcastUserInfo();
                break;
            }
            case 69: {
                AirShipManager.getInstance().sendAirShipTeleportList(activeChar);
                break;
            }
            case 70: {
                if (!activeChar.isInAirShip()) break;
                if (activeChar.getAirShip().isCaptain(activeChar)) {
                    if (!activeChar.getAirShip().setCaptain(null)) break;
                    activeChar.broadcastUserInfo();
                    break;
                }
                if (!activeChar.getAirShip().isInDock()) break;
                activeChar.getAirShip().oustPlayer(activeChar);
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                this.useCoupleSocial(this._actionId - 55);
                break;
            }
            case 1000: {
                if (!(target instanceof L2DoorInstance)) break;
                this.useSkill(4079);
                break;
            }
            case 1001: {
                break;
            }
            case 1003: {
                this.useSkill(4710);
                break;
            }
            case 1004: {
                this.useSkill(4711, activeChar);
                break;
            }
            case 1005: {
                this.useSkill(4712);
                break;
            }
            case 1006: {
                this.useSkill(4713, activeChar);
                break;
            }
            case 1007: {
                this.useSkill(4699, activeChar);
                break;
            }
            case 1008: {
                this.useSkill(4700, activeChar);
                break;
            }
            case 1009: {
                this.useSkill(4701);
                break;
            }
            case 1010: {
                this.useSkill(4702, activeChar);
                break;
            }
            case 1011: {
                this.useSkill(4703, activeChar);
                break;
            }
            case 1012: {
                this.useSkill(4704);
                break;
            }
            case 1013: {
                this.useSkill(4705);
                break;
            }
            case 1014: {
                this.useSkill(4706);
                break;
            }
            case 1015: {
                this.useSkill(4707);
                break;
            }
            case 1016: {
                this.useSkill(4709);
                break;
            }
            case 1017: {
                this.useSkill(4708);
                break;
            }
            case 1031: {
                this.useSkill(5135);
                break;
            }
            case 1032: {
                this.useSkill(5136);
                break;
            }
            case 1033: {
                this.useSkill(5137);
                break;
            }
            case 1034: {
                this.useSkill(5138);
                break;
            }
            case 1035: {
                this.useSkill(5139);
                break;
            }
            case 1036: {
                this.useSkill(5142);
                break;
            }
            case 1037: {
                this.useSkill(5141);
                break;
            }
            case 1038: {
                this.useSkill(5140);
                break;
            }
            case 1039: {
                if (target instanceof L2DoorInstance) break;
                this.useSkill(5110);
                break;
            }
            case 1040: {
                if (target instanceof L2DoorInstance) break;
                this.useSkill(5111);
                break;
            }
            case 1041: {
                this.useSkill(5442);
                break;
            }
            case 1042: {
                this.useSkill(5444);
                break;
            }
            case 1043: {
                this.useSkill(5443);
                break;
            }
            case 1044: {
                this.useSkill(5445);
                break;
            }
            case 1045: {
                this.useSkill(5584);
                break;
            }
            case 1046: {
                this.useSkill(5585);
                break;
            }
            case 1047: {
                this.useSkill(5580);
                break;
            }
            case 1048: {
                this.useSkill(5581);
                break;
            }
            case 1049: {
                this.useSkill(5582);
                break;
            }
            case 1050: {
                this.useSkill(5583);
                break;
            }
            case 1051: {
                this.useSkill(5638);
                break;
            }
            case 1052: {
                this.useSkill(5639);
                break;
            }
            case 1053: {
                this.useSkill(5640);
                break;
            }
            case 1054: {
                this.useSkill(5643);
                break;
            }
            case 1055: {
                this.useSkill(5647);
                break;
            }
            case 1056: {
                this.useSkill(5648);
                break;
            }
            case 1057: {
                this.useSkill(5646);
                break;
            }
            case 1058: {
                this.useSkill(5652);
                break;
            }
            case 1059: {
                this.useSkill(5653);
                break;
            }
            case 1060: {
                this.useSkill(5654);
                break;
            }
            case 1061: {
                this.useSkill(5745);
                break;
            }
            case 1062: {
                this.useSkill(5746);
                break;
            }
            case 1063: {
                this.useSkill(5747);
                break;
            }
            case 1064: {
                this.useSkill(5748);
                break;
            }
            case 1065: {
                this.useSkill(5753);
                break;
            }
            case 1066: {
                this.useSkill(5749);
                break;
            }
            case 1067: {
                this.useSkill(5750);
                break;
            }
            case 1068: {
                this.useSkill(5751);
                break;
            }
            case 1069: {
                this.useSkill(5752);
                break;
            }
            case 1070: {
                this.useSkill(5771);
                break;
            }
            case 1071: {
                this.useSkill(5761);
                break;
            }
            case 1072: {
                this.useSkill(6046);
                break;
            }
            case 1073: {
                this.useSkill(6047);
                break;
            }
            case 1074: {
                this.useSkill(6048);
                break;
            }
            case 1075: {
                this.useSkill(6049);
                break;
            }
            case 1076: {
                this.useSkill(6050);
                break;
            }
            case 1077: {
                this.useSkill(6051);
                break;
            }
            case 1078: {
                this.useSkill(6052);
                break;
            }
            case 1079: {
                this.useSkill(6053);
                break;
            }
            case 1080: {
                this.useSkill(6041);
                break;
            }
            case 1081: {
                this.useSkill(6042);
                break;
            }
            case 1082: {
                this.useSkill(6043);
                break;
            }
            case 1083: {
                this.useSkill(6044);
                break;
            }
            case 1084: {
                if (pet == null || !(pet instanceof L2BabyPetInstance)) break;
                ((L2BabyPetInstance)pet).switchMode();
                break;
            }
            case 1086: {
                this.useSkill(6094);
                break;
            }
            case 1087: {
                this.useSkill(6095);
                break;
            }
            case 1088: {
                this.useSkill(6096);
                break;
            }
            case 1089: {
                this.useSkill(6199);
                break;
            }
            case 1090: {
                this.useSkill(6205);
                break;
            }
            case 1091: {
                this.useSkill(6206);
                break;
            }
            case 1092: {
                this.useSkill(6207);
                break;
            }
            case 1093: {
                this.useSkill(6618);
                break;
            }
            case 1094: {
                this.useSkill(6681);
                break;
            }
            case 1095: {
                this.useSkill(6619);
                break;
            }
            case 1096: {
                this.useSkill(6682);
                break;
            }
            case 1097: {
                this.useSkill(6683);
                break;
            }
            case 1098: {
                this.useSkill(6684);
                break;
            }
            case 5000: {
                this.useSkill(23155);
                break;
            }
            case 5001: {
                this.useSkill(23167);
                break;
            }
            case 5002: {
                this.useSkill(23168);
                break;
            }
            case 5003: {
                this.useSkill(5749);
                break;
            }
            case 5004: {
                this.useSkill(5750);
                break;
            }
            case 5005: {
                this.useSkill(5751);
                break;
            }
            case 5006: {
                this.useSkill(5771);
                break;
            }
            case 5007: {
                this.useSkill(6046);
                break;
            }
            case 5008: {
                this.useSkill(6047);
                break;
            }
            case 5009: {
                this.useSkill(6048);
                break;
            }
            case 5010: {
                this.useSkill(6049);
                break;
            }
            case 5011: {
                this.useSkill(6050);
                break;
            }
            case 5012: {
                this.useSkill(6051);
                break;
            }
            case 5013: {
                this.useSkill(6052);
                break;
            }
            case 5014: {
                this.useSkill(6053);
                break;
            }
            case 5015: {
                this.useSkill(6054);
                break;
            }
            case 12: {
                this.tryBroadcastSocial(2);
                break;
            }
            case 13: {
                this.tryBroadcastSocial(3);
                break;
            }
            case 14: {
                this.tryBroadcastSocial(4);
                break;
            }
            case 24: {
                this.tryBroadcastSocial(6);
                break;
            }
            case 25: {
                this.tryBroadcastSocial(5);
                break;
            }
            case 26: {
                this.tryBroadcastSocial(7);
                break;
            }
            case 29: {
                this.tryBroadcastSocial(8);
                break;
            }
            case 30: {
                this.tryBroadcastSocial(9);
                break;
            }
            case 31: {
                this.tryBroadcastSocial(10);
                break;
            }
            case 33: {
                this.tryBroadcastSocial(11);
                break;
            }
            case 34: {
                this.tryBroadcastSocial(12);
                break;
            }
            case 35: {
                this.tryBroadcastSocial(13);
                break;
            }
            case 62: {
                this.tryBroadcastSocial(14);
                break;
            }
            case 66: {
                this.tryBroadcastSocial(15);
                break;
            }
            default: {
                _log.warning(activeChar.getName() + ": unhandled action type " + this._actionId);
            }
        }
    }

    private void useSkill(int skillId, L2Object target) {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Summon activeSummon = activeChar.getPet();
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PRIVATE_STORE_UNDER_WAY));
            return;
        }
        if (activeSummon != null && !activeSummon.isBetrayed()) {
            int lvl = 0;
            if (activeSummon instanceof L2PetInstance) {
                if (activeSummon.getLevel() - activeChar.getLevel() > 20) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_TOO_HIGH_TO_CONTROL));
                    return;
                }
                lvl = PetDataTable.getInstance().getPetData(activeSummon.getNpcId()).getAvailableLevel(skillId, activeSummon.getLevel());
            } else {
                lvl = SummonSkillsTable.getInstance().getAvailableLevel(activeSummon, skillId);
            }
            if (lvl == 0) {
                _log.warning("Pet " + activeSummon + " does not have the skill id " + skillId + " assigned.");
                return;
            }
            L2Skill skill = SkillTable.getInstance().getInfo(skillId, lvl);
            if (skill == null) {
                return;
            }
            if (skill.isOffensive() && activeChar == target) {
                return;
            }
            activeSummon.setTarget(target);
            activeSummon.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        }
    }

    private void useSkill(int skillId) {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        this.useSkill(skillId, activeChar.getTarget());
    }

    private void tryBroadcastSocial(int id) {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (Config.DEBUG) {
            _log.fine("Social Action:" + id);
        }
        if (activeChar.isFishing()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_3));
            return;
        }
        if (activeChar.canMakeSocialAction()) {
            activeChar.broadcastPacket(new SocialAction(activeChar, id));
        }
    }

    private void useCoupleSocial(int id) {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Object target = activeChar.getTarget();
        if (!(target instanceof L2PcInstance)) {
            activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return;
        }
        L2PcInstance player = (L2PcInstance)target;
        if (activeChar.isFishing() || player.isFishing()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_3));
            return;
        }
        double distance = activeChar.getPlanDistanceSq(player);
        if (distance > 2000.0 || distance < 70.0) {
            activeChar.sendPacket(SystemMessageId.TARGET_DO_NOT_MEET_LOC_REQUIREMENTS);
            return;
        }
        if (activeChar.canMakeSocialAction() && player.canMakeSocialAction()) {
            activeChar.setMultiSocialAction(id, player.getObjectId());
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_REQUESTED_COUPLE_ACTION_C1);
            sm.addPcName(player);
            activeChar.sendPacket(sm);
            player.sendPacket(new ExAskCoupleAction(activeChar.getObjectId(), id));
        } else {
            activeChar.sendPacket(SystemMessageId.COUPLE_ACTION_CANCELED);
        }
    }

    @Override
    public String getType() {
        return _C__45_REQUESTACTIONUSE;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return this._actionId != 10 && this._actionId != 28;
    }
}

