/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gsregistering;

import com.l2jserver.gsregistering.BaseGameServerRegister;
import com.l2jserver.gsregistering.RegisterDialog;
import com.l2jserver.images.ImagesTable;
import com.l2jserver.loginserver.GameServerTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GUserInterface
extends BaseGameServerRegister
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JFrame _frame;
    JTableModel _dtm;
    JProgressBar _progressBar;
    public JTable _gsTable;

    public GUserInterface(ResourceBundle bundle) {
        super(bundle);
        try {
            String fontName = bundle.getString("fontName");
            String fontSize = bundle.getString("fontSize");
            Font font = new Font(fontName, 0, Integer.parseInt(fontSize));
            UIDefaults defaultTable = UIManager.getLookAndFeelDefaults();
            for (Object o : defaultTable.keySet()) {
                if (!o.toString().endsWith(".font")) continue;
                UIManager.put(o, font);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this._frame = new JFrame();
        this.getFrame().setTitle(this.getBundle().getString("toolName"));
        this.getFrame().setSize(600, 400);
        this.getFrame().setDefaultCloseOperation(3);
        this.getFrame().setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.getFrame().setIconImage(ImagesTable.getImage("l2j.png").getImage());
        JMenuBar menubar = new JMenuBar();
        this.getFrame().setJMenuBar(menubar);
        JMenu fileMenu = new JMenu(this.getBundle().getString("fileMenu"));
        JMenuItem exitItem = new JMenuItem(this.getBundle().getString("exitItem"));
        exitItem.addActionListener(this);
        exitItem.setActionCommand("exit");
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu(this.getBundle().getString("helpMenu"));
        JMenuItem aboutItem = new JMenuItem(this.getBundle().getString("aboutItem"));
        aboutItem.addActionListener(this);
        aboutItem.setActionCommand("about");
        helpMenu.add(aboutItem);
        menubar.add(fileMenu);
        menubar.add(helpMenu);
        JButton btnRegister = new JButton(this.getBundle().getString("btnRegister"), ImagesTable.getImage("add.png"));
        btnRegister.addActionListener(this);
        btnRegister.setActionCommand("register");
        this.getFrame().add((Component)btnRegister, cons);
        cons.gridx = 1;
        cons.anchor = 22;
        JButton btnRemoveAll = new JButton(this.getBundle().getString("btnRemoveAll"), ImagesTable.getImage("cross.png"));
        btnRemoveAll.addActionListener(this);
        btnRemoveAll.setActionCommand("removeAll");
        this.getFrame().add((Component)btnRemoveAll, cons);
        String name = this.getBundle().getString("gsName");
        String action = this.getBundle().getString("gsAction");
        this._dtm = new JTableModel(new Object[]{"ID", name, action});
        this._gsTable = new JTable(this._dtm);
        this._gsTable.addMouseListener(new JTableButtonMouseListener(this._gsTable));
        this._gsTable.getColumnModel().getColumn(0).setMaxWidth(30);
        TableColumn actionCollumn = this._gsTable.getColumnModel().getColumn(2);
        actionCollumn.setCellRenderer(new ButtonCellRenderer());
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 1;
        cons.weighty = 1.0;
        cons.weightx = 1.0;
        cons.gridwidth = 2;
        JLayeredPane layer = new JLayeredPane();
        layer.setLayout(new BoxLayout(layer, 3));
        layer.add((Component)new JScrollPane(this._gsTable), 0);
        this._progressBar = new JProgressBar();
        this._progressBar.setIndeterminate(true);
        this._progressBar.setVisible(false);
        layer.add(this._progressBar, "Center", 1);
        this.getFrame().add((Component)layer, cons);
        this.refreshAsync();
    }

    public void refreshAsync() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                GUserInterface.this.refreshServers();
            }
        };
        Thread t = new Thread(r, "LoaderThread");
        t.start();
    }

    @Override
    public void load() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUserInterface.this._progressBar.setVisible(true);
            }
        });
        super.load();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUserInterface.this._progressBar.setVisible(false);
            }
        });
    }

    @Override
    public void showError(String msg, Throwable t) {
        String title;
        if (this.getBundle() != null) {
            title = this.getBundle().getString("error");
            msg = msg + '\n' + this.getBundle().getString("reason") + ' ' + t.getLocalizedMessage();
        } else {
            title = "Error";
            msg = msg + "\nCause: " + t.getLocalizedMessage();
        }
        JOptionPane.showMessageDialog(this.getFrame(), msg, title, 0);
        t.printStackTrace();
    }

    protected void refreshServers() {
        if (!this.isLoaded()) {
            this.load();
        }
        if (this.isLoaded()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int size = GameServerTable.getInstance().getServerNames().size();
                    if (size == 0) {
                        String title = GUserInterface.this.getBundle().getString("error");
                        String msg = GUserInterface.this.getBundle().getString("noServerNames");
                        JOptionPane.showMessageDialog(GUserInterface.this.getFrame(), msg, title, 0);
                        System.exit(1);
                    }
                    GUserInterface.this._dtm.setRowCount(0);
                    for (final int id : GameServerTable.getInstance().getRegisteredGameServers().keySet()) {
                        String name = GameServerTable.getInstance().getServerNameById(id);
                        JButton button = new JButton(GUserInterface.this.getBundle().getString("btnRemove"), ImagesTable.getImage("cross.png"));
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String sid = String.valueOf(id);
                                String sname = GameServerTable.getInstance().getServerNameById(id);
                                int choice = JOptionPane.showConfirmDialog(GUserInterface.this.getFrame(), GUserInterface.this.getBundle().getString("confirmRemoveText").replace("%d", sid).replace("%s", sname), GUserInterface.this.getBundle().getString("confirmRemoveTitle"), 0);
                                if (choice == 0) {
                                    try {
                                        BaseGameServerRegister.unregisterGameServer(id);
                                        GUserInterface.this.refreshAsync();
                                    }
                                    catch (SQLException e1) {
                                        GUserInterface.this.showError(GUserInterface.this.getBundle().getString("errorUnregister"), e1);
                                    }
                                }
                            }
                        });
                        GUserInterface.this._dtm.addRow(new Object[]{id, name, button});
                    }
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int choice;
        String cmd = e.getActionCommand();
        if (cmd.equals("register")) {
            RegisterDialog rd = new RegisterDialog(this);
            rd.setVisible(true);
        } else if (cmd.equals("exit")) {
            System.exit(0);
        } else if (cmd.equals("about")) {
            JOptionPane.showMessageDialog(this.getFrame(), this.getBundle().getString("credits") + "\nhttp://www.l2jserver.com\n\n" + this.getBundle().getString("icons") + "\n\n" + this.getBundle().getString("language") + '\n' + this.getBundle().getString("translation"), this.getBundle().getString("aboutItem"), 1, ImagesTable.getImage("l2jserverlogo.png"));
        } else if (cmd.equals("removeAll") && (choice = JOptionPane.showConfirmDialog(this.getFrame(), this.getBundle().getString("confirmRemoveAllText"), this.getBundle().getString("confirmRemoveTitle"), 0)) == 0) {
            try {
                BaseGameServerRegister.unregisterAllGameServers();
                this.refreshAsync();
            }
            catch (SQLException e1) {
                this.showError(this.getBundle().getString("errorUnregister"), e1);
            }
        }
    }

    public JFrame getFrame() {
        return this._frame;
    }

    class JTableModel
    extends DefaultTableModel {
        public JTableModel(Object[] columnNames) {
            super(columnNames, 0);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }

    class JTableButtonMouseListener
    implements MouseListener {
        private final JTable _table;

        public JTableButtonMouseListener(JTable table) {
            this._table = table;
        }

        private void forwardEvent(MouseEvent e) {
            TableColumnModel columnModel = this._table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this._table.getRowHeight();
            if (row >= this._table.getRowCount() || row < 0 || column >= this._table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this._table.getValueAt(row, column);
            if (value instanceof JButton) {
                JButton b = (JButton)value;
                if (e.getID() == 501) {
                    b.getModel().setPressed(true);
                    b.getModel().setArmed(true);
                    this._table.repaint();
                } else if (e.getID() == 502) {
                    b.doClick();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.forwardEvent(e);
        }
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        ButtonCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)value;
        }
    }
}

