/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.mail;

import com.l2jserver.Config;
import com.l2jserver.loginserver.mail.BaseMail;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MailSystem {
    private static final Logger _log = Logger.getLogger(MailSystem.class.getName());
    private final Map<String, MailContent> _mailData = new FastMap();

    public static MailSystem getInstance() {
        return SingletonHolder._instance;
    }

    public MailSystem() {
        this.loadMails();
    }

    public void sendMail(String account, String messageId, String ... args) {
        BaseMail mail = new BaseMail(account, messageId, args);
        mail.run();
    }

    private void loadMails() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/mail/MailList.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse MailList.xml file: " + e.getMessage(), e);
            }
            Node n = doc.getFirstChild();
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!d.getNodeName().equals("mail")) continue;
                String mailId = d.getAttributes().getNamedItem("id").getNodeValue();
                String subject = d.getAttributes().getNamedItem("subject").getNodeValue();
                String maFile = d.getAttributes().getNamedItem("file").getNodeValue();
                try {
                    FileInputStream fis = new FileInputStream(new File(Config.DATAPACK_ROOT, "data/mail/" + maFile));
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    int bytes = bis.available();
                    byte[] raw = new byte[bytes];
                    bis.read(raw);
                    String html = new String(raw, "UTF-8");
                    html = html.replaceAll("\r\n", "\n");
                    html = html.replace("%servermail%", Config.EMAIL_SERVERINFO_ADDRESS);
                    html = html.replace("%servername%", Config.EMAIL_SERVERINFO_NAME);
                    this._mailData.put(mailId, new MailContent(subject, html));
                    continue;
                }
                catch (IOException e) {
                    _log.warning("IOException while reading " + maFile);
                }
            }
            _log.info("eMail System Loaded");
        } else {
            _log.warning("Cannot load eMail System - Missing file MailList.xml");
        }
    }

    public MailContent getMailContent(String mailId) {
        return this._mailData.get(mailId);
    }

    private static class SingletonHolder {
        protected static final MailSystem _instance = new MailSystem();

        private SingletonHolder() {
        }
    }

    class MailContent {
        private final String _subject;
        private final String _text;

        public MailContent(String subject, String text) {
            this._subject = subject;
            this._text = text;
        }

        public String getSubject() {
            return this._subject;
        }

        public String getText() {
            return this._text;
        }
    }
}

