/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.HackingException;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.clientpackets.L2LoginClientPacket;
import com.l2jserver.loginserver.network.serverpackets.AccountKicked;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.loginserver.network.serverpackets.LoginOk;
import com.l2jserver.loginserver.network.serverpackets.ServerList;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;

public class RequestAuthLogin
extends L2LoginClientPacket {
    private static Logger _log = Logger.getLogger(RequestAuthLogin.class.getName());
    private final byte[] _raw = new byte[128];
    private String _user;
    private String _password;
    private int _ncotp;

    public String getPassword() {
        return this._password;
    }

    public String getUser() {
        return this._user;
    }

    public int getOneTimePassword() {
        return this._ncotp;
    }

    @Override
    public boolean readImpl() {
        if (this._buf.remaining() >= 128) {
            this.readB(this._raw);
            return true;
        }
        return false;
    }

    public void run() {
        byte[] decrypted = null;
        L2LoginClient client = (L2LoginClient)this.getClient();
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
            rsaCipher.init(2, client.getRSAPrivateKey());
            decrypted = rsaCipher.doFinal(this._raw, 0, 128);
        }
        catch (GeneralSecurityException e) {
            _log.log(Level.INFO, "", e);
            return;
        }
        this._user = new String(decrypted, 94, 14).trim();
        this._user = this._user.toLowerCase();
        this._password = new String(decrypted, 108, 16).trim();
        this._ncotp = decrypted[124];
        this._ncotp |= decrypted[125] << 8;
        this._ncotp |= decrypted[126] << 16;
        this._ncotp |= decrypted[127] << 24;
        LoginController lc = LoginController.getInstance();
        try {
            LoginController.AuthLoginResult result = lc.tryAuthLogin(this._user, this._password, client);
            switch (result) {
                case AUTH_SUCCESS: {
                    client.setAccount(this._user);
                    client.setState(L2LoginClient.LoginClientState.AUTHED_LOGIN);
                    client.setSessionKey(lc.assignSessionKeyToClient(this._user, client));
                    lc.getCharactersOnAccount(this._user);
                    if (Config.SHOW_LICENCE) {
                        client.sendPacket(new LoginOk(((L2LoginClient)this.getClient()).getSessionKey()));
                        break;
                    }
                    ((L2LoginClient)this.getClient()).sendPacket(new ServerList((L2LoginClient)this.getClient()));
                    break;
                }
                case INVALID_PASSWORD: {
                    client.close(LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG);
                    break;
                }
                case ACCOUNT_BANNED: {
                    client.close(new AccountKicked(AccountKicked.AccountKickedReason.REASON_PERMANENTLY_BANNED));
                    break;
                }
                case ALREADY_IPADDR: {
                    String address = client.getConnection().getInetAddress().getHostAddress();
                    _log.warning("IpAddress is in use on Game server: ID=" + this._user + ", IP=" + address);
                    for (String account : lc.getAlreadyLoginAccounts(address)) {
                        _log.warning("(Same IpAddress UserID: " + account + ")");
                        GameServerTable.GameServerInfo gsi = lc.getAccountOnGameServer(account);
                        if (gsi == null || !gsi.isAuthed()) continue;
                        gsi.getGameServerThread().kickPlayer(account);
                        lc.removeLoginIpAddr(account);
                        _log.warning(" ==> kicked from GS: " + account);
                    }
                    client.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                    break;
                }
                case ALREADY_ON_LS: {
                    L2LoginClient oldClient = lc.getAuthedClient(this._user);
                    if (oldClient != null) {
                        oldClient.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                        lc.removeAuthedLoginClient(this._user);
                    }
                    client.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                    break;
                }
                case ALREADY_ON_GS: {
                    GameServerTable.GameServerInfo gsi = lc.getAccountOnGameServer(this._user);
                    if (gsi == null) break;
                    client.close(LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE);
                    if (!gsi.isAuthed()) break;
                    gsi.getGameServerThread().kickPlayer(this._user);
                }
            }
        }
        catch (HackingException e) {
            InetAddress address = ((L2LoginClient)this.getClient()).getConnection().getInetAddress();
            lc.addBanForAddress(address, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
            _log.info("Banned (" + address + ") for " + Config.LOGIN_BLOCK_AFTER_BAN + " seconds, due to " + e.getConnects() + " incorrect login attempts.");
        }
    }
}

