/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2MapRegion;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2RespawnZone;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapRegionManager {
    protected static final Logger _log = Logger.getLogger(MapRegionManager.class.getName());
    private static Map<String, L2MapRegion> _regions;
    private static final String FILE = "MapRegion.xml";

    public static MapRegionManager getInstance() {
        return SingletonHolder._instance;
    }

    private MapRegionManager() {
        _regions = new FastMap();
        try {
            MapRegionManager.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.log(Level.SEVERE, "Failed loading MapRegion", e);
        }
    }

    private static void load() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT + "/data/" + FILE);
        if (file.exists()) {
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"region".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    String name = "";
                    String town = "";
                    int locId = -1;
                    int castle = -1;
                    int bbs = -1;
                    Node att = attrs.getNamedItem("name");
                    if (att == null) {
                        _log.severe("Missing name for MapRegion, skipping");
                        continue;
                    }
                    name = att.getNodeValue();
                    att = attrs.getNamedItem("town");
                    if (att == null) {
                        _log.severe("Missing town for MapRegion name: " + name + ", skipping");
                        continue;
                    }
                    town = att.getNodeValue();
                    att = attrs.getNamedItem("locId");
                    if (att == null) {
                        _log.severe("Missing locId for MapRegion name: " + name + ", skipping");
                        continue;
                    }
                    locId = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("castle");
                    if (att == null) {
                        _log.severe("Missing castle for MapRegion name: " + name + ", skipping");
                        continue;
                    }
                    castle = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("bbs");
                    if (att == null) {
                        _log.severe("Missing bbs for MapRegion name: " + name + ", skipping");
                        continue;
                    }
                    bbs = Integer.parseInt(att.getNodeValue());
                    L2MapRegion region = new L2MapRegion(name, town, locId, castle, bbs);
                    for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                        if ("respawnPoint".equalsIgnoreCase(c.getNodeName())) {
                            boolean banish;
                            attrs = c.getAttributes();
                            int spawnX = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                            int spawnY = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                            int spawnZ = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                            Node val = attrs.getNamedItem("isOther");
                            boolean other = val != null && Boolean.parseBoolean(val.getNodeValue());
                            val = attrs.getNamedItem("isChaotic");
                            boolean chaotic = val != null && Boolean.parseBoolean(val.getNodeValue());
                            val = attrs.getNamedItem("isBanish");
                            boolean bl = banish = val != null && Boolean.parseBoolean(val.getNodeValue());
                            if (other) {
                                region.addOtherSpawn(spawnX, spawnY, spawnZ);
                                continue;
                            }
                            if (chaotic) {
                                region.addChaoticSpawn(spawnX, spawnY, spawnZ);
                                continue;
                            }
                            if (banish) {
                                region.addBanishSpawn(spawnX, spawnY, spawnZ);
                                continue;
                            }
                            region.addSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        if ("map".equalsIgnoreCase(c.getNodeName())) {
                            attrs = c.getAttributes();
                            int mapX = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                            int mapY = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                            region.addMap(mapX, mapY);
                            continue;
                        }
                        if (!"banned".equalsIgnoreCase(c.getNodeName())) continue;
                        attrs = c.getAttributes();
                        String race = attrs.getNamedItem("race").getNodeValue();
                        String point = attrs.getNamedItem("point").getNodeValue();
                        region.addBannedRace(race, point);
                    }
                    _regions.put(name, region);
                }
            }
        } else {
            _log.severe("MapRegion file (" + file.getAbsolutePath() + ") doesnt exists.");
        }
    }

    public final L2MapRegion getMapRegion(int locX, int locY) {
        for (L2MapRegion region : _regions.values()) {
            if (!region.isZoneInRegion(this.getMapRegionX(locX), this.getMapRegionY(locY))) continue;
            return region;
        }
        return null;
    }

    public final int getMapRegionId(int locX, int locY) {
        L2MapRegion region = this.getMapRegion(locX, locY);
        if (region != null) {
            return region.getLocId();
        }
        if (Config.DEBUG_PATH) {
            _log.log(Level.WARNING, "MapRegionManager: Player outside map regions at X,Y=" + locX + "," + locY);
        }
        return 0;
    }

    public final L2MapRegion getMapRegion(L2Object obj) {
        return this.getMapRegion(obj.getX(), obj.getY());
    }

    public final int getMapRegionId(L2Object obj) {
        return this.getMapRegionId(obj.getX(), obj.getY());
    }

    public final int getMapRegionX(int posX) {
        return (posX >> 15) + 9 + 11;
    }

    public final int getMapRegionY(int posY) {
        return (posY >> 15) + 10 + 8;
    }

    public L2MapRegion getClosestTown(int x, int y) {
        return this.getMapRegion(x, y);
    }

    public String getClosestTownName(int x, int y) {
        L2MapRegion region = this.getMapRegion(x, y);
        if (region == null) {
            return "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
        }
        return region.getTown();
    }

    public String getClosestTownName(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
        }
        return region.getTown();
    }

    public int getAreaCastle(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return 0;
        }
        return region.getCastle();
    }

    public Location getTeleToLocation(L2Character activeChar, TeleportWhereType teleportWhere) {
        if (activeChar instanceof L2PcInstance) {
            int[] coord;
            Instance inst;
            L2ZoneType zone;
            L2PcInstance player = (L2PcInstance)activeChar;
            Castle castle = null;
            Fort fort = null;
            ClanHall clanhall = null;
            if (player.getClan() != null && !player.isFlyingMounted() && !player.isFlying()) {
                if (teleportWhere == TeleportWhereType.ClanHall && (clanhall = ClanHallManager.getInstance().getClanHallByOwner(player.getClan())) != null && (zone = clanhall.getZone()) != null && !player.isFlyingMounted()) {
                    if (player.getKarma() > 0) {
                        return ((L2ZoneRespawn)zone).getChaoticSpawnLoc();
                    }
                    return ((L2ZoneRespawn)zone).getSpawnLoc();
                }
                if (teleportWhere == TeleportWhereType.Castle) {
                    castle = CastleManager.getInstance().getCastleByOwner(player.getClan());
                    if (!(castle != null || (castle = CastleManager.getInstance().getCastle(player)) != null && castle.getSiege().getIsInProgress() && castle.getSiege().getDefenderClan(player.getClan()) != null)) {
                        castle = null;
                    }
                    if (castle != null && castle.getCastleId() > 0) {
                        if (player.getKarma() > 0) {
                            return castle.getCastleZone().getChaoticSpawnLoc();
                        }
                        return castle.getCastleZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.Fortress) {
                    fort = FortManager.getInstance().getFortByOwner(player.getClan());
                    if (!(fort != null || (fort = FortManager.getInstance().getFort(player)) != null && fort.getSiege().getIsInProgress() && fort.getOwnerClan() == player.getClan())) {
                        fort = null;
                    }
                    if (fort != null && fort.getFortId() > 0) {
                        if (player.getKarma() > 0) {
                            return fort.getFortZone().getChaoticSpawnLoc();
                        }
                        return fort.getFortZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.SiegeFlag) {
                    List<L2Npc> flags;
                    castle = CastleManager.getInstance().getCastle(player);
                    fort = FortManager.getInstance().getFort(player);
                    L2SiegeFlagInstance tw_flag = TerritoryWarManager.getInstance().getFlagForClan(player.getClan());
                    if (tw_flag != null) {
                        return new Location(tw_flag.getX(), tw_flag.getY(), tw_flag.getZ());
                    }
                    if (castle != null) {
                        List<L2Npc> flags2;
                        if (castle.getSiege().getIsInProgress() && (flags2 = castle.getSiege().getFlag(player.getClan())) != null && !flags2.isEmpty()) {
                            L2Npc flag = flags2.get(0);
                            return new Location(flag.getX(), flag.getY(), flag.getZ());
                        }
                    } else if (fort != null && fort.getSiege().getIsInProgress() && (flags = fort.getSiege().getFlag(player.getClan())) != null && !flags.isEmpty()) {
                        L2Npc flag = flags.get(0);
                        return new Location(flag.getX(), flag.getY(), flag.getZ());
                    }
                }
            }
            if (teleportWhere == TeleportWhereType.Castle_banish) {
                castle = CastleManager.getInstance().getCastle(player);
                if (castle != null) {
                    return castle.getCastleZone().getBanishSpawnLoc();
                }
            } else if (teleportWhere == TeleportWhereType.Fortress_banish) {
                fort = FortManager.getInstance().getFort(activeChar);
                if (fort != null) {
                    return fort.getFortZone().getBanishSpawnLoc();
                }
            } else if (teleportWhere == TeleportWhereType.ClanHall_banish && (clanhall = ClanHallManager.getInstance().getClanHall(activeChar)) != null) {
                return clanhall.getZone().getBanishSpawnLoc();
            }
            if (player.getKarma() > 0) {
                try {
                    zone = ZoneManager.getInstance().getZone(player, L2RespawnZone.class);
                    if (zone != null) {
                        return this.getRestartRegion(activeChar, ((L2RespawnZone)zone).getRespawnPoint((L2PcInstance)activeChar)).getChaoticSpawnLoc();
                    }
                    return this.getMapRegion(activeChar).getChaoticSpawnLoc();
                }
                catch (Exception e) {
                    if (player.isFlyingMounted()) {
                        return _regions.get("union_base_of_kserth").getChaoticSpawnLoc();
                    }
                    return _regions.get("talking_island_town").getChaoticSpawnLoc();
                }
            }
            castle = CastleManager.getInstance().getCastle(player);
            if (castle != null && castle.getSiege().getIsInProgress() && (castle.getSiege().checkIsDefender(player.getClan()) || castle.getSiege().checkIsAttacker(player.getClan())) && SevenSigns.getInstance().getSealOwner(3) == 2) {
                return castle.getCastleZone().getOtherSpawnLoc();
            }
            if (player.getInstanceId() > 0 && (inst = InstanceManager.getInstance().getInstance(player.getInstanceId())) != null && (coord = inst.getSpawnLoc())[0] != 0 && coord[1] != 0 && coord[2] != 0) {
                return new Location(coord[0], coord[1], coord[2]);
            }
        }
        try {
            L2RespawnZone zone = ZoneManager.getInstance().getZone(activeChar, L2RespawnZone.class);
            if (zone != null) {
                return this.getRestartRegion(activeChar, zone.getRespawnPoint((L2PcInstance)activeChar)).getSpawnLoc();
            }
            return this.getMapRegion(activeChar).getSpawnLoc();
        }
        catch (Exception e) {
            if (Config.DEBUG) {
                _log.log(Level.WARNING, "Not defined respawn point for coords loc X=" + activeChar.getX() + " Y=" + activeChar.getY() + " Z=" + activeChar.getZ());
            }
            return _regions.get("talking_island_town").getSpawnLoc();
        }
    }

    public L2MapRegion getRestartRegion(L2Character activeChar, String point) {
        try {
            L2PcInstance player = (L2PcInstance)activeChar;
            L2MapRegion region = _regions.get(point);
            if (region.getBannedRace().containsKey((Object)player.getRace())) {
                this.getRestartRegion(player, region.getBannedRace().get((Object)player.getRace()));
            }
            return region;
        }
        catch (Exception e) {
            return _regions.get("talking_island_town");
        }
    }

    private static class SingletonHolder {
        protected static final MapRegionManager _instance = new MapRegionManager();

        private SingletonHolder() {
        }
    }

    public static enum TeleportWhereType {
        Castle,
        Castle_banish,
        ClanHall,
        ClanHall_banish,
        SiegeFlag,
        Town,
        Fortress,
        Fortress_banish,
        Territory,
        Territory_banish;

    }
}

