/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExManagePartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.List;
import javolution.util.FastList;

public class PartyMatchRoom {
    private int _id;
    private String _title;
    private int _loot;
    private int _location;
    private int _minlvl;
    private int _maxlvl;
    private int _maxmem;
    private final List<L2PcInstance> _members = new FastList();

    public PartyMatchRoom(int id, String title, int loot, int minlvl, int maxlvl, int maxmem, L2PcInstance owner) {
        this._id = id;
        this._title = title;
        this._loot = loot;
        this._location = MapRegionManager.getInstance().getMapRegion(owner).getBbs();
        this._minlvl = minlvl;
        this._maxlvl = maxlvl;
        this._maxmem = maxmem;
        this._members.add(owner);
    }

    public List<L2PcInstance> getPartyMembers() {
        return this._members;
    }

    public void addMember(L2PcInstance player) {
        this._members.add(player);
    }

    public void deleteMember(L2PcInstance player) {
        if (player != this.getOwner()) {
            this._members.remove(player);
            this.notifyMembersAboutExit(player);
        } else if (this._members.size() == 1) {
            PartyMatchRoomList.getInstance().deleteRoom(this._id);
        } else {
            this.changeLeader(this._members.get(1));
            this.deleteMember(player);
        }
    }

    public void notifyMembersAboutExit(L2PcInstance player) {
        for (L2PcInstance _member : this.getPartyMembers()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_LEFT_PARTY_ROOM);
            sm.addCharName(player);
            _member.sendPacket(sm);
            _member.sendPacket(new ExManagePartyRoomMember(player, this, 2));
        }
    }

    public void changeLeader(L2PcInstance newLeader) {
        L2PcInstance oldLeader = this._members.get(0);
        this._members.remove(newLeader);
        this._members.set(0, newLeader);
        this._members.add(oldLeader);
        for (L2PcInstance member : this.getPartyMembers()) {
            member.sendPacket(new ExManagePartyRoomMember(newLeader, this, 1));
            member.sendPacket(new ExManagePartyRoomMember(oldLeader, this, 1));
            member.sendPacket(SystemMessageId.PARTY_ROOM_LEADER_CHANGED);
        }
    }

    public int getId() {
        return this._id;
    }

    public int getLootType() {
        return this._loot;
    }

    public int getMinLvl() {
        return this._minlvl;
    }

    public int getMaxLvl() {
        return this._maxlvl;
    }

    public int getLocation() {
        return this._location;
    }

    public int getMembers() {
        return this._members.size();
    }

    public int getMaxMembers() {
        return this._maxmem;
    }

    public String getTitle() {
        return this._title;
    }

    public L2PcInstance getOwner() {
        return this._members.get(0);
    }

    public void setMinLvl(int minlvl) {
        this._minlvl = minlvl;
    }

    public void setMaxLvl(int maxlvl) {
        this._maxlvl = maxlvl;
    }

    public void setLocation(int loc) {
        this._location = loc;
    }

    public void setLootType(int loot) {
        this._loot = loot;
    }

    public void setMaxMembers(int maxmem) {
        this._maxmem = maxmem;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

