/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2FameManagerInstance
extends L2Npc {
    public L2FameManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FameManagerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (actualCommand.equalsIgnoreCase("PK_Count")) {
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            if (player.getFame() >= 5000 && player.getClassId().level() >= 2 && player.getClan() != null && player.getClan().getLevel() >= 5) {
                if (player.getPkKills() > 0) {
                    player.setFame(player.getFame() - 5000);
                    player.setPkKills(player.getPkKills() - 1);
                    player.sendPacket(new UserInfo(player));
                    player.sendPacket(new ExBrExtraUserInfo(player));
                    html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-3.htm");
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-4.htm");
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-lowfame.htm");
            }
            this.sendHtmlMessage(player, html);
            return;
        }
        if (actualCommand.equalsIgnoreCase("CRP")) {
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            if (player.getClan() != null && player.getClan().getLevel() >= 5) {
                if (player.getFame() >= 1000 && player.getClassId().level() >= 2) {
                    player.setFame(player.getFame() - 1000);
                    player.sendPacket(new UserInfo(player));
                    player.sendPacket(new ExBrExtraUserInfo(player));
                    player.getClan().addReputationScore(50, true);
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_50_CLAN_FAME_POINTS));
                    html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-5.htm");
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-lowfame.htm");
                }
            } else {
                html.setFile(player.getHtmlPrefix(), "data/html/famemanager/" + this.getNpcId() + "-noclan.htm");
            }
            this.sendHtmlMessage(player, html);
            return;
        }
        super.onBypassFeedback(player, command);
    }

    private void sendHtmlMessage(L2PcInstance player, NpcHtmlMessage html) {
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/famemanager/" + this.getNpcId() + "-lowfame.htm";
        if (player.getFame() > 0) {
            filename = "data/html/famemanager/" + this.getNpcId() + ".htm";
        }
        NpcHtmlMessage html = new NpcHtmlMessage(1);
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }
}

