/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2FeedableBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Point3D;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.Future;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class L2TamedBeastInstance
extends L2FeedableBeastInstance {
    private int _foodSkillId;
    private static final int MAX_DISTANCE_FROM_HOME = 30000;
    private static final int MAX_DISTANCE_FROM_OWNER = 2000;
    private static final int MAX_DURATION = 1200000;
    private static final int DURATION_CHECK_INTERVAL = 60000;
    private static final int DURATION_INCREASE_INTERVAL = 20000;
    private static final int BUFF_INTERVAL = 5000;
    private int _remainingTime = 1200000;
    private int _homeX;
    private int _homeY;
    private int _homeZ;
    private L2PcInstance _owner;
    private Future<?> _buffTask = null;
    private Future<?> _durationCheckTask = null;
    private static boolean _isFreyaBeast;
    private List<L2Skill> _beastSkills = null;

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TamedBeastInstance);
        this.setHome(this);
    }

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int foodSkillId, int x, int y, int z) {
        super(objectId, template);
        _isFreyaBeast = false;
        this.setInstanceType(L2Object.InstanceType.L2TamedBeastInstance);
        this.setCurrentHp(this.getMaxHp());
        this.setCurrentMp(this.getMaxMp());
        this.setOwner(owner);
        this.setFoodType(foodSkillId);
        this.setHome(x, y, z);
        this.spawnMe(x, y, z);
    }

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int food, int x, int y, int z, boolean isFreyaBeast) {
        super(objectId, template);
        _isFreyaBeast = isFreyaBeast;
        this.setInstanceType(L2Object.InstanceType.L2TamedBeastInstance);
        this.setCurrentHp(this.getMaxHp());
        this.setCurrentMp(this.getMaxMp());
        this.setFoodType(food);
        this.setHome(x, y, z);
        this.spawnMe(x, y, z);
        this.setOwner(owner);
        if (isFreyaBeast) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this._owner);
        }
    }

    public void onReceiveFood() {
        this._remainingTime += 20000;
        if (this._remainingTime > 1200000) {
            this._remainingTime = 1200000;
        }
    }

    public Point3D getHome() {
        return new Point3D(this._homeX, this._homeY, this._homeZ);
    }

    public void setHome(int x, int y, int z) {
        this._homeX = x;
        this._homeY = y;
        this._homeZ = z;
    }

    public void setHome(L2Character c) {
        this.setHome(c.getX(), c.getY(), c.getZ());
    }

    public int getRemainingTime() {
        return this._remainingTime;
    }

    public void setRemainingTime(int duration) {
        this._remainingTime = duration;
    }

    public int getFoodType() {
        return this._foodSkillId;
    }

    public void setFoodType(int foodItemId) {
        if (foodItemId > 0) {
            this._foodSkillId = foodItemId;
            if (this._durationCheckTask != null) {
                this._durationCheckTask.cancel(true);
            }
            this._durationCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckDuration(this), 60000L, 60000L);
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.getAI().stopFollow();
        if (this._buffTask != null) {
            this._buffTask.cancel(true);
        }
        if (this._durationCheckTask != null) {
            this._durationCheckTask.cancel(true);
        }
        if (this._owner != null && this._owner.getTrainedBeasts() != null) {
            this._owner.getTrainedBeasts().remove(this);
        }
        this._buffTask = null;
        this._durationCheckTask = null;
        this._owner = null;
        this._foodSkillId = 0;
        this._remainingTime = 0;
        return true;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !_isFreyaBeast;
    }

    public boolean isFreyaBeast() {
        return _isFreyaBeast;
    }

    public void addBeastSkill(L2Skill skill) {
        if (this._beastSkills == null) {
            this._beastSkills = new FastList();
        }
        this._beastSkills.add(skill);
    }

    public void castBeastSkills() {
        if (this._owner == null || this._beastSkills == null) {
            return;
        }
        int delay = 100;
        for (L2Skill skill : this._beastSkills) {
            ThreadPoolManager.getInstance().scheduleGeneral(new buffCast(skill), delay);
            delay += 100 + skill.getHitTime();
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new buffCast(null), delay);
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public void setOwner(L2PcInstance owner) {
        if (owner != null) {
            this._owner = owner;
            this.setTitle(owner.getName());
            this.setShowSummonAnimation(true);
            this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, owner));
            owner.addTrainedBeast(this);
            this.getAI().startFollow(this._owner, 100);
            if (!_isFreyaBeast) {
                int totalBuffsAvailable = 0;
                for (L2Skill skill : this.getTemplate().getSkills().values()) {
                    if (skill.getSkillType() != L2SkillType.BUFF) continue;
                    ++totalBuffsAvailable;
                }
                if (this._buffTask != null) {
                    this._buffTask.cancel(true);
                }
                this._buffTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckOwnerBuffs(this, totalBuffsAvailable), 5000L, 5000L);
            }
        } else {
            this.deleteMe();
        }
    }

    public boolean isTooFarFromHome() {
        return !this.isInsideRadius(this._homeX, this._homeY, this._homeZ, 30000, true, true);
    }

    @Override
    public void deleteMe() {
        if (this._buffTask != null) {
            this._buffTask.cancel(true);
        }
        this._durationCheckTask.cancel(true);
        this.stopHpMpRegeneration();
        if (this._owner != null && this._owner.getTrainedBeasts() != null) {
            this._owner.getTrainedBeasts().remove(this);
        }
        this.setTarget(null);
        this._buffTask = null;
        this._durationCheckTask = null;
        this._owner = null;
        this._foodSkillId = 0;
        this._remainingTime = 0;
        super.deleteMe();
    }

    public void onOwnerGotAttacked(L2Character attacker) {
        block8: {
            float HPRatio;
            block7: {
                if (this._owner == null || !this._owner.isOnline()) {
                    this.deleteMe();
                    return;
                }
                if (!this._owner.isInsideRadius(this, 2000, true, true)) {
                    this.getAI().startFollow(this._owner);
                    return;
                }
                if (this._owner.isDead() || _isFreyaBeast) {
                    return;
                }
                if (this.isCastingNow()) {
                    return;
                }
                HPRatio = (float)this._owner.getCurrentHp() / (float)this._owner.getMaxHp();
                if (!((double)HPRatio >= 0.8)) break block7;
                FastMap skills = (FastMap)this.getTemplate().getSkills();
                for (L2Skill skill : skills.values()) {
                    if (skill.getSkillType() != L2SkillType.DEBUFF || Rnd.get(3) >= 1 || attacker == null || attacker.getFirstEffect(skill) == null) continue;
                    this.sitCastAndFollow(skill, attacker);
                }
                break block8;
            }
            if (!((double)HPRatio < 0.5)) break block8;
            int chance = 1;
            if ((double)HPRatio < 0.25) {
                chance = 2;
            }
            FastMap skills = (FastMap)this.getTemplate().getSkills();
            for (L2Skill skill : skills.values()) {
                if (Rnd.get(5) >= chance || skill.getSkillType() != L2SkillType.HEAL && skill.getSkillType() != L2SkillType.HOT && skill.getSkillType() != L2SkillType.BALANCE_LIFE && skill.getSkillType() != L2SkillType.HEAL_PERCENT && skill.getSkillType() != L2SkillType.HEAL_STATIC && skill.getSkillType() != L2SkillType.COMBATPOINTHEAL && skill.getSkillType() != L2SkillType.CPHOT && skill.getSkillType() != L2SkillType.MANAHEAL && skill.getSkillType() != L2SkillType.MANA_BY_LEVEL && skill.getSkillType() != L2SkillType.MANAHEAL_PERCENT && skill.getSkillType() != L2SkillType.MANARECHARGE && skill.getSkillType() != L2SkillType.MPHOT) continue;
                this.sitCastAndFollow(skill, this._owner);
                return;
            }
        }
    }

    protected void sitCastAndFollow(L2Skill skill, L2Character target) {
        this.stopMove(null);
        this.broadcastPacket(new StopMove(this));
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this.setTarget(target);
        this.doCast(skill);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this._owner);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null || !this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(9, (int)this.getStatus().getCurrentHp());
            su.addAttribute(10, this.getMaxHp());
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else {
                player.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }

    private class CheckOwnerBuffs
    implements Runnable {
        private L2TamedBeastInstance _tamedBeast;
        private int _numBuffs;

        CheckOwnerBuffs(L2TamedBeastInstance tamedBeast, int numBuffs) {
            this._tamedBeast = tamedBeast;
            this._numBuffs = numBuffs;
        }

        @Override
        public void run() {
            L2PcInstance owner = this._tamedBeast.getOwner();
            if (owner == null || !owner.isOnline()) {
                L2TamedBeastInstance.this.deleteMe();
                return;
            }
            if (!L2TamedBeastInstance.this.isInsideRadius(owner, 2000, true, true)) {
                L2TamedBeastInstance.this.getAI().startFollow(owner);
                return;
            }
            if (owner.isDead()) {
                return;
            }
            if (L2TamedBeastInstance.this.isCastingNow()) {
                return;
            }
            int totalBuffsOnOwner = 0;
            int i = 0;
            int rand = Rnd.get(this._numBuffs);
            L2Skill buffToGive = null;
            FastMap skills = (FastMap)this._tamedBeast.getTemplate().getSkills();
            for (L2Skill skill : skills.values()) {
                if (skill.getSkillType() != L2SkillType.BUFF) continue;
                if (i++ == rand) {
                    buffToGive = skill;
                }
                if (owner.getFirstEffect(skill) == null) continue;
                ++totalBuffsOnOwner;
            }
            if (this._numBuffs * 2 / 3 > totalBuffsOnOwner) {
                this._tamedBeast.sitCastAndFollow(buffToGive, owner);
            }
            L2TamedBeastInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this._tamedBeast.getOwner());
        }
    }

    private static class CheckDuration
    implements Runnable {
        private L2TamedBeastInstance _tamedBeast;

        CheckDuration(L2TamedBeastInstance tamedBeast) {
            this._tamedBeast = tamedBeast;
        }

        @Override
        public void run() {
            int foodTypeSkillId = this._tamedBeast.getFoodType();
            L2PcInstance owner = this._tamedBeast.getOwner();
            L2ItemInstance item = null;
            if (_isFreyaBeast) {
                item = owner.getInventory().getItemByItemId(foodTypeSkillId);
                if (item != null && item.getCount() >= 1L) {
                    owner.destroyItem("BeastMob", item, 1L, (L2Object)this._tamedBeast, true);
                    this._tamedBeast.broadcastPacket(new SocialAction(this._tamedBeast, 3));
                } else {
                    this._tamedBeast.deleteMe();
                }
            } else {
                this._tamedBeast.setRemainingTime(this._tamedBeast.getRemainingTime() - 60000);
                if (foodTypeSkillId == 2188) {
                    item = owner.getInventory().getItemByItemId(6643);
                } else if (foodTypeSkillId == 2189) {
                    item = owner.getInventory().getItemByItemId(6644);
                }
                if (item != null && item.getCount() >= 1L) {
                    L2Object oldTarget = owner.getTarget();
                    owner.setTarget(this._tamedBeast);
                    L2Object[] targets = new L2Object[]{this._tamedBeast};
                    owner.callSkill(SkillTable.getInstance().getInfo(foodTypeSkillId, 1), targets);
                    owner.setTarget(oldTarget);
                } else if (this._tamedBeast.getRemainingTime() < 900000) {
                    this._tamedBeast.setRemainingTime(-1);
                }
                if (this._tamedBeast.getRemainingTime() <= 0) {
                    this._tamedBeast.deleteMe();
                }
            }
        }
    }

    private class buffCast
    implements Runnable {
        private L2Skill _skill;

        public buffCast(L2Skill skill) {
            this._skill = skill;
        }

        @Override
        public void run() {
            if (this._skill == null) {
                L2TamedBeastInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, L2TamedBeastInstance.this._owner);
            } else {
                L2TamedBeastInstance.this.sitCastAndFollow(this._skill, L2TamedBeastInstance.this._owner);
            }
        }
    }
}

