/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.zone.type.L2SwampZone;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import java.util.logging.Logger;

public class PlayableStat
extends CharStat {
    protected static final Logger _log = Logger.getLogger(PlayableStat.class.getName());

    public PlayableStat(L2Playable activeChar) {
        super(activeChar);
    }

    public boolean addExp(long value) {
        int level;
        if (this.getExp() + value < 0L || value > 0L && this.getExp() == this.getExpForLevel(this.getMaxLevel()) - 1L) {
            return true;
        }
        if (this.getExp() + value >= this.getExpForLevel(this.getMaxLevel())) {
            value = this.getExpForLevel(this.getMaxLevel()) - 1L - this.getExp();
        }
        this.setExp(this.getExp() + value);
        int minimumLevel = 1;
        if (this.getActiveChar() instanceof L2PetInstance) {
            minimumLevel = (byte)PetDataTable.getInstance().getPetMinLevel(((L2PetInstance)this.getActiveChar()).getTemplate().npcId);
        }
        for (int tmp = level = minimumLevel; tmp <= this.getMaxLevel(); tmp = (int)((byte)(tmp + 1))) {
            if (this.getExp() >= this.getExpForLevel(tmp)) continue;
            level = tmp = (int)((byte)(tmp - 1));
            break;
        }
        if (level != this.getLevel() && level >= minimumLevel) {
            this.addLevel((byte)(level - this.getLevel()));
        }
        return true;
    }

    public boolean removeExp(long value) {
        int level;
        if (this.getExp() - value < 0L) {
            value = this.getExp() - 1L;
        }
        this.setExp(this.getExp() - value);
        int minimumLevel = 1;
        if (this.getActiveChar() instanceof L2PetInstance) {
            minimumLevel = (byte)PetDataTable.getInstance().getPetMinLevel(((L2PetInstance)this.getActiveChar()).getTemplate().npcId);
        }
        for (int tmp = level = minimumLevel; tmp <= this.getMaxLevel(); tmp = (int)((byte)(tmp + 1))) {
            if (this.getExp() >= this.getExpForLevel(tmp)) continue;
            level = tmp = (int)((byte)(tmp - 1));
            break;
        }
        if (level != this.getLevel() && level >= minimumLevel) {
            this.addLevel((byte)(level - this.getLevel()));
        }
        return true;
    }

    public boolean addExpAndSp(long addToExp, int addToSp) {
        boolean expAdded = false;
        boolean spAdded = false;
        if (addToExp >= 0L) {
            expAdded = this.addExp(addToExp);
        }
        if (addToSp >= 0) {
            spAdded = this.addSp(addToSp);
        }
        return expAdded || spAdded;
    }

    public boolean removeExpAndSp(long removeExp, int removeSp) {
        boolean expRemoved = false;
        boolean spRemoved = false;
        if (removeExp > 0L) {
            expRemoved = this.removeExp(removeExp);
        }
        if (removeSp > 0) {
            spRemoved = this.removeSp(removeSp);
        }
        return expRemoved || spRemoved;
    }

    public boolean addLevel(byte value) {
        if (this.getLevel() + value > this.getMaxLevel() - 1) {
            if (this.getLevel() < this.getMaxLevel() - 1) {
                value = (byte)(this.getMaxLevel() - 1 - this.getLevel());
            } else {
                return false;
            }
        }
        boolean levelIncreased = this.getLevel() + value > this.getLevel();
        value = (byte)(value + this.getLevel());
        this.setLevel(value);
        if (this.getExp() >= this.getExpForLevel(this.getLevel() + 1) || this.getExpForLevel(this.getLevel()) > this.getExp()) {
            this.setExp(this.getExpForLevel(this.getLevel()));
        }
        if (!levelIncreased && this.getActiveChar() instanceof L2PcInstance && !((L2PcInstance)this.getActiveChar()).isGM() && Config.DECREASE_SKILL_LEVEL) {
            ((L2PcInstance)this.getActiveChar()).checkPlayerSkills();
        }
        if (!levelIncreased) {
            return false;
        }
        this.getActiveChar().getStatus().setCurrentHp(this.getActiveChar().getStat().getMaxHp());
        this.getActiveChar().getStatus().setCurrentMp(this.getActiveChar().getStat().getMaxMp());
        if (this.getActiveChar() instanceof L2PcInstance) {
            CommunityServerThread.getInstance().sendPacket(new WorldInfo((L2PcInstance)this.getActiveChar(), null, 1));
        }
        return true;
    }

    public boolean addSp(int value) {
        if (value < 0) {
            _log.warning("wrong usage");
            return false;
        }
        int currentSp = this.getSp();
        if (currentSp == Integer.MAX_VALUE) {
            return false;
        }
        if (currentSp > Integer.MAX_VALUE - value) {
            value = Integer.MAX_VALUE - currentSp;
        }
        this.setSp(currentSp + value);
        return true;
    }

    public boolean removeSp(int value) {
        int currentSp = this.getSp();
        if (currentSp < value) {
            value = currentSp;
        }
        this.setSp(this.getSp() - value);
        return true;
    }

    public long getExpForLevel(int level) {
        return level;
    }

    @Override
    public int getRunSpeed() {
        int val = super.getRunSpeed();
        if (this.getActiveChar().isInsideZone((byte)7)) {
            val /= 2;
        }
        if (this.getActiveChar().isInsideZone((byte)11)) {
            L2SwampZone zone = ZoneManager.getInstance().getZone(this.getActiveChar(), L2SwampZone.class);
            int bonus = zone == null ? 0 : zone.getMoveBonus();
            double dbonus = (double)bonus / 100.0;
            val = (int)((double)val + (double)val * dbonus);
        }
        return val;
    }

    @Override
    public L2Playable getActiveChar() {
        return (L2Playable)super.getActiveChar();
    }

    public int getMaxLevel() {
        return ExperienceTable.getInstance().getMaxLevel();
    }
}

