/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.waypoint;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.util.Point3D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javolution.util.FastList;

public class WayPointNode
extends L2Object {
    private int _id;
    private String _title;
    private String _type;
    private static final String NORMAL = "Node";
    private static final String SELECTED = "Selected";
    private static final String LINKED = "Linked";
    private static int _lineId = 5560;
    private static final String LINE_TYPE = "item";
    private Map<WayPointNode, List<WayPointNode>> _linkLists = Collections.synchronizedMap(new WeakHashMap());

    public WayPointNode(int objectId) {
        super(objectId);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    public static WayPointNode spawn(String type, int id, int x, int y, int z) {
        WayPointNode newNode = new WayPointNode(IdFactory.getInstance().getNextId());
        newNode.getPoly().setPolyInfo(type, id + "");
        newNode.spawnMe(x, y, z);
        return newNode;
    }

    public static WayPointNode spawn(boolean isItemId, int id, L2PcInstance player) {
        return WayPointNode.spawn(isItemId ? LINE_TYPE : "npc", id, player.getX(), player.getY(), player.getZ());
    }

    public static WayPointNode spawn(boolean isItemId, int id, Point3D point) {
        return WayPointNode.spawn(isItemId ? LINE_TYPE : "npc", id, point.getX(), point.getY(), point.getZ());
    }

    public static WayPointNode spawn(Point3D point) {
        return WayPointNode.spawn(Config.NEW_NODE_TYPE, Config.NEW_NODE_ID, point.getX(), point.getY(), point.getZ());
    }

    public static WayPointNode spawn(L2PcInstance player) {
        return WayPointNode.spawn(Config.NEW_NODE_TYPE, Config.NEW_NODE_ID, player.getX(), player.getY(), player.getZ());
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player.getTarget() != this) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
        }
    }

    public void setNormalInfo(String type, int id, String title) {
        this._type = type;
        this.changeID(id, title);
    }

    public void setNormalInfo(String type, int id) {
        this._type = type;
        this.changeID(id);
    }

    private void changeID(int id) {
        this._id = id;
        this.toggleVisible();
        this.toggleVisible();
    }

    private void changeID(int id, String title) {
        this.setName(title);
        this.setTitle(title);
        this.changeID(id);
    }

    public void setLinked() {
        this.changeID(Config.LINKED_NODE_ID, LINKED);
    }

    public void setNormal() {
        this.changeID(Config.NEW_NODE_ID, NORMAL);
    }

    public void setSelected() {
        this.changeID(Config.SELECTED_NODE_ID, SELECTED);
    }

    @Override
    public boolean isMarker() {
        return true;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String title) {
        this._title = title;
    }

    public int getId() {
        return this._id;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public static void drawLine(WayPointNode nodeA, WayPointNode nodeB) {
        int x1 = nodeA.getX();
        int y1 = nodeA.getY();
        int z1 = nodeA.getZ();
        int x2 = nodeB.getX();
        int y2 = nodeB.getY();
        int z2 = nodeB.getZ();
        int modX = x1 - x2 > 0 ? -1 : 1;
        int modY = y1 - y2 > 0 ? -1 : 1;
        int modZ = z1 - z2 > 0 ? -1 : 1;
        int diffX = Math.abs(x1 - x2);
        int diffY = Math.abs(y1 - y2);
        int diffZ = Math.abs(z1 - z2);
        int distance = (int)Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
        int steps = distance / 40;
        FastList lineNodes = new FastList();
        for (int i = 0; i < steps; ++i) {
            lineNodes.add(WayPointNode.spawn(LINE_TYPE, _lineId, x1 += modX * diffX / steps, y1 += modY * diffY / steps, z1 += modZ * diffZ / steps));
        }
        nodeA.addLineInfo(nodeB, (List<WayPointNode>)lineNodes);
        nodeB.addLineInfo(nodeA, (List<WayPointNode>)lineNodes);
    }

    public void addLineInfo(WayPointNode node, List<WayPointNode> line) {
        this._linkLists.put(node, line);
    }

    public static void eraseLine(WayPointNode target, WayPointNode selectedNode) {
        List<WayPointNode> lineNodes = target.getLineInfo(selectedNode);
        if (lineNodes == null) {
            return;
        }
        for (WayPointNode node : lineNodes) {
            node.decayMe();
        }
        target.eraseLine(selectedNode);
        selectedNode.eraseLine(target);
    }

    public void eraseLine(WayPointNode target) {
        this._linkLists.remove(target);
    }

    private List<WayPointNode> getLineInfo(WayPointNode selectedNode) {
        return this._linkLists.get(selectedNode);
    }

    public static void setLineId(int line_id) {
        _lineId = line_id;
    }

    public List<WayPointNode> getLineNodes() {
        FastList list = new FastList();
        for (List<WayPointNode> points : this._linkLists.values()) {
            list.addAll(points);
        }
        return list;
    }
}

