/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.EnchantGroupsTable;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import java.util.logging.Logger;

public final class RequestExEnchantSkillInfoDetail
extends L2GameClientPacket {
    private static final String _C_D0_46_REQUESTEXENCHANTSKILLINFO = "[C] D0:46 RequestExEnchantSkillInfoDetail";
    protected static final Logger _log = Logger.getLogger(RequestExEnchantSkillInfoDetail.class.getName());
    private int _type;
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._type = this.readD();
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int reqSkillLvl = -2;
        if (this._type == 0 || this._type == 1) {
            reqSkillLvl = this._skillLvl - 1;
        } else if (this._type == 2) {
            reqSkillLvl = this._skillLvl + 1;
        } else if (this._type == 3) {
            reqSkillLvl = this._skillLvl;
        }
        int playerSkillLvl = activeChar.getSkillLevel(this._skillId);
        if (playerSkillLvl == -1) {
            return;
        }
        if (reqSkillLvl % 100 == 0) {
            L2EnchantSkillLearn esl = EnchantGroupsTable.getInstance().getSkillEnchantmentBySkillId(this._skillId);
            if (esl == null) return;
            if (playerSkillLvl != esl.getBaseLevel()) {
                return;
            }
        } else if (playerSkillLvl != reqSkillLvl && this._type == 3 && playerSkillLvl % 100 != this._skillLvl % 100) {
            return;
        }
        ExEnchantSkillInfoDetail esd = new ExEnchantSkillInfoDetail(this._type, this._skillId, this._skillLvl, activeChar);
        activeChar.sendPacket(esd);
    }

    @Override
    public String getType() {
        return _C_D0_46_REQUESTEXENCHANTSKILLINFO;
    }
}

