/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExVariationCancelResult;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestRefineCancel
extends L2GameClientPacket {
    private static final String _C__D0_43_REQUESTREFINECANCEL = "[C] D0:43 RequestRefineCancel";
    private int _targetItemObjId;

    @Override
    protected void readImpl() {
        this._targetItemObjId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = activeChar.getInventory().getItemByObjectId(this._targetItemObjId);
        if (targetItem == null) {
            activeChar.sendPacket(new ExVariationCancelResult(0));
            return;
        }
        if (targetItem.getOwnerId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(((L2GameClient)this.getClient()).getActiveChar(), "Warning!! Character " + ((L2GameClient)this.getClient()).getActiveChar().getName() + " of account " + ((L2GameClient)this.getClient()).getActiveChar().getAccountName() + " tryied to augment item that doesn't own.", Config.DEFAULT_PUNISH);
            return;
        }
        if (!targetItem.isAugmented()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.AUGMENTATION_REMOVAL_CAN_ONLY_BE_DONE_ON_AN_AUGMENTED_ITEM));
            activeChar.sendPacket(new ExVariationCancelResult(0));
            return;
        }
        int price = 0;
        switch (targetItem.getItem().getCrystalType()) {
            case 2: {
                if (targetItem.getCrystalCount() < 1720) {
                    price = 95000;
                    break;
                }
                if (targetItem.getCrystalCount() < 2452) {
                    price = 150000;
                    break;
                }
                price = 210000;
                break;
            }
            case 3: {
                if (targetItem.getCrystalCount() < 1746) {
                    price = 240000;
                    break;
                }
                price = 270000;
                break;
            }
            case 4: {
                if (targetItem.getCrystalCount() < 2160) {
                    price = 330000;
                    break;
                }
                if (targetItem.getCrystalCount() < 2824) {
                    price = 390000;
                    break;
                }
                price = 420000;
                break;
            }
            case 5: {
                price = 480000;
                break;
            }
            case 6: 
            case 7: {
                price = 920000;
                break;
            }
            default: {
                activeChar.sendPacket(new ExVariationCancelResult(0));
                return;
            }
        }
        if (!activeChar.reduceAdena("RequestRefineCancel", price, null, true)) {
            activeChar.sendPacket(new ExVariationCancelResult(0));
            activeChar.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            return;
        }
        if (targetItem.isEquipped()) {
            activeChar.disarmWeapons();
        }
        targetItem.removeAugmentation();
        activeChar.sendPacket(new ExVariationCancelResult(1));
        InventoryUpdate iu = new InventoryUpdate();
        iu.addModifiedItem(targetItem);
        activeChar.sendPacket(iu);
    }

    @Override
    public String getType() {
        return _C__D0_43_REQUESTREFINECANCEL;
    }
}

