/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class CharSelectionInfo
extends L2GameServerPacket {
    private static final String _S__09_CHARSELECTINFO = "[S] 09 CharSelectInfo";
    private static Logger _log = Logger.getLogger(CharSelectionInfo.class.getName());
    private String _loginName;
    private int _sessionId;
    private int _activeId;
    private CharSelectInfoPackage[] _characterPackages;

    public CharSelectionInfo(String loginName, int sessionId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = -1;
    }

    public CharSelectionInfo(String loginName, int sessionId, int activeId) {
        this._sessionId = sessionId;
        this._loginName = loginName;
        this._characterPackages = CharSelectionInfo.loadCharacterSelectInfo(this._loginName);
        this._activeId = activeId;
    }

    public CharSelectInfoPackage[] getCharInfo() {
        return this._characterPackages;
    }

    @Override
    protected final void writeImpl() {
        int i;
        this.writeC(9);
        int size = this._characterPackages.length;
        this.writeD(size);
        this.writeD(7);
        this.writeC(0);
        long lastAccess = 0L;
        if (this._activeId == -1) {
            for (i = 0; i < size; ++i) {
                if (lastAccess >= this._characterPackages[i].getLastAccess()) continue;
                lastAccess = this._characterPackages[i].getLastAccess();
                this._activeId = i;
            }
        }
        for (i = 0; i < size; ++i) {
            CharSelectInfoPackage charInfoPackage = this._characterPackages[i];
            this.writeS(charInfoPackage.getName());
            this.writeD(charInfoPackage.getCharId());
            this.writeS(this._loginName);
            this.writeD(this._sessionId);
            this.writeD(charInfoPackage.getClanId());
            this.writeD(0);
            this.writeD(charInfoPackage.getSex());
            this.writeD(charInfoPackage.getRace());
            if (charInfoPackage.getClassId() == charInfoPackage.getBaseClassId()) {
                this.writeD(charInfoPackage.getClassId());
            } else {
                this.writeD(charInfoPackage.getBaseClassId());
            }
            this.writeD(1);
            this.writeD(charInfoPackage.getX());
            this.writeD(charInfoPackage.getY());
            this.writeD(charInfoPackage.getZ());
            this.writeF(charInfoPackage.getCurrentHp());
            this.writeF(charInfoPackage.getCurrentMp());
            this.writeD(charInfoPackage.getSp());
            this.writeQ(charInfoPackage.getExp());
            this.writeF((float)(charInfoPackage.getExp() - ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel())) / (float)(ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel() + 1) - ExperienceTable.getInstance().getExpForLevel(charInfoPackage.getLevel())));
            this.writeD(charInfoPackage.getLevel());
            this.writeD(charInfoPackage.getKarma());
            this.writeD(charInfoPackage.getPkKills());
            this.writeD(charInfoPackage.getPvPKills());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(charInfoPackage.getPaperdollItemId(2));
            this.writeD(charInfoPackage.getPaperdollItemId(8));
            this.writeD(charInfoPackage.getPaperdollItemId(9));
            this.writeD(charInfoPackage.getPaperdollItemId(4));
            this.writeD(charInfoPackage.getPaperdollItemId(13));
            this.writeD(charInfoPackage.getPaperdollItemId(14));
            this.writeD(charInfoPackage.getPaperdollItemId(1));
            this.writeD(charInfoPackage.getPaperdollItemId(5));
            this.writeD(charInfoPackage.getPaperdollItemId(7));
            this.writeD(charInfoPackage.getPaperdollItemId(10));
            this.writeD(charInfoPackage.getPaperdollItemId(6));
            this.writeD(charInfoPackage.getPaperdollItemId(11));
            this.writeD(charInfoPackage.getPaperdollItemId(12));
            this.writeD(charInfoPackage.getPaperdollItemId(23));
            this.writeD(charInfoPackage.getPaperdollItemId(5));
            this.writeD(charInfoPackage.getPaperdollItemId(2));
            this.writeD(charInfoPackage.getPaperdollItemId(3));
            this.writeD(charInfoPackage.getPaperdollItemId(16));
            this.writeD(charInfoPackage.getPaperdollItemId(15));
            this.writeD(charInfoPackage.getPaperdollItemId(17));
            this.writeD(charInfoPackage.getPaperdollItemId(18));
            this.writeD(charInfoPackage.getPaperdollItemId(19));
            this.writeD(charInfoPackage.getPaperdollItemId(20));
            this.writeD(charInfoPackage.getPaperdollItemId(21));
            this.writeD(charInfoPackage.getPaperdollItemId(22));
            this.writeD(charInfoPackage.getPaperdollItemId(24));
            this.writeD(charInfoPackage.getHairStyle());
            this.writeD(charInfoPackage.getHairColor());
            this.writeD(charInfoPackage.getFace());
            this.writeF(charInfoPackage.getMaxHp());
            this.writeF(charInfoPackage.getMaxMp());
            long deleteTime = charInfoPackage.getDeleteTimer();
            int deletedays = 0;
            if (deleteTime > 0L) {
                deletedays = (int)((deleteTime - System.currentTimeMillis()) / 1000L);
            }
            this.writeD(deletedays);
            this.writeD(charInfoPackage.getClassId());
            if (i == this._activeId) {
                this.writeD(1);
            } else {
                this.writeD(0);
            }
            this.writeC(charInfoPackage.getEnchantEffect() > 127 ? 127 : charInfoPackage.getEnchantEffect());
            this.writeH(0);
            this.writeH(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeF(0.0);
            this.writeF(0.0);
            this.writeD(charInfoPackage.getVitalityPoints());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSelectInfoPackage[] loadCharacterSelectInfo(String loginName) {
        FastList characterList = new FastList();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT account_name, charId, char_name, level, maxHp, curHp, maxMp, curMp, face, hairStyle, hairColor, sex, heading, x, y, z, exp, sp, karma, pvpkills, pkkills, clanid, race, classid, deletetime, cancraft, title, accesslevel, online, char_slot, lastAccess, base_class, transform_id, language, vitality_points FROM characters WHERE account_name=?");
            statement.setString(1, loginName);
            ResultSet charList = statement.executeQuery();
            while (charList.next()) {
                CharSelectInfoPackage charInfopackage = CharSelectionInfo.restoreChar(charList);
                if (charInfopackage == null) continue;
                characterList.add(charInfopackage);
            }
            charList.close();
            statement.close();
            CharSelectInfoPackage[] charSelectInfoPackageArray = characterList.toArray(new CharSelectInfoPackage[characterList.size()]);
            return charSelectInfoPackageArray;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore char info: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return new CharSelectInfoPackage[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCharacterSubclassInfo(CharSelectInfoPackage charInfopackage, int ObjectId, int activeClassId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT exp, sp, level FROM character_subclasses WHERE charId=? && class_id=? ORDER BY charId");
            statement.setInt(1, ObjectId);
            statement.setInt(2, activeClassId);
            ResultSet charList = statement.executeQuery();
            if (charList.next()) {
                charInfopackage.setExp(charList.getLong("exp"));
                charInfopackage.setSp(charList.getInt("sp"));
                charInfopackage.setLevel(charList.getInt("level"));
            }
            charList.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore char subclass info: " + e.getMessage(), e);
        }
        finally {
            try {
                L2DatabaseFactory.close(con);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharSelectInfoPackage restoreChar(ResultSet chardata) throws Exception {
        int cursedWeaponId;
        int objectId = chardata.getInt("charId");
        String name = chardata.getString("char_name");
        long deletetime = chardata.getLong("deletetime");
        if (deletetime > 0L && System.currentTimeMillis() > deletetime) {
            L2Clan clan = ClanTable.getInstance().getClan(chardata.getInt("clanid"));
            if (clan != null) {
                clan.removeClanMember(objectId, 0L);
            }
            L2GameClient.deleteCharByObjId(objectId);
            return null;
        }
        CharSelectInfoPackage charInfopackage = new CharSelectInfoPackage(objectId, name);
        charInfopackage.setAccessLevel(chardata.getInt("accesslevel"));
        charInfopackage.setLevel(chardata.getInt("level"));
        charInfopackage.setMaxHp(chardata.getInt("maxhp"));
        charInfopackage.setCurrentHp(chardata.getDouble("curhp"));
        charInfopackage.setMaxMp(chardata.getInt("maxmp"));
        charInfopackage.setCurrentMp(chardata.getDouble("curmp"));
        charInfopackage.setKarma(chardata.getInt("karma"));
        charInfopackage.setPkKills(chardata.getInt("pkkills"));
        charInfopackage.setPvPKills(chardata.getInt("pvpkills"));
        charInfopackage.setFace(chardata.getInt("face"));
        charInfopackage.setHairStyle(chardata.getInt("hairstyle"));
        charInfopackage.setHairColor(chardata.getInt("haircolor"));
        charInfopackage.setSex(chardata.getInt("sex"));
        charInfopackage.setExp(chardata.getLong("exp"));
        charInfopackage.setSp(chardata.getInt("sp"));
        charInfopackage.setVitalityPoints(chardata.getInt("vitality_points"));
        charInfopackage.setClanId(chardata.getInt("clanid"));
        charInfopackage.setRace(chardata.getInt("race"));
        int baseClassId = chardata.getInt("base_class");
        int activeClassId = chardata.getInt("classid");
        charInfopackage.setX(chardata.getInt("x"));
        charInfopackage.setY(chardata.getInt("y"));
        charInfopackage.setZ(chardata.getInt("z"));
        if (Config.L2JMOD_MULTILANG_ENABLE) {
            String lang = chardata.getString("language");
            if (!Config.L2JMOD_MULTILANG_ALLOWED.contains(lang)) {
                lang = Config.L2JMOD_MULTILANG_DEFAULT;
            }
            charInfopackage.setHtmlPrefix("data/lang/" + lang + "/");
        }
        if (baseClassId != activeClassId) {
            CharSelectionInfo.loadCharacterSubclassInfo(charInfopackage, objectId, activeClassId);
        }
        charInfopackage.setClassId(activeClassId);
        int weaponObjId = charInfopackage.getPaperdollObjectId(5);
        if (weaponObjId < 1) {
            weaponObjId = charInfopackage.getPaperdollObjectId(5);
        }
        if ((cursedWeaponId = CursedWeaponsManager.getInstance().checkOwnsWeaponId(objectId)) > 0) {
            if (cursedWeaponId == 8190) {
                charInfopackage.setTransformId(301);
            } else if (cursedWeaponId == 8689) {
                charInfopackage.setTransformId(302);
            } else {
                charInfopackage.setTransformId(0);
            }
        } else if (chardata.getInt("transform_id") > 0) {
            charInfopackage.setTransformId(chardata.getInt("transform_id"));
        } else {
            charInfopackage.setTransformId(0);
        }
        if (weaponObjId > 0) {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("SELECT augAttributes FROM item_attributes WHERE itemId=?");
                statement.setInt(1, weaponObjId);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    int augment = result.getInt("augAttributes");
                    charInfopackage.setAugmentationId(augment == -1 ? 0 : augment);
                }
                result.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not restore augmentation info: " + e.getMessage(), e);
            }
            finally {
                try {
                    L2DatabaseFactory.close(con);
                }
                catch (Exception e) {}
            }
        }
        if (baseClassId == 0 && activeClassId > 0) {
            charInfopackage.setBaseClassId(activeClassId);
        } else {
            charInfopackage.setBaseClassId(baseClassId);
        }
        charInfopackage.setDeleteTimer(deletetime);
        charInfopackage.setLastAccess(chardata.getLong("lastAccess"));
        return charInfopackage;
    }

    @Override
    public String getType() {
        return _S__09_CHARSELECTINFO;
    }
}

