/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import javolution.util.FastList;

public class ListPartyWating
extends L2GameServerPacket {
    private static final String _S__9C_LISTPARTYWAITING = "[S] 9c ListPartyWating";
    private L2PcInstance _cha;
    private int _loc;
    private int _lim;
    private FastList<PartyMatchRoom> _rooms;

    public ListPartyWating(L2PcInstance player, int auto, int location, int limit) {
        this._cha = player;
        this._loc = location;
        this._lim = limit;
        this._rooms = new FastList();
    }

    @Override
    protected final void writeImpl() {
        for (PartyMatchRoom room : PartyMatchRoomList.getInstance().getRooms()) {
            if (room.getMembers() < 1 || room.getOwner() == null || !room.getOwner().isOnline() || room.getOwner().getPartyRoom() != room.getId()) {
                PartyMatchRoomList.getInstance().deleteRoom(room.getId());
                continue;
            }
            if (this._loc > 0 && this._loc != room.getLocation() || this._lim == 0 && (this._cha.getLevel() < room.getMinLvl() || this._cha.getLevel() > room.getMaxLvl())) continue;
            this._rooms.add((Object)room);
        }
        int size = this._rooms.size();
        this.writeC(156);
        if (size > 0) {
            this.writeD(1);
        } else {
            this.writeD(0);
        }
        this.writeD(this._rooms.size());
        for (PartyMatchRoom room : this._rooms) {
            this.writeD(room.getId());
            this.writeS(room.getTitle());
            this.writeD(room.getLocation());
            this.writeD(room.getMinLvl());
            this.writeD(room.getMaxLvl());
            this.writeD(room.getMaxMembers());
            this.writeS(room.getOwner().getName());
            this.writeD(room.getMembers());
            for (L2PcInstance member : room.getPartyMembers()) {
                if (member != null) {
                    this.writeD(member.getClassId().getId());
                    this.writeS(member.getName());
                    continue;
                }
                this.writeD(0);
                this.writeS("Not Found");
            }
        }
    }

    @Override
    public String getType() {
        return _S__9C_LISTPARTYWAITING;
    }
}

