/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class StaticObject
extends L2GameServerPacket {
    private final int _staticObjectId;
    private final int _objectId;
    private final int _type;
    private final boolean _isTargetable;
    private final int _meshIndex;
    private final boolean _isClosed;
    private final boolean _isEnemy;
    private final int _maxHp;
    private final int _currentHp;
    private final boolean _showHp;
    private final int _damageGrade;

    public StaticObject(L2StaticObjectInstance staticObject) {
        this._staticObjectId = staticObject.getStaticObjectId();
        this._objectId = staticObject.getObjectId();
        this._type = 0;
        this._isTargetable = true;
        this._meshIndex = staticObject.getMeshIndex();
        this._isClosed = false;
        this._isEnemy = false;
        this._maxHp = 0;
        this._currentHp = 0;
        this._showHp = false;
        this._damageGrade = 0;
    }

    public StaticObject(L2DoorInstance door, boolean showHp) {
        this._staticObjectId = door.getDoorId();
        this._objectId = door.getObjectId();
        this._type = 1;
        this._isTargetable = door.getTargetable();
        this._meshIndex = door.getMeshIndex();
        this._isClosed = !door.getOpen();
        this._isEnemy = door.isEnemy();
        this._maxHp = door.getMaxVisibleHp();
        this._currentHp = (int)door.getCurrentHp();
        this._showHp = door.getIsShowHp() || showHp;
        this._damageGrade = door.getDamage();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(159);
        this.writeD(this._staticObjectId);
        this.writeD(this._objectId);
        this.writeD(this._type);
        this.writeD(this._isTargetable ? 1 : 0);
        this.writeD(this._meshIndex);
        this.writeD(this._isClosed ? 1 : 0);
        this.writeD(this._isEnemy ? 1 : 0);
        this.writeD(this._currentHp);
        this.writeD(this._maxHp);
        this.writeD(this._showHp ? 1 : 0);
        this.writeD(this._damageGrade);
    }

    @Override
    public String getType() {
        return "[S] 9f StaticObject";
    }
}

